-- This version provides a precise implementation of formal aspect and component language (FACL), it has the following features:
------ it shows the base to view transformation as just one function call
------ before and after parts of wrappers are propagated as deeper as possible in the component structure with respect to the no wrapped view 
------ a dynamic wrapping is used rather than the satic one, in the sence that adding new wrappers will not affect the other already apllied wrappers
------ no identifiers are used to show the dependency between before and after parts of wrappers
------ adapters are considered to be added following a before wrapper rather than next to after 

module Config where 
 

type Primitive          = Int         ->   Int
type BWrapper           = Int         ->   (Int,Int)
type AWrapper           = (Int,Int)   ->   Int

-- Primitive Components

f :: Primitive
f a = a + 3

g :: Primitive
g a = a*2
  
h :: Primitive
h a = a -2 

-- Wrappers

before1 :: BWrapper
before1 a = (a+1,5)

after1 :: AWrapper
after1 (a,b) = a*b

before2 :: BWrapper
before2 a = (a+2,6)


after2 :: AWrapper
after2 (a,b) = a+b

before3 :: (Int,Int) -> ((Int,Int),(Int,Int))
before3  (x,y) = ((x+1,y+1),(x,y))

after3  :: ((Int,Int),(Int,Int)) -> (Int,Int)
after3   ((x,y),(i,j)) = (x+i,y+j)   

before4 (x,y,z) = ((x-1,y-1,z-1),(x,y,z)) 
after4  ((x,y),(i,j,k)) = (x+y,i+j+k)

after5 ((x,y,z), (i,j,k)) = (x*i,x*k)

f' (a,b)   = (a*2,b*2,a+b)

g' (a,b,c) = (a+2,b+2)

h' (a,b)   = (a*8,b*8)

-- Ex : 08

before6 (x,y) = ((x+3,y+3),(x,y))
after6  ((x,y),(i,j)) = (x+i,y+j)

before7 (x,y) = ((x+1,y+1),(x,y))
after7  (x,(y,z)) = x+y+z

f1 (x,y) = (x+5,y+5)
g1 (x,y) = x+y
g2 (x,y) = x*y
h1 (x,y) = x+y*2

-- Ex : 09

f9 (x,y) = ((x+1,y+1),(x+3,y+3))
before9 ((x,y),(i,j)) = (((x*2,x*3),(y*2,y*3)),((x,y),(i,j)))
after9  (x,((y,z),(i,j))) = x+y+z+i+j


-- Ex : 10

before10 (x,y) = ((x*2,y*3),x+y)
after10  (x,y) = x+y

-- Ex : 11

f11 (x,y) = (x*2,y*2)