module Lambda where

 
-- Lambda Expressions

type Id = String

data Exp  = Apply  Exp  Exp
          | Lambda Id   Exp
          | Var Id
          | APPLY                 -- This constructor is added only to implement env_CBV function
          deriving (Show, Eq)


-- Substitution Function

substitute :: Exp -> Id -> Exp -> Exp
substitute (Var id1) id2 e
              | id1 == id2 = e
              | otherwise  = (Var id1)
substitute (Lambda id1 e1)  id2 e2
                    | id1 == id2 = (Lambda id1 e1)
                    | otherwise  = (Lambda id1 (substitute e1 id2 e2))
substitute (Apply e1 e2)     id e3 = (Apply (substitute e1 id e3) (substitute e2 id e3))  
                 
-- Redution Call By Value

reduceCBV :: Exp  -> Exp
reduceCBV (Var id)                   = (Var id)
reduceCBV (Lambda id e)              = (Lambda id e)
reduceCBV (Apply (Lambda id e1) e2)  = reduceCBV (substitute e1 id (reduceCBV e2))
reduceCBV (Apply e1 e2)              = let e = reduceCBV e1
                                         in reduceCBV (Apply e e2) 

-- Reduction Call By Name

reduceCBN :: Exp -> Exp
reduceCBN (Var id)                    = (Var id)
reduceCBN (Lambda id e)               = (Lambda id e)
reduceCBN (Apply (Lambda id e1) e2)   = reduceCBN (substitute e1 id e2)
reduceCBN (Apply e1 e2)               = let e = reduceCBN e1
                                          in  Apply e e2 

-- Environement datatype declaration

type Env        = [(Id,Closure)]
data Cls        = C Env deriving Show
type Closure    = (Exp, Cls)
type Stack      = [Closure]

loockup :: Id ->  Env -> Closure
loockup id ((id',c):env)
              | id == id' = c
              | otherwise = loockup id env

-- Call By Name Reduction with the environement specification

env_CBN :: Exp ->  Env  -> Stack -> Closure
env_CBN (Var id)                  env       st = let (exp,C env') = loockup id env
                                                   in env_CBN exp env' st
env_CBN (Lambda id e)             env (clo:st) = env_CBN e ((id,clo):env) st
env_CBN (Lambda id e)             env       [] = (Lambda id e, C env)
env_CBN (Apply e1 e2)             env       st = env_CBN e1 env ((e2,C env):st)                

-- Call By Value Reduction with the environement specification

env_CBV :: [Exp] ->  Env -> Stack -> Closure
env_CBV       []               env        (clos:st)  = clos
env_CBV ((Var id):es)          env          st       = let clos = loockup id env
                                                         in env_CBV es env (clos:st)
env_CBV ((Lambda id e):es)     env          st       = env_CBV es env ((Lambda id e, C env):st)
env_CBV ((Apply e1 e2):es)     env          st       = env_CBV (e2:e1:APPLY:es) env st
env_CBV (APPLY:es)             env    ((Lambda id e, C env'):clos:st)  = env_CBV (e:es) ((id,clos):env') st

-- Examples

ft :: Exp
ft = (Lambda "x" (Lambda "y" (Var "x")))

sd :: Exp
sd = (Lambda "x" (Lambda "y" (Var "y")))

idt :: Exp
idt = (Lambda "x" (Var "x"))

exp1 :: Exp
exp1 =  Apply (Lambda "x" (Apply (Lambda "y" (Apply (Lambda "z" (Var "y")) (Var "m"))) (Var "l"))) (Var "k")

exp2:: Exp
exp2 = Lambda "x" (Lambda "y" (Lambda "z" (Var "y")))

exp3 :: Exp
exp3 = Apply (Lambda "x" (Var "x")) (Lambda "y" (Var "y"))

exp4 :: Exp
exp4 = Apply (Lambda "x" (Apply (Lambda "y" (Var "y")) (Lambda "t" (Var "t")))) (Lambda "z" (Var "z"))