package views_Transformation;

import java.util.ArrayList;
import java.util.List;

public class ExceptExp extends ViewExp {
	
	private List<String> interfacesNames;
	
	public ExceptExp(PATH path, List<String> lst) {
		super(path);
		this.interfacesNames = lst;
	}
	
	public List<String> getIgnoredInterfaces(){
		return this.interfacesNames;
	}

	public joinPoint evaluate() {
		componentNode cmp = this.getPath().evaluate();
		List<componentInterface> itfs = new ArrayList<componentInterface>();
		itfs.addAll(cmp.getInterfaces());
		for(int i=0; i<interfacesNames.size(); i++) {
			int j =0;
			while (j<itfs.size() && !itfs.get(j).getName().equals(interfacesNames.get(i))) j++;
			itfs.remove(j);
		}
		return new joinPoint(cmp, itfs);
	}

}
