package views_Transformation;
import java.io.IOException;
import java.util.*;

import org.w3c.dom.*;
import org.xml.sax.SAXException;
import javax.xml.parsers.*;
import javax.xml.xpath.*;

public class FADLToDAG {
	
	XPathFactory factory;
    XPath xpath;
    DocumentBuilderFactory domFactory; 
    DocumentBuilder builder; 
    Document doc;
    
    
  public FADLToDAG(String fileName) throws ParserConfigurationException, SAXException, IOException{
	  factory = XPathFactory.newInstance();
	  xpath = factory.newXPath();
	  domFactory = DocumentBuilderFactory.newInstance();
	  domFactory.setNamespaceAware(true);
	  builder = domFactory.newDocumentBuilder();
	  doc = builder.parse(fileName);
  }
  
  public NodeList getComponentNamesList(String path){
	  try {
		XPathExpression expr = xpath.compile(path+"/@name");
		Object result = expr.evaluate(doc, XPathConstants.NODESET);
	    NodeList nodes = (NodeList) result;
	    return nodes;
	} catch (XPathExpressionException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	  return null;
  }
  
  public String getComponentName(String path){
	  try {
		XPathExpression expr = xpath.compile(path+"/@name");
		Object result = expr.evaluate(doc, XPathConstants.NODESET);
	    NodeList nodes = (NodeList) result;
	    return nodes.item(0).getNodeValue();
	} catch (XPathExpressionException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	  return null;
  }
  
  public List<componentAttribute> getComponentAttributes(String path, String componentName){
	  try {
		XPathExpression expr = xpath.compile(path+"[@name='"+componentName+"']/attributes/@signature");
		Object result = expr.evaluate(doc, XPathConstants.NODESET);
	    NodeList nodes = (NodeList) result;
	    if (nodes.getLength()==0) return null;
	    else {
	    	List<componentAttribute> attributes = new ArrayList<componentAttribute>();
	    	for (int i=0; i<nodes.getLength();i++){
	    		attributes.add(new componentAttribute(nodes.item(i).getNodeValue()));
	    	}
	    }
	} catch (XPathExpressionException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	  return null;
  }
  
  public List<componentNode> getComponentChilds(String path, String componentName, compositeComponentNode parent){
	  try {
		XPathExpression expr = xpath.compile(path+"[@name='"+componentName+"']/component/@name");
		Object result = expr.evaluate(doc, XPathConstants.NODESET);
	    NodeList nodes = (NodeList) result;
	    if (nodes.getLength()==0) return null;
	    else {
	    	List<componentNode> childs = new ArrayList<componentNode>();
	    	String path1 = path+"[@name='"+componentName+"']/component";
	    	for (int i=0; i<nodes.getLength();i++){
	    		if (!isPrimitive(path1, nodes.item(i).getNodeValue())) {
	    		     compositeComponentNode cmp = new compositeComponentNode(nodes.item(i).getNodeValue(),
	    			    		                                         getComponentAttributes(path1,nodes.item(i).getNodeValue()),
	    			    		                                         getComponentInterfaces(path1,nodes.item(i).getNodeValue()),
	    			    		                                         parent);
	    			 cmp.setChilds(getComponentChilds(path1,nodes.item(i).getNodeValue(),cmp));
	                 cmp.setBinding(getComponentBinding(path1,cmp));
	    			 childs.add(cmp);
	    		} else childs.add(new primitiveComponentNode(nodes.item(i).getNodeValue(), 
                                                           getComponentAttributes(path1,nodes.item(i).getNodeValue()),
                                                           getComponentInterfaces(path1,nodes.item(i).getNodeValue()),
	    				                                   getComponentContent(path1, nodes.item(i).getNodeValue()),
	    				                                   parent));
	    	}
	        return childs;
	    }
	} catch (XPathExpressionException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	  return null;
  }
  
  public NodeList getComponentInterfaceNamesList(String path, String componentName){
	  try {
		XPathExpression expr = xpath.compile(path+"[@name='"+componentName+"']/interface/@name");
		Object result = expr.evaluate(doc, XPathConstants.NODESET);
	    NodeList nodes = (NodeList) result;
	    return nodes;
	} catch (XPathExpressionException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	  return null;
  }
  
  public String getComponentInterfaceSignature(String path, String componentName, String interfaceName){
	  try {
		XPathExpression expr = xpath.compile(path+"[@name='"+componentName+"']/interface[@name='"+interfaceName+"']/@signature");
		Object result = expr.evaluate(doc, XPathConstants.NODESET);
	    NodeList nodes = (NodeList) result;
	    return nodes.item(0).getNodeValue();
	} catch (XPathExpressionException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	  return null;
  }
  
  public String getComponentInterfaceRole(String path, String componentName, String interfaceName){
	  try {
		XPathExpression expr = xpath.compile(path+"[@name='"+componentName+"']/interface[@name='"+interfaceName+"']/@role");
		Object result = expr.evaluate(doc, XPathConstants.NODESET);
	    NodeList nodes = (NodeList) result;
	    return nodes.item(0).getNodeValue();
	} catch (XPathExpressionException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	  return null;
  }
  
  public List<componentInterface> getComponentInterfaces(String path, String componentName){
	  NodeList names = getComponentInterfaceNamesList(path, componentName);
	  List<componentInterface> interfaces = new ArrayList<componentInterface>();
	  for(int i=0; i<names.getLength(); i++){
		 String name = names.item(i).getNodeValue();
		 interfaces.add(new componentInterface(name,getComponentInterfaceSignature(path, componentName,name),getComponentInterfaceRole(path, componentName,name))); 
	  }
	  
	  return interfaces;
	  
  }
  
  public NodeList getComponentBindingClientsList(String path, String componentName){
	  try {
		XPathExpression expr = xpath.compile(path+"[@name='"+componentName+"']/binding/@client");
		Object result = expr.evaluate(doc, XPathConstants.NODESET);
	    NodeList nodes = (NodeList) result;
	    return nodes;
	} catch (XPathExpressionException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	  return null;
  }
  
  public NodeList getComponentBindingServersList(String path, String componentName){
	  try {
		XPathExpression expr = xpath.compile(path+"[@name='"+componentName+"']/binding/@server");
		Object result = expr.evaluate(doc, XPathConstants.NODESET);
	    NodeList nodes = (NodeList) result;
	    return nodes;
	} catch (XPathExpressionException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	  return null;
  }
  
  public List<componentBinding> getComponentBinding(String path, componentNode component){
	  NodeList client = getComponentBindingClientsList(path, component.getName());
	  NodeList server = getComponentBindingServersList(path, component.getName());
	  StringTokenizer st1, st2;
	  componentInterface c, sr;
	  List<componentBinding> bindingList = new ArrayList<componentBinding>();
      for (int i = 0; i < client.getLength(); i++) {
    	  st1 = new StringTokenizer(client.item(i).getNodeValue(),".");
    	  st2 = new StringTokenizer(server.item(i).getNodeValue(),".");
    	  String s1 = st1.nextToken();
    	  String s2 = st2.nextToken();
    	  if (s1.equals("this")) c = getInterface(component, st1.nextToken());
    	  else c = getInterface(getChild(component, s1), st1.nextToken());
    	  if (s2.equals("this")) sr = getInterface(component, st2.nextToken());
    	  else sr = getInterface(getChild(component, s2), st2.nextToken());
		  bindingList.add(new componentBinding(s1, c, s2, sr));
      }
	      return bindingList;
	  
  }
  
  private componentNode getChild(componentNode component, String s) {
	// TODO Auto-generated method stub
	  List<componentNode> childs = ((compositeComponentNode)component).getChilds();
	  int i =0;
	  while(i<childs.size() && !childs.get(i).getName().equals(s)) i++; 
	  return childs.get(i);	
 }

private componentInterface getInterface(componentNode component,
		String s) {
	// TODO Auto-generated method stub
	  List<componentInterface> interfaces = component.getInterfaces();
	  int i =0;
	  while(i<interfaces.size() && !interfaces.get(i).getName().equals(s)) i++; 
	  return interfaces.get(i);
 }

 public String getComponentContent(String path, String componentName){
	  try {
		XPathExpression expr = xpath.compile(path+"[@name='"+componentName+"']/content/@class");
		Object result = expr.evaluate(doc, XPathConstants.NODESET);
	    NodeList nodes = (NodeList) result;
	    return nodes.item(0).getNodeValue();
	} catch (XPathExpressionException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	  return null;
  }
 
 
  public boolean isPrimitive(String path, String componentName){
	  try {
			XPathExpression expr = xpath.compile(path+"[@name='"+componentName+"']");
			Object result = expr.evaluate(doc, XPathConstants.NODESET);
		    NodeList nodes = (NodeList) result;
		    NodeList nds = nodes.item(0).getChildNodes();
		    int i =0; boolean found= false;
		    while (i<nds.getLength() && !found) {
		    	if(nds.item(i).getNodeName().equals("content")) found = true;
		    	else i++;
		    }
		    return found;
		} catch (XPathExpressionException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		  return false;
  }
  
  public componentNode generateComponentArchitecture() throws XPathExpressionException{
	  String name = getComponentName("//definition");
	  List<componentInterface> interfaces = getComponentInterfaces("//definition",name);
	  List<componentAttribute> attributes = getComponentAttributes("//definition",name);
	
	  if (isPrimitive("//definition", name)) {
		  String content = getComponentContent("//definition",name);
		  return new primitiveComponentNode(name, attributes, interfaces, content, null);
	  }
	  else {
	  compositeComponentNode root = new compositeComponentNode(name, attributes, interfaces, null);
	  List<componentNode> childs = getComponentChilds("//definition", name, root);
	  root.setChilds(childs);
	  List<componentBinding> binding = getComponentBinding("//definition", root);
	  root.setBinding(binding);
	  return root;
	  }
	  
  }
  
  
}