package views_Transformation;

import java.util.List;

public class componentArchitecture {
	
	private componentNode root;
	
	public componentArchitecture(componentNode root){
		this.root = root;
	}
	
	public componentNode getRoot(){
		return this.root;
	}
	
	public componentNode getCommonParent(componentNode c1, componentNode c2){
		List<componentNode> p1 = c1.getComponentParents();
		List<componentNode> p2 = c2.getComponentParents();
		if(p1.size()==0 || p2.size()==0) return root;
		else {
			int i=0;
			boolean found = false;
			while (i<Math.min(p1.size(), p2.size()) && !found) {
				if (p1.contains(p2.get(i))) {
					found = true;
					return p2.get(i);
				} else if (p2.contains(p1.get(i))){
					found = true;
					return p1.get(i);
				} else i++;
			}
			return root;
		}
		
	}
	
}
