package views_Transformation;

import java.util.ArrayList;
import java.util.List;

public class BExp extends ViewExp {
	
	private ViewExp exp1;
	private ViewExp exp2;
	private String op;
	
	public BExp(PATH path, String op, ViewExp e1, ViewExp e2){
		super(path);
		this.op = op;
		this.exp1 = e1;
		this.exp2 = e2;
	}
	
	public ViewExp getLeft(){
		return this.exp1;
	}
	
	public ViewExp getRight(){
		return this.exp2;
	}
	
	public String getOp(){
		return this.op;
	}

	public joinPoint evaluate() {
		List<componentInterface> lst = new ArrayList<componentInterface>();
		if (this.getOp().equals("union")) {
			lst.addAll(exp1.evaluate().getInterfaces());
			lst.addAll(exp2.evaluate().getInterfaces());
			return new joinPoint(path.evaluate(), lst);
		}
		else if(this.getOp().equals("intersection")) {
			List<componentInterface> lst1 = exp1.evaluate().getInterfaces();
			List<componentInterface> lst2 = exp2.evaluate().getInterfaces();
			for(int i=0; i<lst1.size(); i++)
				if(lst2.contains(lst1.get(i))) lst2.remove(lst1.get(i));
            lst1.addAll(lst2);
            return new joinPoint(this.getPath().evaluate(),lst1);
		} else if(this.getOp().equals("difference")) {
			List<componentInterface> lst1 = exp1.evaluate().getInterfaces();
			List<componentInterface> lst2 = exp2.evaluate().getInterfaces();
			for(int i=0; i<lst1.size(); i++)
				if(lst2.contains(lst1.get(i))) lst1.remove(i);
            return new joinPoint(this.getPath().evaluate(),lst1);
		}
		return null;
	}

}
