package views_Transformation;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class DAGToFADL {
	

	
	public void generateADLAttributesTags(BufferedWriter out, String s, List<componentAttribute> attributes) throws IOException{
		for (int i=0; i<attributes.size();i++){
			out.write(s+"<attributese signature=\""+attributes.get(i).getSignature()+"\"/>");
			out.newLine();
		}
	}
	
	public void generateADLInterfacesTags(BufferedWriter out, String s, List<componentInterface> interfaces) throws IOException{
		for (int i=0; i<interfaces.size();i++){
			out.write(s+"<interface name=\""+interfaces.get(i).getName()+"\" signature=\""+interfaces.get(i).getSignature()+"\" role=\""+interfaces.get(i).getRole()+"\"/>");
			out.newLine();
		}
	}
	
	public void generateADLContentTags(BufferedWriter out, String s, String content) throws IOException{	
			out.write(s+"<content class=\""+content+"\"/>");
			out.newLine();
		
	}
	
	public void generateADLBindingTags(BufferedWriter out, String s, List<componentBinding> binding) throws IOException{
		for (int i=0; i<binding.size();i++){
			out.write(s+"<binding client=\""+binding.get(i).getCClient()+"."+binding.get(i).getClient().getName()+"\" server=\""+binding.get(i).getCServer()+"."+binding.get(i).getServer().getName()+"\"/>");
			out.newLine();
		}
	}
	
	private void generateADLChildsTags(BufferedWriter out, String s, componentNode componentNode) throws IOException {
		
		generateADLInterfacesTags(out, s+"  ", componentNode.getInterfaces());    
	    
		if (componentNode.getClass().getName().equals("views_Transformation.compositeComponentNode")){
	         List<componentNode> components = ((compositeComponentNode)componentNode).getChilds();
	
	         for (int i=0; i<components.size(); i++){
	        	 out.write(s+"  <component name=\""+components.get(i).getName()+"\">");
	        	 out.newLine();
	    	     generateADLChildsTags(out, s+"  ",components.get(i));
	         } 
	         
	         generateADLBindingTags(out, s+"  ",((compositeComponentNode)componentNode).getBinding()); 
	  
	    } else {
		     generateADLContentTags(out, s+"  ", ((primitiveComponentNode)componentNode).getContent());
	      }
		out.write(s+"</component>");
		out.newLine();
	}
	
	public void generateFractalADL(String fileName, componentNode ca){
		  try{
			   
			    FileWriter ADLFile = new FileWriter(fileName);
			    BufferedWriter out = new BufferedWriter(ADLFile);
			    out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			    out.newLine();
			    out.write("<!DOCTYPE definition PUBLIC \"-//objectweb.org//DTD Fractal ADL 2.0//EN\" \"classpath://org/objectweb/fractal/adl/xml/standard.dtd\">");
			    out.newLine();
			    out.write("<definition name=\""+ca.getName()+"\">");
			    out.newLine();
			    generateADLInterfacesTags(out, "  ", ca.getInterfaces());
			    if (ca.getClass().getName().equals("views_Transformation.primitiveComponentNode")){
			    	generateADLContentTags(out, "  ", ((primitiveComponentNode)ca).getContent());
			    } else {
			    List<componentNode> components = ((compositeComponentNode)ca).getChilds();
			    
			       for (int i=0; i<components.size();i++){
			    	  out.write("  <component name=\""+components.get(i).getName()+"\">");
			    	  out.newLine();
			    	  generateADLChildsTags(out,"  ",components.get(i));
			       } 
			     
			     generateADLBindingTags(out, "  ", ((compositeComponentNode)ca).getBinding());
			    }
			     out.write("</definition>");
			     out.close();
			    } catch (Exception e){
			      System.err.println("Error: " + e.getMessage());
			    }
		  
	}
		
	
	

}
