package views_Transformation;

import java.util.List;

public class LeftNestingStrategy extends WrappingStrategy {

	@Override
	void wrapTwo(View v1, Wrapper w1, View v2, Wrapper w2) {
		compositeComponentNode parent1 = (compositeComponentNode)v1.getInputs().getComponent().getParent();
		compositeComponentNode parent2 = (compositeComponentNode)v1.getOutputs().getComponent().getParent();
		w1.getIn().setParent(parent1);
		w1.getOut().setParent(parent2);
		parent1.addChild(w1.getIn());
		parent2.addChild(w1.getOut());
		if (parent1==parent2) {
			updateBindingIN(parent1.getBinding(), v1, w1);
	        wrap(v2,w2);
			updateBindingOUT(parent1.getBinding(), v1, w1);
			if(w1.getIIn().getRole().equals("client")) {
				parent1.getBinding().add(new componentBinding(w1.getIn().getName(), w1.getIIn(), w1.getOut().getName(), w1.getIOut()));
			} else {
				parent1.addBinding(new componentBinding(w1.getOut().getName(), w1.getIOut(), w1.getIn().getName(), w1.getIIn())); 
			}
		} else {
			// handle adding new interfaces into composites
			componentNode commonParent = v1.getComponentArchitecture().getCommonParent(v1.getInputs().getComponent(), v1.getOutputs().getComponent());
			List<componentNode> p1 = v1.getInputs().getComponent().getComponentParents();
			List<componentNode> p2 = v1.getOutputs().getComponent().getComponentParents();
			integrateLeftPart(p1,commonParent, v1, w1);
			integrateRightPart(p2,commonParent, v1, w1);
			int index1 = p1.indexOf(commonParent);
			int index2 = p2.indexOf(commonParent);
			String name1, name2;
			componentInterface witf1;
			if (index1==0) {
				name1=w1.getIn().getName(); 
				witf1 = w1.getIIn();
			} else {
				name1=p1.get(index1-1).getName();
				witf1=componentNode.getComponentInterfaceByName(p1.get(index1-1).getInterfaces(), "_"+w1.getName()); 
			} 
			componentInterface witf2;
			if (index2==0) {
				name2=w1.getOut().getName(); 
				witf2 = w1.getIOut();
			} else {
				name2=p2.get(index2-1).getName();
				witf2=componentNode.getComponentInterfaceByName(p2.get(index2-1).getInterfaces(), "_"+w1.getName());  
			}
			if (w1.getIIn().getRole().equals("server")) {
			      ((compositeComponentNode)commonParent).addBinding(new componentBinding(name2, 
			    		                                                                  witf2,
			    		                                                                  name1,
			    		                                                                  witf1));
			} else {
				((compositeComponentNode)commonParent).addBinding(new componentBinding(name1, 
	                    witf1,
	                    name2,
	                    witf2));
			}
			updateBindingIN(parent1.getBinding(), v1, w1);
			wrap(v2,w2);
			updateBindingOUT(parent2.getBinding(), v1, w1);
		}
        
	}

}
