package views_Transformation;

import java.util.ArrayList;
import java.util.List;

public abstract class componentNode {
	
	private  String name;
	private  List<componentAttribute>  attributes;
	private  List<componentInterface>  interfaces;
	public  componentNode parent;

	public componentNode(String name, List<componentAttribute> attributes, List<componentInterface> interfaces){
		this.name = name;
		this.attributes = attributes;
		this.interfaces = interfaces;		
	}
	
	public String getName(){
		return this.name;
	}
	
	public componentNode getParent(){
		return this.parent;
	}
	
	public void setParent(componentNode newParent){
		this.parent=newParent;
	}
	
	public List<componentNode> getComponentParents(){
		List<componentNode> parents = new ArrayList<componentNode>();
		componentNode parent = this.getParent();
		while(parent!=null){
			parents.add(parent);
			parent = parent.getParent();
		}
		return parents;
    }
	
	public List<componentAttribute> getAttributes(){
		return this.attributes;
	}
	
	public List<componentInterface> getInterfaces(){
		return this.interfaces;
	}
	
	public List<componentInterface> getProvidedInterfaces(){
		List<componentInterface> itfs = new ArrayList<componentInterface>();
		
		for (int i=0; i<interfaces.size(); i++){
			if (interfaces.get(i).getRole().equals("server")) itfs.add(interfaces.get(i));
			
		}
		
		return itfs;
	}
	
	public List<componentInterface> getRequiredInterfaces(){
		List<componentInterface> itfs = new ArrayList<componentInterface>();
		
		for (int i=0; i<interfaces.size(); i++){
			if (interfaces.get(i).getRole().equals("client")) itfs.add(interfaces.get(i));
			
		}
		
		return itfs;
	}
	
	public static componentInterface getComponentInterfaceBySignature(List<componentInterface> itf, String signature){
		int i=0;
		while(i<itf.size() && !itf.get(i).getSignature().equals(signature)) i++;
		if (i<=itf.size()) return itf.get(i);
		else return null;
    }
	
	public static componentInterface getComponentInterfaceByName(List<componentInterface> itf, String name){
		int i=0;
		while(i<itf.size() && !itf.get(i).getName().equals(name)) i++;
		if (i<=itf.size()) return itf.get(i);
		else return null;
    }
}
