/*
 * Decompiled with CFR 0.152.
 */
package costo_plugin_kml2b.visitors;

import costo.graph.Assembly;
import costo.graph.Component;
import costo.graph.ComponentInterface;
import costo.graph.ComponentVariable;
import costo.graph.Composition;
import costo.graph.CostoLibrary;
import costo.graph.LTS;
import costo.graph.Link;
import costo.graph.Service;
import costo.graph.ServiceInterface;
import costo.graph.Spec;
import costo.graph.Variable;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlAssignmentExpression;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlPredicate;
import costo.graph.types.CostoArray;
import costo.graph.types.CostoBoolean;
import costo.graph.types.CostoEnum;
import costo.graph.types.CostoInteger;
import costo.graph.types.CostoRange;
import costo.graph.types.CostoSet;
import costo.graph.types.CostoType;
import costo.graph.types.CostoTypeSpace;
import costo.graph.visitors.KmlElementAbstractVisitor;
import costo.graph.visitors.KmlElementVisitor;
import costo_plugin_kml2b.Machine;
import costo_plugin_kml2b.visitors.Kml2BExpressionVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Kml2BVisitor
extends KmlElementAbstractVisitor {
    private Machine mch = new Machine("");
    private Machine mch_cxt = new Machine("");
    public CostoLibrary librairies;
    public String tab = "     ";
    public HashMap<String, Variable> varcomp;
    public CostoLibrary lib;
    ArrayList<String> sets = new ArrayList();
    ArrayList<String> definitions = new ArrayList();
    ArrayList<String> variables = new ArrayList();
    ArrayList<String> constants = new ArrayList();
    ArrayList<String> properties = new ArrayList();
    ArrayList<String> invariant = new ArrayList();
    ArrayList<String> initialisation = new ArrayList();
    ArrayList<String> operations = new ArrayList();

    public Machine getMch() {
        return this.mch;
    }

    public void setMch(Machine mch) {
        this.mch = mch;
    }

    public Machine getMch_cxt() {
        return this.mch_cxt;
    }

    public void setMch_cxt(Machine mchCxt) {
        this.mch_cxt = mchCxt;
    }

    public Kml2BVisitor(Machine m, CostoLibrary cl) {
        this.mch = m;
        this.librairies = cl;
    }

    public Kml2BVisitor() {
    }

    public boolean visit(Component comp) {
        System.out.println("visit comp: " + comp.getName());
        this.mch = new Machine(comp.getName());
        if (comp.getName().contains("_ref_")) {
            String ref = comp.getName().substring(comp.getName().lastIndexOf("_ref_") + 5);
            this.mch.setRefine(true);
            if (ref != null) {
                this.mch.setRefines("req_" + ref);
            }
        } else {
            this.sets.add("String");
        }
        this.visit(comp.getLibraries());
        this.visit(comp.getTypeSpace());
        this.visitConst(comp.getConstants());
        this.mch.setSets(Spec.listToString(this.sets, (String)"", (String)(" ;\n" + this.tab), (String)""));
        this.mch.setDefinitions(Spec.listToString(this.definitions, (String)"", (String)(" ,\n" + this.tab), (String)""));
        this.mch.setConstants(Spec.listToString(this.constants, (String)"", (String)(" ,\n" + this.tab), (String)""));
        this.mch.setProperties(Spec.listToString(this.properties, (String)"", (String)(" &\n" + this.tab), (String)""));
        this.visitVar(comp.getVariables());
        this.mch.setVariables(Spec.listToString(this.variables, (String)"", (String)(" ,\n" + this.tab), (String)""));
        this.visitinit(comp.getInitialization());
        this.mch.setInitialization(Spec.listToString(this.initialisation, (String)"", (String)(" ||\n" + this.tab), (String)""));
        this.visitinv(comp.getInvariant());
        this.mch.setInvariant(Spec.listToString(this.invariant, (String)"", (String)(" &\n" + this.tab), (String)""));
        this.visit(comp.getServicesMap(), comp.getVariables());
        this.mch.setOperations(Spec.listToString(this.operations, (String)"", (String)" ;\n", (String)""));
        return false;
    }

    public boolean visit(ArrayList<CostoLibrary> cls) {
        if (cls != null) {
            for (CostoLibrary cl : cls) {
                this.visit(cl);
            }
        }
        return super.visit(cls);
    }

    public boolean visit(CostoLibrary cl) {
        if (cl != null) {
            CostoTypeSpace cts = new CostoTypeSpace();
            cts.setTypeMap(cl.getTypes());
            this.visit(cts);
            this.visitConst(cl.getConstants());
        }
        return super.visit(cl);
    }

    public String visitType(CostoType ct) {
        if (ct instanceof CostoInteger) {
            return "INT";
        }
        if (ct instanceof CostoBoolean) {
            return "BOOL";
        }
        if (ct instanceof CostoSet) {
            return this.visitType(((CostoSet)ct).getReftype());
        }
        return ct.getName();
    }

    public boolean visit(CostoTypeSpace costotype) {
        Kml2BVisitor v = new Kml2BVisitor();
        for (CostoType ct : costotype.getTypeMap().values()) {
            String set;
            if (ct instanceof CostoEnum) {
                CostoEnum ce = (CostoEnum)ct;
                set = String.valueOf(this.visitType((CostoType)ce)) + " = " + Spec.listToString((Collection)ce.getEnums(), (String)"{", (String)",", (String)"}");
                this.sets.add(set);
            }
            if (ct instanceof CostoRange) {
                CostoRange cr = (CostoRange)ct;
                set = String.valueOf(this.visitType((CostoType)cr)) + " == " + cr.getBorneInfName() + ".." + cr.getBorneSupName();
                this.definitions.add(set);
            }
            if (ct instanceof CostoSet) {
                CostoSet cs = (CostoSet)ct;
                this.initialisation.add(String.valueOf(cs.getName()) + " := POW (" + this.visitType(cs.getReftype()) + ")");
                this.variables.add(cs.getName());
                this.invariant.add(String.valueOf(cs.getName()) + " = POW (" + this.visitType(cs.getReftype()) + " )");
            }
            if (!(ct instanceof CostoArray)) continue;
            String s = "";
            CostoArray ca = (CostoArray)ct;
            s = this.visitType((CostoType)ca.getRange()).replace("[", "(");
            s = s.replace("]", ")");
            this.variables.add(this.visitType((CostoType)ca));
            this.invariant.add(String.valueOf(this.visitType((CostoType)ca)) + " <: " + s + " --> " + v.visitType(ca.getReftype()));
            this.initialisation.add(String.valueOf(this.visitType((CostoType)ca)) + " := " + " {} ");
        }
        return super.visit(costotype);
    }

    public boolean visitVar(HashMap<String, Variable> vc) {
        if (vc != null && !vc.isEmpty()) {
            Kml2BExpressionVisitor v = new Kml2BExpressionVisitor();
            for (Variable var : vc.values()) {
                v.visit(var);
                this.variables.add(v.bExp);
                if (var.getCtype() instanceof CostoSet) {
                    CostoSet cs = new CostoSet();
                    cs = (CostoSet)var.getCtype();
                    this.invariant.add(String.valueOf(v.bExp) + " : FIN(" + this.visitType(cs.getReftype()) + ")");
                    continue;
                }
                this.invariant.add(String.valueOf(v.bExp) + " : " + v.type);
            }
        }
        return super.visit(vc);
    }

    public boolean visitConst(HashMap<String, Variable> vc) {
        Kml2BExpressionVisitor v = new Kml2BExpressionVisitor();
        if (vc != null && !vc.isEmpty()) {
            for (Variable var : vc.values()) {
                if (var.getName().equals("emptySet") || var.getName().equals("null")) continue;
                v.visit(var);
                this.constants.add(v.bExp);
                this.properties.add(String.valueOf(v.bExp) + " : " + v.type);
                if (var.getValue() == "" || var.getName().equals("emptyString")) continue;
                this.properties.add(String.valueOf(v.bExp) + " = " + v.value);
            }
        }
        return super.visit(vc);
    }

    public boolean visitinit(HashMap<String, KmlAssignmentExpression> init) {
        if (init != null && !init.isEmpty()) {
            Kml2BExpressionVisitor v = new Kml2BExpressionVisitor();
            for (KmlAssignmentExpression k : init.values()) {
                k.accept((ExpressionVisitor)v);
                this.initialisation.add(v.bExp);
            }
        }
        return super.visit(init);
    }

    public boolean visitinv(HashMap<String, KmlPredicate> inv) {
        Kml2BExpressionVisitor v = new Kml2BExpressionVisitor();
        if (inv != null && !inv.isEmpty()) {
            for (KmlPredicate k : inv.values()) {
                k.accept((ExpressionVisitor)v);
                this.invariant.add(v.bExp);
            }
        }
        return super.visit(inv);
    }

    public boolean visit(ComponentInterface cint) {
        return super.visit(cint);
    }

    public boolean visit(HashMap<String, Service> srv, HashMap<String, Variable> vars) {
        this.varcomp = vars;
        for (Service serv : srv.values()) {
            serv.accept((KmlElementVisitor)this);
        }
        return false;
    }

    public boolean visit(Service srv) {
        if (!srv.isRequired()) {
            Map.Entry ent;
            Map.Entry element;
            Iterator iterator;
            String op = "";
            ArrayList<String> any = new ArrayList<String>();
            ArrayList<String> where = new ArrayList<String>();
            ArrayList<String> then = new ArrayList<String>();
            ArrayList<String> param = new ArrayList<String>();
            ArrayList<String> pre = new ArrayList<String>();
            Kml2BExpressionVisitor v = new Kml2BExpressionVisitor();
            Kml2BExpressionVisitor v1 = new Kml2BExpressionVisitor();
            Variable var = new Variable();
            KmlPredicate pred = null;
            op = String.valueOf(op) + srv.getName();
            if (srv.getParametersMap() != null && !srv.getParametersMap().isEmpty()) {
                iterator = srv.getParametersMap().entrySet().iterator();
                while (iterator.hasNext()) {
                    ent = element = iterator.next();
                    var = (Variable)ent.getValue();
                    v.visit(var);
                    param.add(v.bExp);
                    pre.add(v.btyping(var));
                }
                op = String.valueOf(op) + Spec.listToString(param, (String)"(", (String)",", (String)")");
            }
            op = String.valueOf(op) + " = \n";
            if (srv.getPreMap() != null && !srv.getPreMap().isEmpty()) {
                iterator = srv.getPreMap().entrySet().iterator();
                while (iterator.hasNext()) {
                    ent = element = iterator.next();
                    pred = (KmlPredicate)ent.getValue();
                    v1.visit(pred);
                    pre.add(v1.bExp);
                }
            }
            if (srv.getPreMap() != null && !srv.getPreMap().isEmpty() || srv.getParametersMap() != null && !srv.getParametersMap().isEmpty()) {
                op = String.valueOf(op) + this.tab + "PRE \n";
                op = String.valueOf(op) + Spec.listToString(pre, (String)(String.valueOf(this.tab) + this.tab), (String)(" &\n" + this.tab + this.tab), (String)"\n");
                op = String.valueOf(op) + this.tab + "THEN \n";
            } else {
                op = String.valueOf(op) + this.tab + "BEGIN \n";
            }
            op = String.valueOf(op) + this.tab + this.tab + "ANY\n";
            if (srv.getPostMap() != null && !srv.getPostMap().isEmpty()) {
                String t = "";
                String p = "";
                Iterator iterator2 = srv.getPostMap().entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element2;
                    Map.Entry ent2 = element2 = iterator2.next();
                    pred = (KmlPredicate)ent2.getValue();
                    v1.visit(pred);
                    p = v1.l_prefix;
                    Iterator<String> iterator3 = v1.vars.iterator();
                    while (iterator3.hasNext()) {
                        String element22;
                        t = element22 = iterator3.next();
                        var = this.varcomp.get(t);
                        if (!any.contains("l_" + t) && var != null) {
                            any.add("l_" + t);
                            then.add(String.valueOf(t) + " := l_" + t);
                            Variable vv = new Variable("l_" + var.getName(), var.getCtype());
                            where.add(v.btyping(vv));
                        }
                        if (srv.getParametersMap() == null || !srv.getParametersMap().containsKey(t)) continue;
                        p = p.replaceAll("l_" + t, t);
                    }
                    where.add(v1.bExp);
                }
            }
            if (srv.getReturnCostoType().getName() != null) {
                op = "Result <-- " + op;
                any.add(" \n" + this.tab + this.tab + this.tab + "l_Result");
                where.add(0, "l_Result : " + this.visitType(srv.getReturnCostoType()));
                then.add("Result := l_Result");
            }
            op = String.valueOf(op) + Spec.listToString(any, (String)(String.valueOf(this.tab) + this.tab + this.tab), (String)", ", (String)"\n");
            op = String.valueOf(op) + this.tab + this.tab + "WHERE\n";
            op = String.valueOf(op) + Spec.listToString(where, (String)(String.valueOf(this.tab) + this.tab + this.tab), (String)(" &\n" + this.tab + this.tab + this.tab), (String)"\n");
            op = String.valueOf(op) + this.tab + this.tab + "THEN\n";
            op = String.valueOf(op) + Spec.listToString(then, (String)(String.valueOf(this.tab) + this.tab + this.tab), (String)(" ||\n" + this.tab + this.tab + this.tab), (String)"\n");
            op = String.valueOf(op) + this.tab + this.tab + "END";
            op = String.valueOf(op) + "\n" + this.tab + "END";
            this.operations.add(op);
        }
        return false;
    }

    public boolean visitRequired(Service srv) {
        return super.visit(srv);
    }

    public boolean visitProvided(Service srv, String name) {
        return super.visit(srv);
    }

    public boolean visit(Composition composi) {
        Assembly ass;
        if (composi != null && (ass = composi.getAssembly()).getLinks() != null && ass != null) {
            ComponentVariable cv;
            ArrayList al = ass.getNamedComponents();
            Object rs = null;
            for (Object element : al) {
                cv = (ComponentVariable)element;
                composi.getOwner().getName();
                cv.getTypeName();
            }
            for (Link ln : ass.getLinks().values()) {
                String fs = ln.getFirst().toString();
                String ss = ln.getSecond().toString();
                String fc = fs.substring(0, fs.indexOf("."));
                String sc = ss.substring(0, ss.indexOf("."));
                fs = fs.substring(fs.indexOf(".") + 1, fs.length());
                ss = ss.substring(ss.indexOf(".") + 1, ss.length());
                if (ln.getLinktype() == 1) {
                    for (Object element : al) {
                        cv = (ComponentVariable)element;
                        if (cv.getVarName().equals(fc)) {
                            cv.getTypeName();
                        }
                        if (cv.getVarName().equals(sc)) {
                            cv.getTypeName();
                        }
                        Object cp = null;
                        Object cr = null;
                        if (cp != null) {
                            // empty if block
                        }
                        if (cr == null) continue;
                    }
                    continue;
                }
                if (ln.getLinktype() != 2) continue;
                for (Object element : al) {
                    cv = (ComponentVariable)element;
                    if (cv.getVarName().equals(fc)) {
                        cv.getTypeName();
                    }
                    if (!cv.getVarName().equals(sc)) continue;
                    cv.getTypeName();
                }
            }
        }
        return super.visit(composi);
    }

    public Component generateComponent(Service srv, String name) {
        Component comp = new Component(name);
        comp.setConstants(srv.getConstants());
        comp.setVariables(srv.getVariables());
        comp.setInvariant(srv.getInvMap());
        comp.setInitialization(srv.getInitializations());
        Service sr = srv;
        sr.setProvided(true);
        comp.addService(sr);
        comp.setComposition(null);
        return comp;
    }

    public Component generateCompFromServ(Service srv, String s, HashMap<String, KmlPredicate> inv) {
        if (srv.isProvided()) {
            Component comp = new Component(String.valueOf(srv.getName()) + "_ref_" + s);
            comp.setConstants(srv.getConstants());
            comp.setVariables(srv.getVariables());
            Variable var = new Variable("result", srv.getReturnCostoType());
            comp.getVariables().put("result", var);
            comp.setInvariant(srv.getInvMap());
            KmlExpression expl = new KmlExpression(var.getCtype(), var.getName());
            KmlExpression expr = new KmlExpression(var.getCtype(), var.getCtype().getRawdescription());
            KmlAssignmentExpression ka = new KmlAssignmentExpression(expl, expr);
            ka.setOperator("::");
            System.out.println(ka);
            comp.setInitialization(srv.getInitializations());
            comp.getInitialization().put("result", ka);
            Service sr = new Service(s, true);
            sr.setPreMap(srv.getObs().getPreMap());
            sr.setPostMap(srv.getObs().getPostMap());
            comp.addService(sr);
            return comp;
        }
        Component comp = new Component("req_" + srv.getName());
        comp.setConstants(srv.getConstants());
        comp.setVariables(srv.getVariables());
        Variable var = new Variable("result_" + srv.getName(), srv.getReturnCostoType());
        comp.getVariables().put("result_" + srv.getName(), var);
        comp.setInvariant(srv.getInvMap());
        KmlExpression expl = new KmlExpression(var.getCtype(), var.getName());
        KmlExpression expr = new KmlExpression(this.visitType(var.getCtype()));
        KmlAssignmentExpression ka = new KmlAssignmentExpression(expl, expr);
        ka.setOperator("::");
        comp.setInitialization(srv.getInitializations());
        comp.getInitialization().put("result", ka);
        Service sr = new Service(srv.getName(), true);
        sr.setPreMap(srv.getPreMap());
        sr.setPostMap(srv.getPostMap());
        comp.addService(sr);
        return comp;
    }

    public boolean visit(Component comp, Service srv, String s) {
        this.visit(comp);
        return false;
    }

    public boolean visit(ServiceInterface sint) {
        return super.visit(sint);
    }

    public boolean visit(LTS lts) {
        return super.visit(lts);
    }
}

