/*
 * Decompiled with CFR 0.152.
 */
package costo.kml2java.export;

import costo.graph.CalculatedVariable;
import costo.graph.Component;
import costo.graph.ComponentInterface;
import costo.graph.ComponentVariable;
import costo.graph.CostoLibrary;
import costo.graph.LTS;
import costo.graph.Label;
import costo.graph.Link;
import costo.graph.PromotedVariable;
import costo.graph.Service;
import costo.graph.Spec;
import costo.graph.State;
import costo.graph.Transition;
import costo.graph.Variable;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.KmlAssignmentExpression;
import costo.graph.expressions.KmlCompInitExpression;
import costo.graph.expressions.KmlCondition;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlPredicate;
import costo.graph.expressions.KmlSignature;
import costo.graph.types.AnyType;
import costo.graph.types.CostoArray;
import costo.graph.types.CostoEnum;
import costo.graph.types.CostoInteger;
import costo.graph.types.CostoRange;
import costo.graph.types.CostoSet;
import costo.graph.types.CostoString;
import costo.graph.types.CostoType;
import costo.graph.types.CostoVoid;
import costo.graph.types.RenamedType;
import costo.graph.types.StructuredType;
import costo.graph.visitors.KmlElementAbstractVisitor;
import costo.graph.visitors.KmlElementVisitor;
import costo.kml2java.export.JavaExpressionEvaluatorVisitor;
import costo.kml2java.export.OperatorReplacement;
import costo.kml2java.export.SimpleReplacement;
import costo.kml2java.export.SimpleReplacementWithThis;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateModelException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ComponentJavaContextCreatorVisitor
extends KmlElementAbstractVisitor {
    private ArrayList<String> uglylog = new ArrayList();
    private Map<String, ArrayList<KmlSignature>> missingmappings = new HashMap<String, ArrayList<KmlSignature>>();
    private Map<CostoType, String> costoToJavaTypes = new HashMap<CostoType, String>();
    private String starting_package = "dummy_package_name";
    SimpleHash currentType = null;
    JavaExpressionEvaluatorVisitor currentExpressionEvaluator = new JavaExpressionEvaluatorVisitor(null, null, this.costoToJavaTypes, null);
    ArrayList<SimpleHash> libClassRoots = new ArrayList();
    ArrayList<SimpleHash> structClassRoots = new ArrayList();
    ArrayList<SimpleHash> renamedClassRoots = new ArrayList();
    ArrayList<SimpleHash> componentClassRoots = new ArrayList();
    ArrayList<SimpleHash> servicesClassRoots = new ArrayList();
    ArrayList<SimpleHash> promotedServicesClassRoots = new ArrayList();
    ArrayList<SimpleHash> enumClassRoots = new ArrayList();
    ArrayList<SimpleHash> ltsClassRoots = new ArrayList();
    private HashMap<String, OperatorReplacement> opmap = new HashMap();

    public boolean visit(Component comp) {
        SimpleHash modelRoot = new SimpleHash();
        this.currentExpressionEvaluator = new JavaExpressionEvaluatorVisitor(comp, null, this.costoToJavaTypes, this.opmap);
        SimpleSequence methods = new SimpleSequence();
        SimpleSequence promotedGetters = new SimpleSequence();
        SimpleSequence subcomponents = new SimpleSequence();
        SimpleSequence bindings = new SimpleSequence();
        modelRoot.put("appli", comp.isAppli());
        modelRoot.put("appliTest", comp.isAppliTest());
        ArrayList autoruns = comp.getInterface().getAutorun();
        if (autoruns != null && autoruns.size() > 0) {
            modelRoot.put("autorun", autoruns.get(0));
        } else {
            modelRoot.put("autorun", (Object)"");
        }
        modelRoot.put("composite", false);
        if (comp.isComposite()) {
            modelRoot.put("composite", true);
            for (Link link : comp.getComposition().getAssembly().getLinks().values()) {
                SimpleHash simpleHash = new SimpleHash();
                simpleHash.put("bname", (Object)(String.valueOf(link.getRequired().getCompVarName()) + link.getRequired().getServiceName()));
                simpleHash.put("cclientname", (Object)link.getRequired().getCompVarName());
                simpleHash.put("cservername", (Object)link.getProvided().getCompVarName());
                simpleHash.put("sclientname", (Object)link.getRequired().getServiceName());
                simpleHash.put("sservername", (Object)link.getProvided().getServiceName());
                bindings.add((Object)simpleHash);
            }
            SimpleSequence subcompconfig = new SimpleSequence();
            for (KmlCompInitExpression compinit : comp.getComposition().getAssembly().getCompInits()) {
                subcompconfig.add(compinit.acceptEval((ExpressionEvaluatorVisitor)this.currentExpressionEvaluator));
            }
            modelRoot.put("subcompconfig", (Object)subcompconfig);
            modelRoot.put("bindings", (Object)bindings);
            HashSet<Component> types = new HashSet<Component>();
            modelRoot.put("promotedgetters", (Object)promotedGetters);
            for (ComponentVariable componentVariable : comp.getComposition().getAssemblyNamedComponents()) {
                if (componentVariable.getComponentType() == comp) continue;
                types.add(componentVariable.getComponentType());
                SimpleHash hcvar = new SimpleHash();
                hcvar.put("name", (Object)componentVariable.getVarName());
                hcvar.put("gettername", (Object)this.generateGetterName(componentVariable.getVarName()));
                hcvar.put("type", (Object)componentVariable.getComponentType().getName());
                subcomponents.add((Object)hcvar);
            }
            for (Component component : types) {
                this.visit(component);
            }
        }
        this.currentExpressionEvaluator.setComponentcontext(comp);
        this.currentExpressionEvaluator.setServicecontext(null);
        modelRoot.put("subcomponents", (Object)subcomponents);
        modelRoot.put("name", (Object)comp.getName());
        modelRoot.put("package", (Object)this.starting_package);
        SimpleSequence importList = new SimpleSequence();
        modelRoot.put("generatesimplevue", false);
        for (CostoLibrary lib : comp.getLibraries()) {
            lib.accept((KmlElementVisitor)this);
            if (lib.getName().equals("DEFAULT")) continue;
            importList.add((Object)("static " + this.starting_package + "." + lib.getName() + ".*"));
        }
        modelRoot.put("imports", (Object)importList);
        if (comp.getTypes() != null) {
            for (CostoType ct : comp.getTypes().values()) {
                this.visit(ct);
            }
        }
        if (comp.getVariables() != null) {
            modelRoot.put("fields", (Object)this.createVarDefs(comp.getVariables().values(), ""));
            modelRoot.put("delegatesandcalculatedvar", (Object)this.createCalculatedVarDefs(comp.getVariables().values(), ""));
        }
        if (comp.getConstants() != null) {
            modelRoot.put("constants", (Object)this.createVarDefs(comp.getConstants().values(), "public static final"));
        }
        SimpleSequence initFields = new SimpleSequence();
        if (comp.getInitialization() != null) {
            for (KmlAssignmentExpression kmlAssignmentExpression : comp.getInitialization().values()) {
                initFields.add(kmlAssignmentExpression.acceptEval((ExpressionEvaluatorVisitor)this.currentExpressionEvaluator));
            }
        }
        modelRoot.put("initfields", (Object)initFields);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> nonobslist = new ArrayList<String>();
        if (comp.getInvariant() != null) {
            for (KmlPredicate pred : comp.getInvariant().values()) {
                String name = String.valueOf(pred.getName()) + "Inv()";
                if (pred.isObservable()) {
                    arrayList.add(name);
                } else {
                    nonobslist.add(name);
                }
                SimpleHash assertion = this.createAssertionMethod(pred, name);
                methods.add((Object)assertion);
            }
            methods.add((Object)this.newPredicateMethod("isObsInvariantSatisfied()", arrayList));
            methods.add((Object)this.newPredicateMethod("isNonObsInvariantSatisfied()", nonobslist));
        }
        modelRoot.put("methods", (Object)methods);
        SimpleSequence promotedbindings = new SimpleSequence();
        SimpleSequence services = new SimpleSequence();
        for (Service serv : comp.getServices()) {
            SimpleHash servH = new SimpleHash();
            servH.put("servicename", (Object)serv.getName());
            servH.put("name", (Object)(String.valueOf(comp.getName()) + "_" + serv.getName()));
            servH.put("type", (Object)(serv.isProvided() ? "provided" : "required"));
            servH.put("ispromoted", serv.isPromoted());
            if (serv.isPromoted()) {
                servH.put("origcompname", (Object)serv.getOrigCompName());
                servH.put("origservname", (Object)serv.getOrigServName());
                if (serv.isRequired()) {
                    SimpleHash binding = new SimpleHash();
                    binding.put("bname", (Object)(String.valueOf(serv.getOrigCompName()) + "." + serv.getOrigServName()));
                    binding.put("cclientname", (Object)serv.getOrigCompName());
                    binding.put("cservername", (Object)"SELF");
                    binding.put("sclientname", (Object)serv.getOrigServName());
                    binding.put("sservername", (Object)serv.getName());
                    promotedbindings.add((Object)binding);
                }
            }
            services.add((Object)servH);
            serv.accept((KmlElementVisitor)this);
        }
        modelRoot.put("promotionbindin gs", (Object)promotedbindings);
        modelRoot.put("services", (Object)services);
        this.componentClassRoots.add(modelRoot);
        return false;
    }

    private SimpleSequence createVarDefs(Collection<Variable> vlist, String modifiers) {
        SimpleSequence fieldsList = new SimpleSequence();
        if (vlist != null) {
            for (Variable v : vlist) {
                if (!v.isSimple()) continue;
                SimpleHash f = this.createFieldMapForVariable(v, modifiers);
                fieldsList.add((Object)f);
            }
        }
        return fieldsList;
    }

    private SimpleSequence createCalculatedVarDefs(Collection<Variable> vlist, String modifiers) {
        SimpleSequence fieldsList = new SimpleSequence();
        if (vlist != null) {
            for (Variable v : vlist) {
                if (v.isSimple()) continue;
                SimpleHash field = new SimpleHash();
                field.put("name", (Object)v.getName());
                field.put("gettername", (Object)this.generateGetterName(v.getName()));
                String javaname = this.generateJavaNameForCostoType(v.getCtype());
                field.put("type", (Object)javaname);
                if (v instanceof PromotedVariable) {
                    PromotedVariable p = (PromotedVariable)v;
                    field.put("value", (Object)(String.valueOf(p.getCompVarName()) + "." + this.generateGetterName(p.getOrigin().getName()) + "()"));
                    field.put("origingettername", (Object)this.generateGetterName(p.getOrigin().getName()));
                } else if (v instanceof CalculatedVariable) {
                    field.put("value", v.getExpression().acceptEval((ExpressionEvaluatorVisitor)this.currentExpressionEvaluator));
                    field.put("origingettername", (Object)this.generateGetterName("calc" + v.getName()));
                }
                fieldsList.add((Object)field);
            }
        }
        return fieldsList;
    }

    private String generateGetterName(String name) {
        if (name == null) {
            return null;
        }
        return "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private String generateSetterName(String name) {
        String sname = this.generateGetterName(name);
        if (sname == null) {
            return null;
        }
        return "s" + sname.substring(1);
    }

    private SimpleHash createFieldMapForVariable(Variable v, String modifiers) {
        return this.generateField(v.getName(), v.getCtype(), modifiers, v.getExpression() != null ? (String)v.getExpression().acceptEval((ExpressionEvaluatorVisitor)this.currentExpressionEvaluator) : null, true);
    }

    public boolean visit(ComponentInterface cint) {
        return super.visit(cint);
    }

    public boolean visit(CostoType costotype) {
        RenamedType type;
        String name = null;
        SimpleHash ctypeRoot = new SimpleHash();
        name = this.generateJavaNameForCostoType(costotype);
        SimpleSequence fields = new SimpleSequence();
        ctypeRoot.put("name", (Object)name);
        ctypeRoot.put("package", (Object)this.starting_package);
        if (costotype instanceof CostoRange) {
            costotype = CostoInteger.instance;
        }
        if (costotype instanceof RenamedType) {
            type = (RenamedType)costotype;
            if (type.getSourcetype().isPrimitive()) {
                fields.add((Object)this.generateField("value", type.getSourcetype(), "public", null, true));
            } else {
                ctypeRoot.put("extends", (Object)("extends " + this.generateJavaNameForCostoType(type.getSourcetype())));
            }
            ctypeRoot.put("fields", (Object)fields);
            this.structClassRoots.add(ctypeRoot);
        }
        if (costotype instanceof CostoEnum) {
            type = (CostoEnum)costotype;
            SimpleSequence values = new SimpleSequence((Collection)type.getEnums());
            ctypeRoot.put("values", (Object)values);
            ctypeRoot.put("fields", (Object)fields);
            this.enumClassRoots.add(ctypeRoot);
        }
        if (costotype instanceof StructuredType) {
            StructuredType struct = (StructuredType)costotype;
            ctypeRoot.put("extends", (Object)"extends KmlStruct");
            for (Map.Entry field : struct.getFields().entrySet()) {
                fields.add((Object)this.generateField((String)field.getKey(), (CostoType)field.getValue(), "public", null, true));
            }
            ctypeRoot.put("fields", (Object)fields);
            this.structClassRoots.add(ctypeRoot);
        }
        return super.visit(costotype);
    }

    private boolean needsConstruction(CostoType costotype) {
        boolean hasconstructor;
        boolean bl = hasconstructor = !costotype.isPrimitive();
        if (costotype instanceof CostoRange) {
            hasconstructor = false;
        }
        if (costotype instanceof CostoString) {
            hasconstructor = true;
        }
        if (costotype instanceof CostoEnum) {
            hasconstructor = false;
        }
        return hasconstructor;
    }

    private SimpleHash generateField(String name, CostoType type, String modifiers, String value, boolean hasSetter) {
        SimpleHash field = new SimpleHash();
        field.put("name", (Object)name);
        field.put("gettername", (Object)this.generateGetterName(name));
        field.put("hassetter", hasSetter);
        if (hasSetter) {
            field.put("settername", (Object)this.generateSetterName(name));
        }
        String javaname = this.generateJavaNameForCostoType(type);
        field.put("type", (Object)javaname);
        field.put("isconst", false);
        field.put("modifiers", (Object)modifiers);
        if (type instanceof CostoArray) {
            int bound = ((CostoArray)type).getBorneSup();
            CostoType reftype = ((CostoArray)type).getReftype();
            field.put("array", true);
            field.put("value", (Object)(String.valueOf(this.generateJavaNameForCostoType(reftype)) + "[" + bound + "]"));
            return field;
        }
        if (this.needsConstruction(type)) {
            field.put("needsconstruction", true);
        }
        if (value != null) {
            field.put("isconst", true);
            field.put("value", (Object)value);
        }
        return field;
    }

    private String generateJavaNameForCostoType(CostoType costotype) {
        String name = this.costoToJavaTypes.get(costotype);
        if (name != null) {
            return name;
        }
        if (costotype instanceof CostoRange) {
            this.costoToJavaTypes.put(costotype, "Integer");
            return "Integer";
        }
        name = costotype.getName();
        if (costotype.equals((Object)CostoVoid.instance)) {
            return "void";
        }
        if (costotype instanceof CostoArray) {
            CostoArray array = (CostoArray)costotype;
            name = String.valueOf(this.generateJavaNameForCostoType(array.getReftype())) + "[]";
        }
        if (costotype instanceof CostoSet) {
            String paramname = this.generateJavaNameForCostoType(((CostoSet)costotype).getReftype());
            name = "KmlSet<" + paramname + ">";
        }
        if (costotype instanceof AnyType) {
            name = "Object";
        }
        this.costoToJavaTypes.put(costotype, name);
        return name;
    }

    public boolean visit(Service serv) {
        SimpleHash assertion;
        String name;
        ArrayList reqs;
        SimpleHash servRoot = new SimpleHash();
        servRoot.put("owner", (Object)serv.getOwner().getName());
        servRoot.put("name", (Object)(String.valueOf(serv.getOwner().getName()) + "_" + serv.getName()));
        servRoot.put("servicename", (Object)serv.getName());
        servRoot.put("provided", serv.isProvided());
        servRoot.put("package", (Object)this.starting_package);
        this.currentExpressionEvaluator = new JavaExpressionEvaluatorVisitor(null, serv, this.costoToJavaTypes, this.opmap);
        SimpleSequence importList = new SimpleSequence();
        importList.add((Object)("static " + this.starting_package + "." + serv.getOwner().getName() + ".*"));
        for (CostoLibrary lib : serv.getOwner().getLibraries()) {
            if (lib.getName().equals("DEFAULT")) continue;
            importList.add((Object)("static " + this.starting_package + "." + lib.getName() + ".*"));
        }
        servRoot.put("imports", (Object)importList);
        if (serv.getParameters() != null) {
            servRoot.put("parameters", (Object)this.createVarDefs(serv.getParameters(), ""));
        }
        SimpleSequence reqList = new SimpleSequence();
        if (serv.getInterface() != null && (reqs = serv.getInterface().getAllRequired()) != null) {
            reqs.remove("__CALLER");
            reqList = new SimpleSequence((Collection)reqs);
        }
        servRoot.put("channels", (Object)reqList);
        SimpleSequence fields = new SimpleSequence();
        if (!serv.getReturnCostoType().equals((Object)CostoVoid.instance)) {
            Variable result = new Variable("Result", serv.getReturnCostoType());
            fields.add((Object)this.createFieldMapForVariable(result, "protected"));
            servRoot.put("return", true);
            servRoot.put("returntype", (Object)this.generateJavaNameForCostoType(serv.getReturnCostoType()));
        } else {
            servRoot.put("return", false);
        }
        if (serv.getVariables() != null) {
            for (Variable v : serv.getVariables().values()) {
                fields.add((Object)this.createFieldMapForVariable(v, "protected"));
            }
        }
        servRoot.put("fields", (Object)fields);
        if (serv.getConstants() != null) {
            servRoot.put("constants", (Object)this.createVarDefs(serv.getConstants().values(), "public static final"));
        }
        SimpleSequence initFields = new SimpleSequence();
        if (serv.getInitializations() != null) {
            for (KmlAssignmentExpression init : serv.getInitializations().values()) {
                initFields.add(init.acceptEval((ExpressionEvaluatorVisitor)this.currentExpressionEvaluator));
            }
        }
        servRoot.put("initfields", (Object)initFields);
        SimpleSequence methods = new SimpleSequence();
        SimpleSequence transitionsmethods = new SimpleSequence();
        if (!serv.isPromoted() && serv.getBehavior() != null) {
            servRoot.put("haslts", true);
            for (Transition t : serv.getBehavior().getTransitions()) {
                Label l = t.getLabel();
                SimpleHash guard = this.createMethodFromGuard(l.getGuard(), "guard_" + this.tName(t) + "()");
                methods.add((Object)guard);
                transitionsmethods.add((Object)this.createMethodFromStatement(l.getExpression(), String.valueOf(this.tName(t)) + "()"));
            }
            this.visit(serv.getBehavior());
        } else {
            servRoot.put("haslts", false);
        }
        ArrayList<String> obslist = new ArrayList<String>();
        ArrayList<String> nonobslist = new ArrayList<String>();
        if (serv.getPreMap() != null) {
            for (KmlPredicate pred : serv.getPreMap().values()) {
                name = String.valueOf(pred.getName()) + "Pre()";
                if (pred.isObservable()) {
                    obslist.add(name);
                } else {
                    nonobslist.add(name);
                }
                assertion = this.createAssertionMethod(pred, name);
                methods.add((Object)assertion);
            }
            methods.add((Object)this.newPredicateMethod("isObsPreConditionSatisfied()", obslist));
            methods.add((Object)this.newPredicateMethod("isNonObsPreConditionSatisfied()", nonobslist));
        }
        obslist = new ArrayList();
        nonobslist = new ArrayList();
        if (serv.getPostMap() != null) {
            for (KmlPredicate pred : serv.getPostMap().values()) {
                name = String.valueOf(pred.getName()) + "Post()";
                if (pred.isObservable()) {
                    obslist.add(name);
                } else {
                    nonobslist.add(name);
                }
                assertion = this.createAssertionMethod(pred, name);
                methods.add((Object)assertion);
            }
            methods.add((Object)this.newPredicateMethod("isObsPostConditionSatisfied()", obslist));
            methods.add((Object)this.newPredicateMethod("isNonObsPostConditionSatisfied()", nonobslist));
        }
        ArrayList<String> invlist = new ArrayList<String>();
        if (serv.getInvMap() != null) {
            for (KmlPredicate pred : serv.getInvMap().values()) {
                String name2 = String.valueOf(pred.getName()) + "Inv()";
                invlist.add(name2);
                SimpleHash assertion2 = this.createAssertionMethod(pred, name2);
                methods.add((Object)assertion2);
            }
            methods.add((Object)this.newPredicateMethod("isVirtualInvSatisfied()", invlist));
        }
        servRoot.put("methods", (Object)methods);
        servRoot.put("transitionsmethods", (Object)transitionsmethods);
        if (serv.isPromoted()) {
            this.promotedServicesClassRoots.add(servRoot);
        } else {
            this.servicesClassRoots.add(servRoot);
        }
        return false;
    }

    private SimpleHash newPredicateMethod(String string, ArrayList<String> list) {
        SimpleHash meth = new SimpleHash();
        meth.put("returntype", (Object)"Boolean");
        meth.put("modifiers", (Object)"public ");
        meth.put("signature", (Object)string);
        StringBuilder body = new StringBuilder("Boolean resultA=true;\n");
        if (list != null) {
            for (String assertionMethod : list) {
                body.append("resultA &=");
                body.append(assertionMethod);
                body.append(";\n");
            }
        }
        body.append("return resultA");
        meth.put("body", (Object)body.toString());
        return meth;
    }

    private SimpleHash createAssertionMethod(KmlPredicate pred, String string) {
        SimpleHash meth = new SimpleHash();
        meth.put("returntype", (Object)"Boolean");
        meth.put("modifiers", (Object)"");
        meth.put("signature", (Object)string);
        StringBuilder body = new StringBuilder("Boolean resultA;\n");
        String assertS = (String)pred.acceptEval((ExpressionEvaluatorVisitor)this.currentExpressionEvaluator);
        body.append("resultA=");
        body.append(assertS);
        body.append(";\n");
        String assertRes = "resultA.toString()";
        if (assertS.startsWith("true")) {
            assertRes = "\"NA\"";
            body.append("//");
            body.append(pred.getRawValue());
            body.append("\n");
        }
        body.append("this.assertStatus(\"" + string + "\"" + "," + assertRes + ");\n");
        body.append("return resultA");
        meth.put("body", (Object)body.toString());
        return meth;
    }

    private String tName(Transition t) {
        return String.valueOf(t.getSource().getName()) + "___" + t.getTarget().getName() + "___" + t.getOptindex();
    }

    private SimpleHash createMethodFromStatement(KmlExpression expression, String signature) {
        SimpleHash meth = new SimpleHash();
        meth.put("debug", (Object)expression.getRawValue());
        meth.put("returntype", (Object)"void");
        meth.put("modifiers", (Object)"");
        meth.put("signature", (Object)signature);
        meth.put("body", expression.acceptEval((ExpressionEvaluatorVisitor)this.currentExpressionEvaluator));
        return meth;
    }

    private SimpleHash createMethodFromGuard(KmlCondition guard, String signature) {
        SimpleHash meth = new SimpleHash();
        if (guard != null) {
            meth.put("debug", (Object)guard.getRawValue());
        }
        meth.put("returntype", (Object)"Boolean");
        meth.put("modifiers", (Object)"");
        meth.put("signature", (Object)signature);
        meth.put("body", (Object)("return " + (guard != null ? (String)guard.acceptEval((ExpressionEvaluatorVisitor)this.currentExpressionEvaluator) : "true")));
        return meth;
    }

    public boolean visitConstant(Variable v) {
        return super.visitConstant(v);
    }

    public boolean visitFunction(KmlSignature sig) {
        return super.visitFunction(sig);
    }

    public boolean visitInitialization(KmlAssignmentExpression k) {
        return super.visitInitialization(k);
    }

    public boolean visitInvariant(KmlPredicate k) {
        return super.visitInvariant(k);
    }

    public boolean visitProperty(KmlPredicate k) {
        return super.visitProperty(k);
    }

    public boolean visitVariable(Variable v) {
        return super.visitVariable(v);
    }

    public boolean visit(CostoLibrary comp) {
        if (comp.getName().equals("DEFAULT")) {
            return false;
        }
        if (this.existsLib(comp)) {
            return false;
        }
        SimpleHash libroot = new SimpleHash();
        libroot.put("name", (Object)comp.getName());
        libroot.put("package", (Object)this.starting_package);
        if (comp.getTypes() != null) {
            for (CostoType ct : comp.getTypes().values()) {
                this.visit(ct);
            }
        }
        if (comp.getConstants() != null) {
            libroot.put("constants", (Object)this.createVarDefs(comp.getConstants().values(), "public static final"));
        }
        this.loadOpmap(String.valueOf(comp.getFilePath()) + ".javamapping");
        if (comp.getAllFunctions() != null) {
            libroot.put("methods", (Object)this.createMethodsFromFunctions(comp.getFunctions(), "public static"));
        }
        this.libClassRoots.add(libroot);
        return super.visit(comp);
    }

    private void loadOpmap(String string) {
        System.out.println("loading " + string);
        try {
            Properties mappings = new Properties();
            mappings.load(new FileReader(string));
            this.opmap = new HashMap();
            for (Map.Entry<Object, Object> entry : mappings.entrySet()) {
                String val = (String)entry.getValue();
                SimpleReplacement rep = null;
                rep = val.startsWith("@WithSelf") ? new SimpleReplacementWithThis(val.substring(9)) : new SimpleReplacement(entry.getValue().toString());
                this.opmap.put(entry.getKey().toString(), rep);
            }
        }
        catch (Exception exception) {
            System.err.println("NO mapping found  " + string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean existsLib(CostoLibrary comp) {
        try {
            SimpleHash libhash;
            Iterator<SimpleHash> iterator = this.libClassRoots.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(libhash = iterator.next()).get("name").toString().equals(comp.getName()));
            return true;
        }
        catch (TemplateModelException e) {
            e.printStackTrace();
        }
        return false;
    }

    private SimpleSequence createMethodsFromFunctions(ArrayList<KmlSignature> functions, String modifiers) {
        SimpleSequence methods = new SimpleSequence();
        if (functions == null) {
            return methods;
        }
        for (KmlSignature sig : functions) {
            methods.add((Object)this.createMethodFromFunction(sig, modifiers));
        }
        return methods;
    }

    private SimpleHash createMethodFromFunction(KmlSignature sig, String modifiers) {
        SimpleHash method = new SimpleHash();
        OperatorReplacement mapping = this.opmap.get(sig.getName());
        StringBuffer signature = new StringBuffer();
        String[] params = null;
        signature.append(sig.getName());
        signature.append("(");
        if (sig.getParameters() != null) {
            boolean param = false;
            params = new String[sig.getParameters().size()];
            int i = 0;
            for (CostoType ct : sig.getParameters()) {
                if (ct.equals((Object)CostoVoid.instance)) continue;
                String name = this.generateJavaNameForCostoType(ct);
                signature.append(name);
                int ind = Spec.getIndex();
                signature.append(" the" + name.charAt(0) + ind);
                params[i] = " the" + name.charAt(0) + ind;
                signature.append(",");
                ++i;
                param = true;
            }
            if (param) {
                signature.deleteCharAt(signature.length() - 1);
            }
        }
        if (mapping instanceof SimpleReplacementWithThis) {
            signature.append(", IProvidedService thisparam");
        }
        signature.append(")");
        StringBuffer bodyb = new StringBuffer();
        if (mapping == null) {
            System.err.println("no concrete java mapping found for " + sig);
            this.addMissingMappings(sig);
            this.uglylog.add("no concrete java mapping found for " + sig.getRawValue() + " in " + sig.getDeclarSite());
            bodyb.append("// no java mapping found\n");
            if (!sig.getReturnType().equals((Object)CostoVoid.instance)) {
                bodyb.append("return (");
                bodyb.append(this.generateJavaNameForCostoType(sig.getReturnType()));
                bodyb.append(") new RandomProvider().giveObject(");
                bodyb.append(this.generateJavaNameForCostoType(sig.getReturnType()));
                bodyb.append(".class)");
            }
        } else {
            if (!sig.getReturnType().equals((Object)CostoVoid.instance)) {
                bodyb.append("return ");
            }
            String returnparams = mapping.generateFromFunCall(params);
            returnparams = returnparams.replace("this", "thisparam");
            bodyb.append(returnparams);
        }
        method.put("returntype", (Object)this.generateJavaNameForCostoType(sig.getReturnType()));
        method.put("signature", (Object)signature.toString());
        method.put("modifiers", (Object)modifiers);
        method.put("body", (Object)bodyb.toString());
        return method;
    }

    private void addMissingMappings(KmlSignature sig) {
        ArrayList<Object> sigs = this.missingmappings.get(sig.getDeclarSite());
        if (sigs == null) {
            sigs = new ArrayList();
        }
        sigs.add(sig);
        this.missingmappings.put(sig.getDeclarSite(), sigs);
    }

    public String getStarting_package() {
        return this.starting_package;
    }

    public void setStarting_package(String startingPackage) {
        this.starting_package = startingPackage;
    }

    public Map<CostoType, String> getCostoToJavaTypes() {
        return this.costoToJavaTypes;
    }

    public ArrayList<SimpleHash> getLibClassRoots() {
        return this.libClassRoots;
    }

    public ArrayList<SimpleHash> getStructClassRoots() {
        return this.structClassRoots;
    }

    public ArrayList<SimpleHash> getRenamedClassRoots() {
        return this.renamedClassRoots;
    }

    public ArrayList<SimpleHash> getComponentClassRoots() {
        return this.componentClassRoots;
    }

    public ArrayList<SimpleHash> getServicesClassRoots() {
        return this.servicesClassRoots;
    }

    public SimpleHash getCurrentType() {
        return this.currentType;
    }

    public ArrayList<SimpleHash> getEnumClassRoots() {
        return this.enumClassRoots;
    }

    public boolean visit(LTS lts) {
        SimpleHash modelRoot = new SimpleHash();
        String servicename = String.valueOf(lts.getOwner().getOwner().getName()) + "_" + lts.getOwner().getName();
        modelRoot.put("name", (Object)(String.valueOf(servicename) + "LTS"));
        modelRoot.put("servicename", (Object)servicename);
        modelRoot.put("package", (Object)this.starting_package);
        SimpleSequence importList = new SimpleSequence();
        importList.add((Object)"costo.kml2java.framework.*");
        importList.add((Object)"costo.kml2java.framework.kmllibs.*");
        modelRoot.put("imports", (Object)importList);
        modelRoot.put("initialstate", (Object)lts.getInitialState().getName());
        SimpleSequence states = new SimpleSequence();
        for (State state : lts.getStatesMap().values()) {
            SimpleHash astate = new SimpleHash();
            astate.put("name", (Object)state.getName());
            astate.put("isfinal", lts.getFinalStates().contains(state));
            boolean term = false;
            if (lts.getTerminalStates() != null) {
                term = lts.getTerminalStates().contains(state);
            }
            astate.put("isterminal", term);
            SimpleSequence out = new SimpleSequence();
            if (state.getOutGoingTransitions() != null) {
                for (Transition trans : state.getOutGoingTransitions()) {
                    out.add((Object)this.tName(trans));
                }
            }
            astate.put("outgoing", (Object)out);
            states.add((Object)astate);
        }
        modelRoot.put("states", (Object)states);
        SimpleSequence transitions = new SimpleSequence();
        for (Transition trans : lts.getTransitions()) {
            SimpleHash htrans = new SimpleHash();
            htrans.put("name", (Object)this.tName(trans));
            htrans.put("label", (Object)this.escapeQuotes(trans.getLabel().getRawLabel()));
            if (trans.getLabel().getChannel() != null) {
                htrans.put("channel", (Object)trans.getLabel().getChannel());
                htrans.put("message", (Object)trans.getLabel().getMessage());
                htrans.put("commtype", (Object)trans.getLabel().getActionType());
                htrans.put("iscomm", true);
            } else {
                htrans.put("iscomm", false);
            }
            transitions.add((Object)htrans);
        }
        modelRoot.put("transitions", (Object)transitions);
        this.ltsClassRoots.add(modelRoot);
        return false;
    }

    private String escapeQuotes(String rawLabel) {
        return rawLabel.replaceAll("\"", "\\\\\"");
    }

    public ArrayList<SimpleHash> getLtsClassRoots() {
        return this.ltsClassRoots;
    }

    public HashMap<String, OperatorReplacement> getOpmap() {
        return this.opmap;
    }

    public void setOpmap(HashMap<String, OperatorReplacement> opmap) {
        this.opmap = opmap;
    }

    public ArrayList<SimpleHash> getPromotedServicesClassRoots() {
        return this.promotedServicesClassRoots;
    }

    public ArrayList<String> getUglylog() {
        return this.uglylog;
    }

    public Map<String, ArrayList<KmlSignature>> getMissingmappings() {
        return this.missingmappings;
    }
}

