/*
 * Decompiled with CFR 0.152.
 */
package costo.kml2java.export;

import costo.graph.Component;
import costo.graph.Service;
import costo.graph.Spec;
import costo.graph.Variable;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.KmlArrayExpression;
import costo.graph.expressions.KmlAssignmentExpression;
import costo.graph.expressions.KmlBinOP;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlCompInitExpression;
import costo.graph.expressions.KmlCompositeExpression;
import costo.graph.expressions.KmlCondition;
import costo.graph.expressions.KmlConstant;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlFunction;
import costo.graph.expressions.KmlFunctionCall;
import costo.graph.expressions.KmlIdentifier;
import costo.graph.expressions.KmlIfExpression;
import costo.graph.expressions.KmlLitteralValue;
import costo.graph.expressions.KmlMandatoryCall;
import costo.graph.expressions.KmlNaryOperatorExpression;
import costo.graph.expressions.KmlNopExpression;
import costo.graph.expressions.KmlParOp;
import costo.graph.expressions.KmlPredicate;
import costo.graph.expressions.KmlSignature;
import costo.graph.expressions.KmlTypedStuff;
import costo.graph.expressions.KmlUnaryOp;
import costo.graph.expressions.KmlUnchangedExpression;
import costo.graph.expressions.NavigateExpression;
import costo.graph.types.CostoEnum;
import costo.graph.types.CostoSet;
import costo.graph.types.CostoType;
import costo.graph.types.CostoVoid;
import costo.graph.types.RenamedType;
import costo.kml2java.export.FunctionToIteratorReplacement;
import costo.kml2java.export.FunctionToMethodWithPredicateReplacement;
import costo.kml2java.export.OperatorReplacement;
import costo.kml2java.export.OperatorToFunctionCall;
import costo.kml2java.export.OperatorToMethodCall;
import costo.kml2java.export.SimpleReplacement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaExpressionEvaluatorVisitor
implements ExpressionEvaluatorVisitor<String> {
    private List<KmlBinOP> conditions = new ArrayList<KmlBinOP>();
    HashMap<String, OperatorReplacement> operators = new HashMap();
    public static final String QUOTE = "\"";
    Component componentcontext = null;
    Service servicecontext = null;
    Map<CostoType, String> typesMap = null;
    private boolean notAnAssign = true;

    public JavaExpressionEvaluatorVisitor(Component componentcontext, Service servicecontext, Map<CostoType, String> typesMap, HashMap<String, OperatorReplacement> ops) {
        this.componentcontext = componentcontext;
        this.servicecontext = servicecontext;
        this.typesMap = typesMap;
        if (ops != null) {
            this.operators = ops;
        }
        this.init();
    }

    private void init() {
        this.operators.put("=", new SimpleReplacement("=="));
        this.operators.put("<>", new SimpleReplacement("!="));
        this.operators.put(">", new SimpleReplacement(">"));
        this.operators.put(">=", new SimpleReplacement(">="));
        this.operators.put("<", new SimpleReplacement("<"));
        this.operators.put("<=", new SimpleReplacement("<="));
        this.operators.put("not", new SimpleReplacement("!"));
        this.operators.put("or", new SimpleReplacement("||"));
        this.operators.put("and", new SimpleReplacement("&&"));
        this.operators.put("implies", new OperatorToFunctionCall("implies"));
        this.operators.put("asSTring", new OperatorToMethodCall("toString"));
        this.operators.put("BooleanAsSTring", new OperatorToMethodCall("toString"));
        this.operators.put("IntegerAsSTring", new OperatorToMethodCall("toString"));
        this.operators.put("SetAsSTring", new OperatorToMethodCall("toString"));
        this.operators.put("union", new OperatorToMethodCall("unionK"));
        this.operators.put("count", new OperatorToMethodCall("countK"));
        this.operators.put("excludes", new OperatorToMethodCall("excludesK"));
        this.operators.put("excludesAll", new OperatorToMethodCall("excludesAllK"));
        this.operators.put("excluding", new OperatorToMethodCall("excludingK"));
        this.operators.put("add", new OperatorToMethodCall("addK"));
        this.operators.put("includes", new OperatorToMethodCall("includesK"));
        this.operators.put("includesAll", new OperatorToMethodCall("includesAllK"));
        this.operators.put("including", new OperatorToMethodCall("includingK"));
        this.operators.put("intersection", new OperatorToMethodCall("intersectionK"));
        this.operators.put("isEmpty", new OperatorToMethodCall("isEmptyK"));
        this.operators.put("size", new OperatorToMethodCall("sizeK"));
        this.operators.put("notEmpty", new OperatorToMethodCall("notEmptyK"));
        this.operators.put("oneOf", new OperatorToMethodCall("oneOfK"));
        this.operators.put("differ", new OperatorToMethodCall("differK"));
        this.operators.put("notIn", new OperatorToMethodCall("notInK"));
        this.operators.put("in", new OperatorToMethodCall("inK", true));
        this.operators.put("singleton", new SimpleReplacement("singletonK"));
        this.operators.put("setIterate", new FunctionToIteratorReplacement("setIterate"));
        this.operators.put("setForAllElem", new FunctionToMethodWithPredicateReplacement("setForAllElem"));
        this.operators.put("setExistElem", new FunctionToMethodWithPredicateReplacement("setExistElem"));
        this.operators.put("setFindElem", new FunctionToMethodWithPredicateReplacement("setFindElem"));
        this.operators.put("setSelectElem", new FunctionToMethodWithPredicateReplacement("setSelectElem"));
    }

    public String visit(KmlArrayExpression expression) {
        return String.valueOf((String)expression.getLeftPart().acceptEval((ExpressionEvaluatorVisitor)this)) + "[" + (String)expression.getIndex().acceptEval((ExpressionEvaluatorVisitor)this) + "]";
    }

    public String visit(KmlAssignmentExpression expression) {
        String result = "";
        this.notAnAssign = false;
        String leftpart = (String)expression.getLeftOperand().acceptEval((ExpressionEvaluatorVisitor)this);
        this.notAnAssign = true;
        String rightpart = "";
        if (expression.getRightOperand().isCommunication()) {
            KmlCommunication comm = (KmlCommunication)expression.getRightOperand().deepCopy();
            comm.setActionType(1);
            leftpart = String.valueOf((String)comm.acceptEval((ExpressionEvaluatorVisitor)this)) + "\n";
            String type = this.typesMap.get(expression.getLeftOperand().getType());
            if (type == null) {
                type = expression.getType().toString();
            }
            comm.setActionType(4);
            ArrayList<KmlExpression> parameters = new ArrayList<KmlExpression>();
            parameters.add(expression.getLeftOperand());
            comm.setParameters(parameters);
            rightpart = (String)comm.acceptEval((ExpressionEvaluatorVisitor)this);
            result = String.valueOf(leftpart) + rightpart;
        } else {
            rightpart = (String)expression.getRightOperand().acceptEval((ExpressionEvaluatorVisitor)this);
            int index = rightpart.indexOf("emptySet");
            if (index != -1) {
                rightpart = rightpart.replaceAll("emptySet", "new " + this.typesMap.get(expression.getLeftOperand().getType()) + "()");
            }
            result = String.valueOf(leftpart) + " = (" + expression.getLeftOperand().getType() + ")" + rightpart;
        }
        return result;
    }

    public String visit(KmlBinOP expression) {
        String s = "";
        OperatorReplacement rep = this.operators.get(expression.getOperator());
        if (rep == null) {
            s = String.valueOf((String)expression.getLeftOperand().acceptEval((ExpressionEvaluatorVisitor)this)) + " " + expression.getOperator() + " " + (String)expression.getRightOperand().acceptEval((ExpressionEvaluatorVisitor)this);
        } else if (expression.getOperator().equals("=") && !(expression.getLeftOperand() instanceof KmlConstant)) {
            s = String.valueOf((String)expression.getLeftOperand().acceptEval((ExpressionEvaluatorVisitor)this)) + ".equals(" + (String)expression.getRightOperand().acceptEval((ExpressionEvaluatorVisitor)this) + ")";
        } else {
            if (expression.getLeftOperand() instanceof KmlIdentifier && expression.getRightOperand() instanceof KmlIdentifier) {
                this.conditions.add(expression);
            }
            s = rep.generateFromBinOP((String)expression.getLeftOperand().acceptEval((ExpressionEvaluatorVisitor)this), (String)expression.getRightOperand().acceptEval((ExpressionEvaluatorVisitor)this));
        }
        return s;
    }

    public String visit(KmlCommunication expression) {
        String msgtype = "";
        String assignments = "";
        boolean objects = true;
        switch (expression.getActionType()) {
            case 1: {
                msgtype = "this.callService(";
                break;
            }
            case 32: {
                msgtype = "this.returnService(";
                break;
            }
            case 4: {
                msgtype = "Object[] rcvresult=this.receiveServiceReturn(";
                objects = false;
                break;
            }
            case 2: {
                msgtype = "Object[] rcvresult=this.receiveServiceCall(";
                objects = false;
                break;
            }
            case 16: {
                msgtype = "this.emitMessage(";
                break;
            }
            case 8: {
                msgtype = "Object[] rcvresult=this.receiveMessage(";
                objects = false;
                break;
            }
        }
        StringBuffer params = null;
        if (objects) {
            params = new StringBuffer(",new Object[]{");
            if (expression.getParameters() != null) {
                for (KmlExpression par : expression.getParameters()) {
                    params.append((String)par.acceptEval((ExpressionEvaluatorVisitor)this));
                    params.append(",");
                }
                params.deleteCharAt(params.length() - 1);
            }
        } else {
            params = new StringBuffer(",new Class<?>[]{");
            StringBuffer assignResults = new StringBuffer("\n");
            if (expression.getParameters() != null) {
                int i = 0;
                this.notAnAssign = false;
                for (KmlExpression par : expression.getParameters()) {
                    assignResults.append((String)par.acceptEval((ExpressionEvaluatorVisitor)this));
                    assignResults.append(" = (");
                    assignResults.append(this.typesMap.get(par.getType()));
                    assignResults.append(") rcvresult[");
                    assignResults.append(i);
                    assignResults.append(" ];\n");
                    params.append(this.typesMap.get(par.getType()));
                    params.append(".class,");
                    ++i;
                }
                this.notAnAssign = true;
                params.deleteCharAt(params.length() - 1);
                assignments = assignResults.toString();
            }
        }
        params.append("}");
        return String.valueOf(msgtype) + QUOTE + expression.getInterlocutorSet().toString() + QUOTE + "," + QUOTE + expression.getCommunicationName() + QUOTE + params.toString() + ",this);" + assignments;
    }

    public String visit(KmlCompositeExpression expression) {
        StringBuffer params = new StringBuffer("{");
        if (expression.getExpressions() != null) {
            for (KmlExpression par : expression.getExpressions()) {
                params.append((String)par.acceptEval((ExpressionEvaluatorVisitor)this));
                params.append(";");
            }
        }
        params.append("}");
        return params.toString();
    }

    public String visit(KmlCondition expression) {
        return (String)expression.getExpression().acceptEval((ExpressionEvaluatorVisitor)this);
    }

    public String visit(KmlConstant expression) {
        return expression.getRawValue();
    }

    public String visit(KmlExpression expression) {
        System.err.println("visitor called on unqualified expression" + expression.getPositionAsText() + " " + expression.getClass() + " " + expression.getRawValue());
        return expression.getRawValue();
    }

    public String visit(KmlFunctionCall expression) {
        String result = null;
        String functionName = expression.getFunctionName();
        OperatorReplacement rep = this.operators.get(functionName);
        if (functionName.startsWith("assert")) {
            System.out.println(String.valueOf(expression.getRawValue()) + rep);
        }
        if (rep == null) {
            StringBuffer params = new StringBuffer(functionName);
            params.append("(");
            if (expression.getOperands() != null) {
                for (KmlExpression par : expression.getOperands()) {
                    params.append((String)par.acceptEval((ExpressionEvaluatorVisitor)this));
                    params.append(",");
                }
                params.deleteCharAt(params.length() - 1);
            }
            params.append(")");
            if (expression.getType() == CostoVoid.instance) {
                params.append(";");
            }
            result = params.toString();
        } else {
            ArrayList<String> operands = new ArrayList<String>();
            if (expression.getOperands() != null) {
                CostoType ct;
                for (KmlExpression par : expression.getOperands()) {
                    operands.add((String)par.acceptEval((ExpressionEvaluatorVisitor)this));
                }
                if (expression.getOperands().size() > 0 && (ct = ((KmlExpression)expression.getOperands().get(0)).getType()) instanceof CostoSet) {
                    rep.setReceiverType(this.typesMap.get(((CostoSet)ct).getReftype()));
                }
            }
            result = rep.generateFromFunCall(operands.toArray(new String[1]));
        }
        return result;
    }

    public String visit(KmlIdentifier expression) {
        Variable var = expression.getVar();
        if (var != null) {
            if (var.getCtype() != null && var.getCtype() instanceof CostoEnum && var.isConstant()) {
                return String.valueOf(var.getType()) + "." + var.getName();
            }
            String s = expression.getRawValue();
            String postfix = "";
            if (var.getCtype() != null && var.getCtype() instanceof RenamedType && ((RenamedType)var.getCtype()).getSourcetype().isPrimitive()) {
                postfix = ".value";
            }
            if (!var.isConstant() && this.notAnAssign) {
                s = this.getify(s);
            }
            if (this.servicecontext != null && var.getDeclarationContext() instanceof Component && !var.isConstant()) {
                s = "owner." + s;
            }
            return String.valueOf(s) + postfix;
        }
        return expression.getRawValue();
    }

    private String getify(String s) {
        int i = s.indexOf(".");
        if (i == -1) {
            return "get" + s.substring(0, 1).toUpperCase() + s.substring(1) + "()";
        }
        return "get" + s.substring(0, 1).toUpperCase() + s.substring(1, i) + "()." + s.substring(i + 1, s.length());
    }

    public String visit(KmlIfExpression expression) {
        KmlExpression ifexp = expression.getIfexp();
        KmlExpression elseexp = expression.getElseexp();
        KmlExpression thenexp = expression.getThenexp();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("if (");
        stringBuilder.append((String)ifexp.acceptEval((ExpressionEvaluatorVisitor)this));
        stringBuilder.append(") { ");
        stringBuilder.append((String)thenexp.acceptEval((ExpressionEvaluatorVisitor)this));
        stringBuilder.append(";}");
        if (elseexp != null) {
            stringBuilder.append(" else {");
            stringBuilder.append((String)elseexp.acceptEval((ExpressionEvaluatorVisitor)this));
            stringBuilder.append(";}");
        }
        return stringBuilder.toString();
    }

    public String visit(KmlLitteralValue expression) {
        return expression.getRawValue();
    }

    public String visit(KmlParOp expression) {
        return String.valueOf(expression.getStart()) + (String)expression.getOperand().acceptEval((ExpressionEvaluatorVisitor)this) + expression.getEnd();
    }

    public String visit(KmlPredicate expression) {
        HashMap existentials = expression.getExistentials();
        HashMap universals = expression.getUniversals();
        String s = "";
        if (universals != null) {
            s = String.valueOf(s) + Spec.listToString(universals.values(), (String)"forall ", (String)";", (String)"");
        }
        if (existentials != null) {
            s = String.valueOf(s) + " " + Spec.listToString(existentials.values(), (String)" exists ", (String)";", (String)"");
        }
        if (existentials != null || universals != null) {
            s = String.valueOf(s) + " | ";
        }
        if (!s.equals("")) {
            System.err.println("Cannot currently evaluate forall and exists " + expression.getPositionAsText() + s);
            return "true";
        }
        return (String)expression.getExpression().acceptEval((ExpressionEvaluatorVisitor)this);
    }

    public String visit(KmlSignature expression) {
        System.err.println("visitor called on KmlSignature expression" + expression.getPositionAsText() + " " + expression.getClass() + " " + expression.getRawValue());
        return expression.getRawValue();
    }

    public String visit(KmlFunction expression) {
        System.err.println("visitor called on KmlFunction expression" + expression.getPositionAsText() + " " + expression.getClass() + " " + expression.getRawValue());
        return expression.getRawValue();
    }

    public String visit(KmlTypedStuff expression) {
        System.err.println("visitor called on KmlTypedStuff expression" + expression.getPositionAsText() + " " + expression.getClass() + " " + expression.getRawValue());
        return expression.getRawValue();
    }

    public String visit(KmlUnaryOp expression) {
        String s = "";
        OperatorReplacement rep = this.operators.get(expression.getOpname());
        s = rep == null ? String.valueOf(expression.getOpname()) + " " + (String)expression.getOperand().acceptEval((ExpressionEvaluatorVisitor)this) : rep.generateFromBinOP("", (String)expression.getOperand().acceptEval((ExpressionEvaluatorVisitor)this));
        return s;
    }

    public String visit(NavigateExpression expression) {
        System.err.println("visitor called on NavigateExpression expression" + expression.getPositionAsText() + " " + expression.getClass() + " " + expression.getRawValue());
        return expression.getRawValue();
    }

    public String visit(KmlMandatoryCall expression) {
        System.err.println("visitor called on KmlMandatoryCall expression" + expression.getPositionAsText() + " " + expression.getClass() + " " + expression.getRawValue());
        return "//" + expression.getRawValue();
    }

    public String visit(KmlNaryOperatorExpression expression) {
        System.err.println("visitor called on KmlNaryCall expression" + expression.getPositionAsText() + " " + expression.getClass() + " " + expression.getRawValue());
        return expression.getRawValue();
    }

    public String visit(KmlUnchangedExpression expression) {
        return "true";
    }

    public String visit(KmlNopExpression expression) {
        System.out.println("KmlNopExpression");
        return "";
    }

    public Component getComponentcontext() {
        return this.componentcontext;
    }

    public void setComponentcontext(Component componentcontext) {
        this.componentcontext = componentcontext;
    }

    public Service getServicecontext() {
        return this.servicecontext;
    }

    public void setServicecontext(Service servicecontext) {
        this.servicecontext = servicecontext;
    }

    public String visit(KmlCompInitExpression compinit) {
        String theparams = "";
        ArrayList args = compinit.getArgs();
        if (args == null || args.size() == 0) {
            theparams = String.valueOf(theparams) + ",null";
        }
        for (KmlExpression arg : compinit.getArgs()) {
            theparams = String.valueOf(theparams) + "," + (String)arg.acceptEval((ExpressionEvaluatorVisitor)this);
        }
        String line = String.valueOf(compinit.getCompvarname()) + ".setConfig(\"" + compinit.getInitservicename() + QUOTE + theparams + ");";
        return line;
    }

    public void setConditions(List<KmlBinOP> conditions) {
        this.conditions = conditions;
    }

    public List<KmlBinOP> getConditions() {
        return this.conditions;
    }
}

