/*
 * Decompiled with CFR 0.152.
 */
package kml2latex.visitors;

import costo.graph.Component;
import costo.graph.ComponentInterface;
import costo.graph.Composition;
import costo.graph.LTS;
import costo.graph.Label;
import costo.graph.Service;
import costo.graph.ServiceInterface;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.types.CostoType;
import costo.graph.visitors.KmlElementAbstractVisitor;
import costo.utils.exports.EPSUtils;
import costo.utils.exports.LTStoEPS;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import kml2latex.LatexContext;
import kml2latex.visitors.KmlLatexExpressionVisitor;
import utils.LatexUtils;

public class KmlLatexVisitor
extends KmlElementAbstractVisitor {
    private LatexContext lctx;
    private HashSet<String> cvisited;
    private String spec;
    private ArrayList<ServDesc> services;
    private String composition;
    private ArrayList<Assoc> components;

    public KmlLatexVisitor(LatexContext lctx, ExpressionVisitor ev) {
        super(ev);
        this.lctx = lctx;
        this.cvisited = new HashSet();
        this.services = new ArrayList();
        this.components = new ArrayList();
    }

    public KmlLatexVisitor(LatexContext lctx) {
        super((ExpressionVisitor)new KmlLatexExpressionVisitor());
        this.lctx = lctx;
        this.cvisited = new HashSet();
        this.services = new ArrayList();
        this.components = new ArrayList();
    }

    public HashSet<String> getCvisited() {
        return this.cvisited;
    }

    public boolean visit(Component comp) {
        this.spec = comp.toString(false, true, true, true, true, true, true, true, false, false);
        this.cvisited.add(comp.getName());
        return super.visit(comp);
    }

    public boolean visit(Composition comp) {
        this.composition = comp.toString();
        return super.visit(comp);
    }

    public boolean visit(ComponentInterface cint) {
        return super.visit(cint);
    }

    public boolean visit(Object o) {
        return super.visit(o);
    }

    public boolean visit(Service srv) {
        String servcomment = srv.getComment();
        if (servcomment.isEmpty()) {
            servcomment = "no comment";
        }
        if (srv.getBehavior() != null) {
            String servfilename;
            String outfilename = servfilename = String.valueOf(this.lctx.getComponent().getName()) + "_" + srv.getName();
            String epsfilename = String.valueOf(servfilename) + ".eps";
            try {
                Double width;
                LTStoEPS.write((LTS)srv.getBehavior(), (String)(String.valueOf(this.lctx.getOutputdir()) + "FIGURES/"), (String)servfilename, (Properties)this.lctx.getKml2latexProp());
                Point size = EPSUtils.getBoundingBox((String)(String.valueOf(this.lctx.getOutputdir()) + "FIGURES/" + epsfilename));
                if (size.getX() == 0.0 && size.getY() == 0.0) {
                    size.x = (srv.getBehavior().getNbState() / 10 + 1) * 14 * 100;
                }
                if ((width = Double.valueOf(size.getX() / 80.0)) > 17.0) {
                    width = 17.0;
                }
                this.services.add(new ServDesc(srv.getName(), servcomment, srv.toString(), outfilename, width.toString()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.services.add(new ServDesc(srv.getName(), servcomment, srv.toString(), "no LTS output", ""));
        }
        return super.visit(srv);
    }

    public boolean visit(ServiceInterface sint) {
        return super.visit(sint);
    }

    public boolean visit(CostoType costotype) {
        return super.visit(costotype);
    }

    public boolean visit(LTS lts) {
        return super.visit(lts);
    }

    public boolean visit(Label label) {
        return super.visit(label);
    }

    public String getSpec() {
        return this.spec;
    }

    public List<ServDesc> getServices() {
        return this.services;
    }

    public String getComposition() {
        return this.composition;
    }

    public class Assoc {
        String name;
        String spec;

        public String getName() {
            return this.name;
        }

        public String getSpec() {
            return this.spec;
        }

        public Assoc(String name, String spec) {
            this.name = LatexUtils.LatexFilter(name);
            this.spec = spec;
        }
    }

    public class ServDesc
    extends Assoc {
        String outfilename;
        String comment;
        String size;

        public String getOutfilename() {
            return this.outfilename;
        }

        public String getSize() {
            return this.size;
        }

        public String getComment() {
            return this.comment;
        }

        public ServDesc(String name, String comment, String spec, String outfilename, String size) {
            super(name, spec);
            this.comment = comment;
            this.outfilename = outfilename;
            this.size = size;
        }
    }
}

