/*
 * Decompiled with CFR 0.152.
 */
package costo.checks.debug;

import antlr.collections.AST;
import antlr.debug.misc.ASTFrame;
import costo.graph.Component;
import costo.graph.ComponentFactory;
import costo.graph.CostoLibrary;
import costo.graph.Spec;
import java.io.File;

public class GrammarDebugTest {
    private static boolean verbose = false;
    private static boolean tous = false;

    public static void main(String[] args) {
        if (tous) {
            GrammarDebugTest.tous();
        } else {
            GrammarDebugTest.unseul(args);
        }
    }

    private static void tous() {
        File directory = new File("/home/ardourel-g/workspace/Copy of zeroCOSTO_V2/spec");
        if (!directory.isDirectory()) {
            GrammarDebugTest.output(String.valueOf(directory.getName()) + " is not a directory");
        }
        GrammarDebugTest.listContents(directory, "");
    }

    private static void unseul(String[] args) {
        GrammarDebugTest.doTestCmpFile("/home/ardourel-g/workspaces/standard/KML_SPECS/kmelia/DISTRIBUTEUR/", "Distributeur.cmp");
    }

    static void listContents(File dir, String indent) {
        String[] files;
        indent = String.valueOf(indent) + " ";
        String[] stringArray = files = dir.list();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            File f = new File(String.valueOf(dir.getAbsolutePath()) + "/" + file);
            if (f.isDirectory()) {
                GrammarDebugTest.listContents(f, indent);
            } else if (file.endsWith(".cmp")) {
                GrammarDebugTest.outputd("\n" + indent + "found component " + dir.getAbsolutePath() + "/" + file);
                GrammarDebugTest.doTestCmpFile(String.valueOf(dir.getAbsolutePath()) + "/", file);
            }
            ++n2;
        }
    }

    private static void output(String line) {
        if (!verbose) {
            return;
        }
        System.out.println(line);
    }

    private static void outputd(String line) {
        System.out.println(line);
    }

    private static void doTestCmpFile(String abspath, String filename) {
        String compname = String.valueOf(abspath) + filename;
        try {
            ComponentFactory cf = new ComponentFactory();
            cf.init();
            cf.loadDefaultLibrary("/home/ardourel-g/workspaces/standard/COSTOLIB_PLUGIN_CORE/kmllibs/");
            cf.setDebug(true);
            cf.setAbsSpecDir(abspath);
            Component thecomp = cf.getComponent(compname);
            System.out.println("+loading" + abspath + " " + compname);
            if (thecomp == null) {
                System.out.println("FAILED" + cf.getLogger().dumpAllErrors());
            } else {
                System.out.println(thecomp.toString());
                System.out.println(cf.getLogger().dumpAllErrors());
                System.out.println("hop");
                for (CostoLibrary lib : thecomp.getLibraries()) {
                    System.out.println(String.valueOf(lib.getName()) + lib.getFunctions());
                    Spec.listToString(lib.getFunctions(), String.valueOf(lib.getName()) + " FUNCTIONS ", "\n", "");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void playWithAST(Component thecomp) {
        AST as = thecomp.getAst();
        System.out.println(as.toStringList());
        ASTFrame f = new ASTFrame(thecomp.getName(), as);
        f.setVisible(true);
    }
}

