/*
 * Decompiled with CFR 0.152.
 */
package costo.checks.debug;

import costo.Loader;
import costo.graph.Component;
import costo.graph.ComponentInterface;
import costo.graph.Service;
import costo.graph.ServiceInterface;
import java.util.ArrayList;
import java.util.Iterator;

public class Interfaces {
    public static void main(String[] args) throws Exception {
        try {
            String[] nothing = null;
            Component myComponent = Loader.loadComponent(nothing);
            Iterator<Service> iterator = myComponent.getServices().iterator();
            while (iterator.hasNext()) {
                Service element;
                Service currentService = element = iterator.next();
                ServiceInterface declaredinterf = currentService.getInterface();
                System.out.println(" Checking Interface of Service " + currentService.getName() + "with Component " + myComponent.getName());
                System.out.println(Interfaces.checkServiceInterfComponentCompatibility(declaredinterf, myComponent));
                new ServiceInterface(currentService.getBehavior());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList checkServiceInterfComponentCompatibility(ServiceInterface servinterf, Component comp) {
        ArrayList listofprovided;
        ArrayList<String> messages = new ArrayList<String>();
        ComponentInterface compi = comp.getInterface();
        ArrayList listofrequired = servinterf.getExtrequired();
        if (listofrequired != null) {
            listofrequired = (ArrayList)listofrequired.clone();
            listofrequired.removeAll(compi.getRequired());
            if (listofrequired.size() > 0) {
                messages.add("Following services are required by the service but not required by the component " + listofrequired + "\n");
            }
        }
        if ((listofprovided = servinterf.getSubprovided()) != null) {
            listofprovided = (ArrayList)listofprovided.clone();
            listofprovided.removeAll(comp.getServicesMap().keySet());
            if (listofprovided.size() > 0) {
                messages.add("Following subservices are provided by the service but are not found in the component " + listofprovided + "\n");
            }
            listofprovided = (ArrayList)servinterf.getSubprovided().clone();
            listofprovided.retainAll(compi.getProvided());
            if (listofprovided.size() > 0) {
                messages.add("Following subservices are provided by the service AND the component " + listofprovided + "\n");
            }
        }
        if (messages.size() == 0) {
            return null;
        }
        return messages;
    }
}

