/*
 * Decompiled with CFR 0.152.
 */
package costo.checks.process;

import costo.graph.LTS;
import costo.graph.State;
import costo.graph.ltsutils.LTSUtils;
import costo.graph.ltsutils.StateAction;
import costo.graph.ltsutils.TransitionAction;
import java.util.Collection;
import java.util.HashSet;

public class LTSChecker {
    public static Collection<State> statesNotReachingFinal(LTS l) {
        String mark = "reach";
        StateAction sa = new StateAction(mark);
        TransitionAction ta = new TransitionAction();
        HashSet<State> reachedstates = new HashSet<State>();
        HashSet<State> totalstates = new HashSet<State>();
        totalstates.addAll(l.getStatesMap().values());
        for (State finstate : l.getFinalStates()) {
            LTSUtils.parcoursrec(finstate, sa, ta, false);
            reachedstates.addAll(LTSUtils.getMarkedStates(l, mark));
            LTSUtils.removeMarks(l, mark);
        }
        totalstates.removeAll(reachedstates);
        if (totalstates.size() > 0) {
            return totalstates;
        }
        return null;
    }

    public static Collection<State> unreachableStates(LTS l) {
        String mark = "reach";
        StateAction sa = new StateAction(mark);
        TransitionAction ta = new TransitionAction();
        HashSet<State> reachedstates = new HashSet<State>();
        HashSet<State> totalstates = new HashSet<State>();
        totalstates.addAll(l.getStatesMap().values());
        LTSUtils.parcours(l, sa, ta, true);
        reachedstates.addAll(LTSUtils.getMarkedStates(l, mark));
        LTSUtils.removeMarks(l, mark);
        totalstates.removeAll(reachedstates);
        if (totalstates.size() > 0) {
            return totalstates;
        }
        return null;
    }
}

