/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.checks.errorLogger.KmlLogger;
import costo.graph.AssemblyVariable;
import costo.graph.Component;
import costo.graph.ComponentFactory;
import costo.graph.ComponentVariable;
import costo.graph.KmlContext;
import costo.graph.KmlStructuralElement;
import costo.graph.Link;
import costo.graph.NonExistingLinkException;
import costo.graph.Spec;
import costo.graph.Variable;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlCompInitExpression;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlSignature;
import costo.graph.types.CostoType;
import costo.graph.visitors.KmlElementVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class Assembly
extends KmlStructuralElement
implements KmlContext {
    private String name;
    private String filePath;
    private ArrayList<AssemblyVariable> assemblies = new ArrayList();
    private ArrayList<ComponentVariable> namedComponents = new ArrayList();
    private HashMap<String, Link> links = new HashMap();
    private ComponentFactory context;
    private Component owner;
    private ArrayList<KmlCompInitExpression> inits = new ArrayList();

    public ArrayList<ComponentVariable> getAssemblyNamedComponents() {
        ArrayList<ComponentVariable> all = new ArrayList<ComponentVariable>();
        all.addAll(this.namedComponents);
        if (this.assemblies == null) {
            this.assemblies = new ArrayList();
        }
        for (AssemblyVariable av : this.assemblies) {
            all.addAll(av.getAssembly().getAssemblyNamedComponents());
        }
        return all;
    }

    public ArrayList<ComponentVariable> getNamedComponents() {
        return this.namedComponents;
    }

    public ArrayList<ComponentVariable> getNamedComponentsWithoutSelf() {
        ComponentVariable myself = this.getComponentVariable("SELF");
        ArrayList components = (ArrayList)this.namedComponents.clone();
        components.remove(myself);
        return components;
    }

    public ComponentVariable getComponentVariable(String name) {
        for (ComponentVariable cvar : this.namedComponents) {
            if (!cvar.getVarName().equals(name)) continue;
            return cvar;
        }
        return null;
    }

    public void setNamedComponents(ArrayList<ComponentVariable> namedComponents) {
        this.namedComponents = namedComponents;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public HashMap<String, Link> getLinks() {
        return this.links;
    }

    public ArrayList<AssemblyVariable> getAssemblies() {
        return this.assemblies;
    }

    public void setAssemblies(ArrayList<AssemblyVariable> assemblies) {
        this.assemblies = assemblies;
    }

    public void setLinks(HashMap<String, Link> links) {
        this.links = links;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String s = String.valueOf(indent) + (this.name == null ? "Assembly" : "ASSEMBLY " + this.name);
        s = String.valueOf(s) + Spec.listToString(this.getNamedComponentsWithoutSelf(), "\n" + indent + "Components\n" + indent + indent, ";\n" + indent + indent, "");
        s = String.valueOf(s) + Spec.listToString(this.inits, "\n" + indent + "Configuration\n" + indent + indent, ";\n" + indent + indent, "\n");
        s = String.valueOf(s) + Spec.listToString(this.assemblies, "\n" + indent + "Assemblies\n" + indent + indent, ";\n" + indent + indent, "\n");
        s = String.valueOf(s) + Spec.mapToString(this.links, String.valueOf(indent) + "Links ////////////assembly links//////////\n" + indent + indent + "@", ":" + indent, "\n" + indent + indent + "@", "");
        s = String.valueOf(s) + indent + "\nEnd // assembly\n";
        return s;
    }

    public void structureCompletion() {
        if (this.assemblies != null) {
            this.resolveAssemblies();
        }
        if (this.namedComponents != null) {
            this.resolveComponents();
        }
        if ((this.assemblies == null || this.assemblies.isEmpty()) && (this.namedComponents == null || this.namedComponents.isEmpty())) {
            this.context.getLogger().log("an assembly should have components or other assemblies", this, "CONSISTENCY WARNING", this.getLine(), this.getColumn(), this.context.getCurrentFile());
        }
        this.resolveCompInit();
    }

    private void resolveCompInit() {
        if (this.inits == null) {
            return;
        }
        for (KmlCompInitExpression compinit : this.inits) {
            KmlContext varcontext;
            ComponentVariable cv = this.getComponentVariable(compinit.getCompvarname());
            compinit.setCompvar(cv);
            if (cv == null) {
                this.context.getLogger().log("Component Variable " + compinit.getCompvarname() + " not found ", this, "RESOLUTION ERROR", compinit.getLine(), compinit.getColumn(), this.context.getCurrentFile());
            }
            KmlContext kmlContext = varcontext = this.owner == null ? this.context : this.owner;
            if (!compinit.resolveType(varcontext)) continue;
            compinit.resolveService(this.context);
        }
    }

    public ComponentFactory getContext() {
        return this.context;
    }

    public void setContext(ComponentFactory context) {
        this.context = context;
    }

    public void resolveLinks() {
        if (this.links != null) {
            for (Link link : this.links.values()) {
                link.setOwner(this);
                link.resolveSubLinks(this.links);
                link.resolve(this);
            }
        }
    }

    private void resolveComponents() {
        for (ComponentVariable cvar : this.namedComponents) {
            if (cvar.getVarName().equals("SELF") || cvar.isLoaded()) continue;
            cvar.loadType(this.context);
            cvar.setContext(this);
        }
    }

    private void resolveAssemblies() {
        for (AssemblyVariable avar : this.assemblies) {
            avar.loadType(this.context);
        }
    }

    @Override
    public void accept(KmlElementVisitor visitor) {
        if (visitor.visit(this) && this.links != null) {
            for (Link ln : this.links.values()) {
                visitor.visit(ln);
            }
        }
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Link getLink(String linkname) throws NonExistingLinkException {
        if (this.links.containsKey(linkname)) {
            return this.links.get(linkname);
        }
        throw new NonExistingLinkException(linkname);
    }

    @Override
    public void addFunction(KmlSignature sig) {
    }

    @Override
    public KmlLogger getLogger() {
        return this.context.getLogger();
    }

    @Override
    public Variable lookupVariable(String n) {
        return null;
    }

    @Override
    public KmlSignature resolveCommunication(KmlCommunication comm) {
        return null;
    }

    @Override
    public KmlSignature resolveFunction(String functionName, ArrayList<CostoType> operandsTypes, KmlExpression source) {
        return null;
    }

    @Override
    public CostoType resolveType(String name) {
        return null;
    }

    public void setCurrentFile(String currentFile) {
        this.context.setCurrentFile(currentFile);
    }

    @Override
    public void setLogger(KmlLogger log) {
        this.context.setLogger(log);
    }

    public Component getOwner() {
        return this.owner;
    }

    public void setOwner(Component owner) {
        this.owner = owner;
    }

    @Override
    public Set<KmlSignature> getAllFunctions() {
        return null;
    }

    public void setCompInit(ArrayList<KmlCompInitExpression> inits) {
        this.inits = inits;
    }

    public ArrayList<KmlCompInitExpression> getCompInits() {
        return this.inits;
    }

    public Assembly shallowCopy() {
        Assembly copy = new Assembly();
        copy.setAssemblies((ArrayList)this.assemblies.clone());
        copy.setNamedComponents((ArrayList)this.namedComponents.clone());
        copy.name = this.name == null ? null : String.valueOf(new String(this.getName())) + "Copy";
        copy.context = this.context;
        copy.filePath = this.filePath;
        copy.inits = this.inits;
        copy.links = this.links;
        copy.owner = this.owner;
        return copy;
    }
}

