/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import antlr.collections.AST;
import costo.checks.errorLogger.KmlLogger;
import costo.checks.process.ObservablePredicateCheckingVisitor;
import costo.graph.CalculatedVariable;
import costo.graph.ComponentFactory;
import costo.graph.ComponentInstance;
import costo.graph.ComponentInterface;
import costo.graph.Composition;
import costo.graph.ConstantsClause;
import costo.graph.CostoLibrary;
import costo.graph.InitializationsClause;
import costo.graph.InvariantClause;
import costo.graph.KmlContext;
import costo.graph.KmlElement;
import costo.graph.KmlStructuralElement;
import costo.graph.LTS;
import costo.graph.Link;
import costo.graph.PromotedVariable;
import costo.graph.Service;
import costo.graph.Spec;
import costo.graph.Variable;
import costo.graph.VariablesClause;
import costo.graph.VerificationCode;
import costo.graph.expressions.KmlAssignmentExpression;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlPredicate;
import costo.graph.expressions.KmlSignature;
import costo.graph.expressions.KmlTypedStuff;
import costo.graph.types.CostoEnum;
import costo.graph.types.CostoType;
import costo.graph.types.CostoTypeSpace;
import costo.graph.types.CostoUnknownType;
import costo.graph.visitors.KmlElementVisitor;
import costo.graph.visitors.VariableUsage;
import costo.graph.visitors.VariableUsageComponentVisitor;
import costo.graph.visitors.VariableUsageExpressionVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Component
extends KmlElement
implements KmlContext {
    private String comment = "";
    private String filepath;
    private boolean appli;
    private boolean appliTest;
    private boolean intention = false;
    private ComponentInterface componentInterface = new ComponentInterface();
    private HashMap<String, Service> services;
    private VariablesClause variablesClause = new VariablesClause();
    private ConstantsClause constantsClause = new ConstantsClause();
    private HashMap<String, Variable> enumconstants;
    private InitializationsClause initializationsClause = new InitializationsClause();
    private HashMap<String, KmlPredicate> properties;
    private InvariantClause invariantClause = new InvariantClause();
    private ArrayList<KmlSignature> functions;
    private String status;
    private ComponentFactory factory;
    private KmlLogger logger;
    private HashMap<String, String> serviceProperties;
    private Composition composition;
    private String name;
    private ArrayList<CostoLibrary> libraries;
    private CostoTypeSpace typeSpace;
    private int nbInstance = 0;
    private ArrayList<ComponentInstance> instances = new ArrayList();
    private AST Ast;

    public ComponentFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ComponentFactory factory) {
        this.factory = factory;
    }

    public Component(String name) {
        this.name = name;
        this.services = new HashMap();
        this.componentInterface = new ComponentInterface();
        this.typeSpace = new CostoTypeSpace();
    }

    @Override
    public String getFilePath() {
        return this.filepath;
    }

    @Override
    public void setFilePath(String filepath) {
        this.filepath = filepath;
    }

    public void addType(CostoType ct) {
        if (ct == null) {
            return;
        }
        if (this.typeSpace == null) {
            this.typeSpace = new CostoTypeSpace();
        }
        this.typeSpace.put(ct.getName(), ct);
    }

    public void addService(Service s) {
        if (s == null) {
            return;
        }
        this.services.put(s.getName(), s);
        s.setOwner(this);
    }

    public void setServices(ArrayList<Service> al) {
        if (al != null) {
            for (Service serv : al) {
                this.addService(serv);
            }
        }
    }

    public HashMap<String, Service> getServicesMap() {
        return this.services;
    }

    public Service getService(String name) {
        return this.services.get(name);
    }

    public Collection<Service> getServices() {
        return this.services.values();
    }

    public Collection<Service> getServicesMeetingCriterion(int criterion) {
        ArrayList<Service> servlist = new ArrayList<Service>();
        for (Service serv : this.services.values()) {
            if (!serv.meetsCriterion(criterion)) continue;
            servlist.add(serv);
        }
        return servlist;
    }

    public Collection<Service> getLocalCallersOfRequiredServices(Service req) {
        if (req.isProvided()) {
            return null;
        }
        ArrayList<Service> list = new ArrayList<Service>();
        for (Service serv : this.services.values()) {
            if (!serv.isProvided() || !serv.getInterface().getExtrequired().contains(req.getName())) continue;
            list.add(serv);
        }
        return list;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Composition getComposition() {
        return this.composition;
    }

    public void setComposition(Composition composition) {
        if (this.composition != null) {
            this.composition.setOwner(null);
        }
        this.composition = composition;
        if (this.composition != null) {
            this.composition.setOwner(this);
        }
    }

    public void setServicesOwnership() {
        Iterator<Service> iterator = this.getServices().iterator();
        while (iterator.hasNext()) {
            Service element;
            Service serv = element = iterator.next();
            serv.setOwner(this);
        }
    }

    private void checkInterface() {
        this.chekInterfacesFromStringCollection(this.componentInterface.getProvided(), true, " provided service ", this.componentInterface);
        this.chekInterfacesFromStringCollection(this.componentInterface.getRequired(), true, " required service ", this.componentInterface);
        for (Service s : this.services.values()) {
            if (s.isPromoted() || s.getInterface() == null) continue;
            this.chekInterfacesFromStringCollection(s.getInterface().getCalrequired(), false, " sub required service ", s.getInterface());
            this.chekInterfacesFromStringCollection(s.getInterface().getExtrequired(), false, " ext required service ", s.getInterface());
            this.chekInterfacesFromStringCollection(s.getInterface().getSubprovided(), true, " sub provided service ", s.getInterface());
        }
    }

    private void chekInterfacesFromStringCollection(Collection<String> coll, boolean isprovided, String errormessage, KmlElement source) {
        if (coll == null) {
            return;
        }
        for (String servname : coll) {
            if (this.services.get(servname) != null) continue;
            this.getLogger().log(String.valueOf(errormessage) + servname + " has no specification in component" + this.name, this, "INTERFACE ERROR", source.getLine(), source.getColumn(), this.getFilePath());
        }
    }

    public void structureCompletion() {
        if (this.filepath != null && !this.getFilePath().endsWith(String.valueOf(this.name) + ".kcp")) {
            this.logger.log("Component Name " + this.name + " must match filename " + this.getFilePath(), this, "RESOLUTION ERROR", 1, 1, this.filepath);
        }
        this.setServicesOwnership();
        if (this.composition != null) {
            this.composition.structureCompletion();
        }
        this.checkInterface();
        this.resolveServiceHooks();
        this.checkTypes();
        this.checkVariables();
        this.checkConstants();
        this.checkDefinedVariables();
        this.generateEnums();
        this.checkInitialization();
        this.checkInvariant();
        this.checkProperties();
        this.checkServices();
        this.launchVisitors();
        this.checkVariableUsage();
        this.isComposite();
    }

    @VerificationCode
    private void checkObservabilityAndPromotionOfVariablesInvolvedInPromotedServices() {
        for (Service serv : this.services.values()) {
            if (!serv.isPromoted() || !serv.isProvided() || serv.getPreMap() != serv.getOriginalservice().getPreMap() || serv.getPreMap() == null) continue;
            for (KmlPredicate kmlpred : serv.getPreMap().values()) {
                if (!kmlpred.isObservable()) continue;
                VariableUsageExpressionVisitor visitor = new VariableUsageExpressionVisitor(serv.getOriginalservice());
                kmlpred.accept(visitor);
                if (visitor.getVarUsage().getReadVarlist() == null) continue;
                for (Variable v : visitor.getVarUsage().getReadVarlist()) {
                    v.getDeclarationContext();
                    serv.getOrigin().getComponentType();
                }
            }
        }
    }

    private void checkVariableUsage() {
        for (Service s : this.getServices()) {
            s.accept(new VariableUsageComponentVisitor(s));
            VariableUsage varusage = (VariableUsage)s.getProperty("variablevisit");
            ArrayList<Variable> vars = s.getUnchangedVars();
            if (varusage == null) continue;
            for (Variable v : varusage.getModifiedVarlist()) {
                if (v.getDeclarationContext() == this && s.isQuery()) {
                    this.getLogger().log("variable " + v + " should not be modified in query service " + s.getName(), s, "ASSERTION ERROR", s.getLine(), s.getColumn(), this.getFilePath());
                }
                if (!vars.contains(v)) continue;
                this.getLogger().log("variable " + v + " is marked as Unchanged in postcondition. It should not be modified in service " + s.getName(), s, "ASSERTION ERROR", s.getLine(), s.getColumn(), this.getFilePath());
            }
        }
    }

    private void launchVisitors() {
        if (this.factory == null) {
            return;
        }
        if (this.factory.getVisitors() != null) {
            for (KmlElementVisitor visitor : this.factory.getVisitors()) {
                this.accept(visitor);
            }
        }
    }

    @VerificationCode
    private void checkInvariant() {
        if (this.getInvariant() == null) {
            return;
        }
        for (KmlPredicate pred : this.invariantClause.getInvariant().values()) {
            pred.resolveType(this);
            if (!pred.isObservable()) continue;
            pred.accept(new ObservablePredicateCheckingVisitor(this));
        }
    }

    private void checkProperties() {
        if (this.getProperties() == null) {
            return;
        }
        for (KmlPredicate pred : this.properties.values()) {
            pred.resolveType(this);
        }
    }

    private void checkDefinedVariables() {
        if (this.getVariables() == null) {
            return;
        }
        for (Variable var : this.variablesClause.getVariables().values()) {
            if (var == null || !(var instanceof CalculatedVariable)) continue;
            var.getExpression().resolveType(this);
        }
    }

    private void checkVariables() {
        if (this.getVariables() == null) {
            return;
        }
        for (Variable var : this.variablesClause.getVariables().values()) {
            if (var == null) continue;
            try {
                if (var.getCtype() != null) {
                    var.getCtype().resolve(this);
                    continue;
                }
                if (!(var instanceof PromotedVariable)) continue;
                PromotedVariable pvar = (PromotedVariable)var;
                if (!this.isComposite()) {
                    this.logger.log("Cannot promote variable" + var + " in a primitive component", var, "PROMOTION ERROR", pvar.getLine(), pvar.getColumn(), this.getFilePath());
                    continue;
                }
                pvar.setComp(this.composition.getComponent(pvar.getCompVarName()));
                if (pvar.getComp() == null) {
                    this.logger.log("Sub-component" + pvar.getCompVarName() + " not found ", var, "PROMOTION ERROR", pvar.getLine(), pvar.getColumn(), this.getFilePath());
                    continue;
                }
                pvar.setOrigin(pvar.getComp().getVariables().get(pvar.getSourceVarName()));
                if (pvar.getOrigin() == null) {
                    this.logger.log("variable " + pvar.getSourceVarName() + " not found in " + pvar.getCompVarName() + ":" + pvar.getComp().getName(), var, "PROMOTION ERROR", pvar.getLine(), pvar.getColumn(), this.getFilePath());
                    continue;
                }
                if (pvar.getOrigin().isObservable()) continue;
                this.logger.log("variable " + pvar.getSourceVarName() + " not observable in " + pvar.getCompVarName() + ":" + pvar.getComp().getName(), var, "PROMOTION ERROR", pvar.getLine(), pvar.getColumn(), this.getFilePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @VerificationCode
    private void checkTypes() {
        for (CostoType ctype : this.typeSpace.getTypeMap().values()) {
            ctype.resolve(this);
        }
    }

    private void generateEnums() {
        for (CostoType ct : this.typeSpace.getTypeMap().values()) {
            if (!(ct instanceof CostoEnum)) continue;
            if (this.enumconstants == null) {
                this.enumconstants = new HashMap();
            }
            this.enumconstants.putAll(((CostoEnum)ct).generateConstants());
        }
    }

    @VerificationCode
    private void checkConstants() {
        if (this.getConstants() != null) {
            for (Variable var : this.constantsClause.getConstants().values()) {
                if (var.getExpression() == null) continue;
                if (!var.getExpression().resolveType(this)) {
                    this.logger.log("Cannot type " + var, var, "TYPE ERROR", var.getExpression().getLine(), var.getExpression().getColumn(), this.getFilePath());
                    continue;
                }
                if (KmlTypedStuff.typeCheck(var.getExpression(), var.getCtype())) continue;
                this.getLogger().log(" in " + var + " : " + var.getExpression() + " of type " + var.getExpression().getType() + "cannot be assigned to " + var.getName() + " of type " + var.getType(), var, "TYPE ERROR", var.getExpression().getLine(), var.getExpression().getColumn(), this.getFilePath());
            }
        }
    }

    @VerificationCode
    private void checkInitialization() {
        this.initializationsClause.resolve(this, this.getLogger(), this.filepath);
    }

    private void resolveServiceHooks() {
        for (Service serv : this.services.values()) {
            serv.resolveServiceHooks();
        }
    }

    private void checkServices() {
        for (Service service : this.services.values()) {
            if (service.isPromoted()) {
                if (!this.isComposite()) {
                    this.logger.log("Cannot promote service" + service.getName() + " in a primitive component", service, "PROMOTION ERROR", service.getLine(), service.getColumn(), this.getFilePath());
                } else {
                    Component orig = this.composition.getComponent(service.getOrigCompName());
                    if (orig == null) {
                        this.logger.log("Sub-component" + service.getOrigCompName() + " not found ", service, "PROMOTION ERROR", service.getLine(), service.getColumn(), this.getFilePath());
                    } else {
                        service.setOriginalservice(orig.getService(service.getOrigServName()));
                        if (service.getOriginalservice() == null) {
                            this.logger.log("service " + service.getOrigServName() + " not found in " + service.getOrigCompName() + ":" + orig.getName(), service, "PROMOTION ERROR", service.getLine(), service.getColumn(), this.getFilePath());
                        }
                    }
                }
            }
            service.checkService();
        }
    }

    public ComponentInterface getInterface() {
        return this.componentInterface;
    }

    public void setInterface(ComponentInterface componentInterface) {
        this.componentInterface = componentInterface;
    }

    public HashMap<String, KmlAssignmentExpression> getInitialization() {
        if (this.initializationsClause == null) {
            return null;
        }
        return this.initializationsClause.getInitializations();
    }

    public void setInitialization(HashMap<String, KmlAssignmentExpression> initialization) {
        this.initializationsClause.setInitializations(initialization);
    }

    public HashMap<String, KmlPredicate> getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap<String, KmlPredicate> properties) {
        this.properties = properties;
    }

    public boolean isComposite() {
        return this.composition != null;
    }

    public String toString(boolean showComment, boolean showInterface, boolean showTypes, boolean showConstants, boolean showVariables, boolean showProperties, boolean showServProperties, boolean showInitialization, boolean showServices, boolean showComposition) {
        String s = "COMPONENT " + this.getName() + "\n";
        if (showComment) {
            s = String.valueOf(s) + "#" + this.comment + "\n";
        }
        if (showInterface) {
            s = String.valueOf(s) + this.getInterface().toString();
        }
        if (showTypes && this.typeSpace != null) {
            s = String.valueOf(s) + Spec.listToString(this.typeSpace.getTypeMap().values(), "\nTYPES\n", ";\n  ", "\n");
        }
        if (showConstants && this.getConstants() != null) {
            s = String.valueOf(s) + Spec.listToString(this.constantsClause.getConstants().values(), "CONSTANTS\n  ", ";\n  ", "\n");
        }
        if (showVariables && this.getVariables() != null) {
            s = String.valueOf(s) + Spec.listToString(this.variablesClause.getVariables().values(), "VARIABLES\n  ", ";\n  ", "\n");
        }
        if (this.getInvariant() != null) {
            s = String.valueOf(s) + Spec.mapToString(this.invariantClause.getInvariant(), "OBSERVABLE INVARIANT\n  ", ": ", ";\n  ", "\n");
        }
        if (showProperties && this.properties != null) {
            s = String.valueOf(s) + Spec.mapToString(this.properties, "PROPERTIES\n  ", ": ", ";\n  ", "\n");
        }
        if (showServProperties && this.serviceProperties != null) {
            s = String.valueOf(s) + Spec.mapToString(this.serviceProperties, "SERVICE_PROPERTIES\n  ", ": ", ",\n  ", "\n");
        }
        if (showInitialization && this.initializationsClause.getInitializations() != null) {
            s = String.valueOf(s) + Spec.listToString(this.initializationsClause.getInitializations().values(), "INITIALIZATION\n  ", ";\n  ", "\n");
        }
        if (showServices) {
            s = this.services != null ? String.valueOf(s) + Spec.listToString(this.services.values(), "SERVICES\n", "\n", "END_SERVICES") : String.valueOf(s) + "SERVICES\n   # no declared services at this level \n END_SERVICES";
        }
        if (showComposition && this.composition != null) {
            s = String.valueOf(s) + "\n" + this.composition.toString();
        }
        s = String.valueOf(s) + "\n #END of " + this.getName() + "\n";
        return s;
    }

    public String toString() {
        return this.toString(true, true, true, true, true, true, true, true, true, true);
    }

    public HashMap<String, Variable> getConstants() {
        if (this.constantsClause == null) {
            return null;
        }
        return this.constantsClause.getConstants();
    }

    @Override
    public Variable lookupVariable(String name) {
        String n = "";
        int index = name.indexOf(".");
        n = index > 0 ? name.substring(0, index) : name;
        Variable temp = null;
        if (this.getVariables() != null) {
            temp = this.variablesClause.getVariables().get(n);
        }
        if (temp == null && this.getConstants() != null && this.constantsClause.getConstants() != null) {
            temp = this.constantsClause.getConstants().get(n);
        }
        if (temp == null && this.enumconstants != null) {
            temp = this.enumconstants.get(n);
        }
        if (temp != null && index > 0) {
            temp = temp.resolve(name.substring(index + 1));
        }
        if (temp != null) {
            return temp;
        }
        for (CostoLibrary lib : this.libraries) {
            temp = lib.lookupVariable(name);
            if (temp == null) continue;
            return temp;
        }
        return temp;
    }

    public void flattenAllLTS() {
        for (Service element2 : this.getServices()) {
            Service element = element2;
            LTS behavior = element.getBehavior();
            if (behavior == null) continue;
            behavior.flatten("_CALLER");
        }
    }

    public void flattenAllLTS(String channame) {
        for (Service element2 : this.getServices()) {
            Service element = element2;
            LTS behavior = element.getBehavior();
            if (behavior == null) continue;
            behavior.flatten(channame);
        }
    }

    public ComponentInstance makeInstance() {
        return this.makeInstance(this.name);
    }

    @Deprecated
    public ComponentInstance makeInstance(String name) {
        if (name.equals(this.name)) {
            name = String.valueOf(name) + this.nbInstance;
        }
        ++this.nbInstance;
        ComponentInstance ci = new ComponentInstance(this, name);
        this.instances.add(ci);
        return ci;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public AST getAst() {
        return this.Ast;
    }

    public void setAst(AST ast) {
        this.Ast = ast;
    }

    public ArrayList<CostoLibrary> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(ArrayList<CostoLibrary> libraries) {
        this.libraries = libraries;
    }

    public HashMap<String, CostoType> getTypes() {
        return this.typeSpace.getTypeMap();
    }

    @Deprecated
    public void setTypes(HashMap<String, CostoType> types) {
        this.typeSpace.setTypeMap(types);
    }

    public CostoTypeSpace getTypeSpace() {
        return this.typeSpace;
    }

    public void setTypeSpace(CostoTypeSpace typeSpace) {
        this.typeSpace = typeSpace;
    }

    public HashMap<String, String> getServiceProperties() {
        return this.serviceProperties;
    }

    public void setServiceProperties(HashMap<String, String> serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public HashMap<String, KmlPredicate> getObsInvariant() {
        return this.invariantClause.getInvariant();
    }

    public void setObsInvariant(HashMap<String, KmlPredicate> obsInvariant) {
        this.invariantClause.setInvariant(obsInvariant);
    }

    public HashMap<String, Variable> getVariables() {
        if (this.variablesClause == null) {
            return null;
        }
        return this.variablesClause.getVariables();
    }

    public void setVariables(HashMap<String, Variable> variables) {
        this.variablesClause.setVariables(variables);
        for (Variable var : variables.values()) {
            var.setDeclarationContext(this);
        }
    }

    public HashMap<String, KmlPredicate> getInvariant() {
        if (this.invariantClause == null) {
            return null;
        }
        return this.invariantClause.getInvariant();
    }

    public void setInvariant(HashMap<String, KmlPredicate> invariant) {
        this.invariantClause.setInvariant(invariant);
    }

    public void setConstants(HashMap<String, Variable> constants) {
        this.constantsClause.setConstants(constants);
        for (Variable var : constants.values()) {
            var.setDeclarationContext(this);
        }
    }

    @Override
    @VerificationCode
    public KmlSignature resolveFunction(String functionName, ArrayList<CostoType> operandsTypes, KmlExpression source) {
        KmlSignature temp = null;
        for (CostoLibrary lib : this.libraries) {
            temp = lib.resolveFunction(functionName, operandsTypes, source);
            if (temp == null) continue;
            return temp;
        }
        this.getLogger().log("Could not resolve " + functionName + Spec.listToString(operandsTypes, "(", ";", ")"), source, "RESOLUTION ERROR", source.getLine(), source.getColumn(), this.getFilePath());
        temp = new KmlSignature(CostoUnknownType.instance, functionName);
        return temp;
    }

    @Override
    public CostoType resolveType(String name) {
        CostoType temp = this.typeSpace.get(name);
        if (temp != null) {
            return temp;
        }
        for (CostoLibrary lib : this.libraries) {
            if (lib == null) {
                System.err.println("null lib found in " + this.getName());
                break;
            }
            temp = lib.resolveType(name);
            if (temp == null) continue;
            return temp;
        }
        return temp;
    }

    @Override
    public KmlSignature resolveCommunication(KmlCommunication comm) {
        System.err.println("component " + this.name + " cannot resolve communication" + comm.getRawValue());
        return null;
    }

    public void addLibrary(CostoLibrary e) {
        if (this.libraries == null) {
            this.libraries = new ArrayList();
        }
        this.libraries.add(e);
    }

    @Override
    public void addFunction(KmlSignature sig) {
        if (this.functions == null) {
            this.functions = new ArrayList();
        }
        this.functions.add(sig);
        sig.setDeclarSite(this.filepath);
    }

    @Override
    public Set<KmlSignature> getAllFunctions() {
        HashSet<KmlSignature> sigs = new HashSet<KmlSignature>();
        if (this.functions != null) {
            sigs.addAll(this.functions);
        }
        for (CostoLibrary lib : this.libraries) {
            sigs.addAll(lib.getAllFunctions());
        }
        return sigs;
    }

    @Override
    public void accept(KmlElementVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.visit(this.componentInterface);
            for (CostoLibrary costoLibrary : this.libraries) {
                costoLibrary.accept(visitor);
            }
            if (this.typeSpace != null) {
                for (CostoType costoType : this.typeSpace.getTypeMap().values()) {
                    visitor.visit(costoType);
                }
            }
            for (Service service : this.services.values()) {
                service.accept(visitor);
            }
            if (this.getVariables() != null) {
                for (Variable variable : this.variablesClause.getVariables().values()) {
                    visitor.visitVariable(variable);
                }
            }
            if (this.getConstants() != null) {
                for (Variable variable : this.constantsClause.getConstants().values()) {
                    visitor.visitConstant(variable);
                }
            }
            if (this.getInitialization() != null) {
                for (KmlAssignmentExpression kmlAssignmentExpression : this.initializationsClause.getInitializations().values()) {
                    visitor.visitInitialization(kmlAssignmentExpression);
                }
            }
            if (this.properties != null) {
                for (KmlPredicate kmlPredicate : this.properties.values()) {
                    visitor.visitProperty(kmlPredicate);
                }
            }
            if (this.invariantClause.getInvariant() != null) {
                for (KmlPredicate kmlPredicate : this.invariantClause.getInvariant().values()) {
                    visitor.visitInvariant(kmlPredicate);
                }
            }
            if (this.functions != null) {
                for (KmlSignature kmlSignature : this.functions) {
                    visitor.visitFunction(kmlSignature);
                }
            }
            if (this.composition != null) {
                this.composition.accept(visitor);
            }
        }
    }

    public Component getObs() {
        Component comp = new Component(this.getName());
        HashMap<String, Variable> vars = new HashMap<String, Variable>();
        HashMap<String, Variable> csts = new HashMap<String, Variable>();
        HashMap<String, KmlPredicate> inv = new HashMap<String, KmlPredicate>();
        HashMap<String, KmlAssignmentExpression> init = new HashMap<String, KmlAssignmentExpression>();
        if (this.getVariables() != null) {
            for (Variable variable : this.variablesClause.getVariables().values()) {
                if (variable == null || !variable.isObservable()) continue;
                vars.put(variable.getName(), variable);
            }
        }
        comp.setVariables(vars);
        if (this.getConstants() != null) {
            for (Variable variable : this.constantsClause.getConstants().values()) {
                if (variable == null || !variable.isObservable()) continue;
                csts.put(variable.getName(), variable);
            }
        }
        comp.setConstants(csts);
        if (this.getInvariant() != null) {
            for (KmlPredicate kmlPredicate : this.invariantClause.getInvariant().values()) {
                if (!kmlPredicate.isLocal()) continue;
                inv.put(kmlPredicate.getName(), kmlPredicate);
            }
        }
        comp.setInvariant(inv);
        if (this.getInitialization() != null) {
            for (Map.Entry entry : this.initializationsClause.getInitializations().entrySet()) {
                Variable var = this.lookupVariable((String)entry.getKey());
                if (var == null || !var.isObservable()) continue;
                init.put(var.getName(), (KmlAssignmentExpression)entry.getValue());
            }
        }
        comp.setInitialization(init);
        if (this.services != null) {
            for (Service service : this.services.values()) {
                if (service == null) continue;
                comp.addService(service.getObs());
            }
        }
        return comp;
    }

    @Override
    public KmlLogger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(KmlLogger logger) {
        this.logger = logger;
    }

    public KmlElement getElementFromLine(int line) {
        return null;
    }

    public Service getServiceFromLine(int line) {
        for (Service serv : this.services.values()) {
            if (!serv.lineInElement(line)) continue;
            return serv;
        }
        return null;
    }

    public ConstantsClause getConstantsClause() {
        return this.constantsClause;
    }

    public void setConstantsClause(ConstantsClause constantsClause) {
        this.constantsClause = constantsClause;
        for (Variable var : this.getConstants().values()) {
            var.setDeclarationContext(this);
        }
    }

    public VariablesClause getVariablesClause() {
        return this.variablesClause;
    }

    public void setVariablesClause(VariablesClause variablesClause) {
        this.variablesClause = variablesClause;
        for (Variable var : variablesClause.getVariables().values()) {
            var.setDeclarationContext(this);
        }
    }

    public InitializationsClause getInitializationsClause() {
        return this.initializationsClause;
    }

    public void setInitializationsClause(InitializationsClause initializationsClause) {
        this.initializationsClause = initializationsClause;
    }

    public InvariantClause getInvariantClause() {
        return this.invariantClause;
    }

    public void setInvariantClause(InvariantClause invariantClause) {
        this.invariantClause = invariantClause;
    }

    public ArrayList<KmlStructuralElement> getStructuralElements() {
        ArrayList<KmlStructuralElement> elems = new ArrayList<KmlStructuralElement>();
        if (this.componentInterface != null) {
            elems.add(this.componentInterface);
        }
        if (this.typeSpace != null) {
            elems.add(this.typeSpace);
        }
        if (this.constantsClause != null) {
            elems.add(this.constantsClause);
        }
        if (this.variablesClause != null) {
            elems.add(this.variablesClause);
        }
        if (this.initializationsClause != null) {
            elems.add(this.initializationsClause);
        }
        if (this.invariantClause != null) {
            elems.add(this.invariantClause);
        }
        if (this.services != null) {
            elems.addAll(this.services.values());
        }
        if (this.composition != null) {
            elems.add(this.composition);
        }
        return elems;
    }

    public Collection<? extends KmlSignature> getFunctions() {
        return this.functions;
    }

    public boolean isAppli() {
        return this.appli;
    }

    public void setAppli(boolean appli) {
        this.appli = appli;
    }

    public boolean isAppliTest() {
        return this.appliTest;
    }

    public void setAppliTest(boolean appliTest) {
        this.appliTest = appliTest;
    }

    public Component shallowCopy(String newname) {
        String name = newname;
        String fp = this.getFilePath().replaceFirst(String.valueOf(this.getName()) + ".kcp", String.valueOf(name) + ".kcp");
        Component copy = new Component(name);
        copy.setFilePath(fp);
        copy.services = (HashMap)this.getServicesMap().clone();
        copy.appli = this.appli;
        copy.appliTest = this.appliTest;
        copy.comment = new String(this.comment);
        copy.typeSpace = this.typeSpace;
        copy.libraries = this.libraries != null ? (ArrayList)this.libraries.clone() : null;
        copy.componentInterface = this.componentInterface.shallowCopy();
        copy.constantsClause = this.constantsClause;
        copy.enumconstants = this.enumconstants;
        copy.initializationsClause = this.initializationsClause;
        copy.properties = this.properties != null ? (HashMap)this.properties.clone() : null;
        copy.invariantClause = this.invariantClause;
        copy.functions = this.functions != null ? (ArrayList)this.functions.clone() : null;
        copy.status = this.status;
        copy.setVariables((HashMap)this.getVariables().clone());
        copy.functions = this.functions != null ? (ArrayList)this.functions.clone() : null;
        copy.factory = this.factory;
        copy.logger = this.logger;
        copy.composition = this.composition.shallowCopy();
        copy.composition.setOwner(this);
        return copy;
    }

    public ArrayList<Service> dependencies(Service serv) {
        if (serv.isRequired()) {
            return null;
        }
        ArrayList<Object> reqs = new ArrayList();
        Component provOrigin = serv.getOwner();
        reqs = provOrigin == this ? (serv.isPromoted() ? serv.getOriginalservice().getOwner().dependencies(serv.getOriginalservice()) : serv.getRequired()) : serv.getOwner().dependencies(serv);
        ArrayList<Service> deps = new ArrayList<Service>();
        for (Service service : reqs) {
            Service sbound = null;
            if (service.isProvided()) {
                sbound = service;
            } else if (this.isComposite()) {
                for (Link l : this.composition.getAssembly().getLinks().values()) {
                    if (l.getRequired().getServ() != service) continue;
                    sbound = l.getProvided().getServ();
                }
            }
            if (sbound != null) {
                deps.addAll(this.dependencies(sbound));
                continue;
            }
            deps.add(this.availableReq(service));
        }
        return deps;
    }

    private String listServNames(ArrayList<Service> reqs) {
        if (reqs == null || reqs.isEmpty()) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        for (Service serv : reqs) {
            s.append(serv.getFullName());
        }
        return s.toString();
    }

    public Service availableReq(Service s) {
        if (s.getName().startsWith("UNAVAILABLE")) {
            return s;
        }
        Service avail = s;
        for (Service reqserv : this.getServicesMeetingCriterion(0)) {
            if (reqserv == s) {
                return reqserv;
            }
            if (!reqserv.isPromoted() || reqserv.getOriginalservice() != s) continue;
            return reqserv;
        }
        avail = new Service("UNAVAILABLE" + s.getName(), false);
        avail.setOwner(s.getOwner());
        avail.setOriginalservice(s);
        return avail;
    }

    public boolean isIntention() {
        return this.intention;
    }

    public void setIntention(boolean intention) {
        this.intention = intention;
    }
}

