/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import antlr.ASTFactory;
import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import costo.checks.errorLogger.KmlLogger;
import costo.grammar.AnalyserLex;
import costo.grammar.AnalyserSyn;
import costo.grammar.CommonASTWithLines;
import costo.graph.Assembly;
import costo.graph.Component;
import costo.graph.CostoLibrary;
import costo.graph.KmlContext;
import costo.graph.Variable;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlSignature;
import costo.graph.types.AnyType;
import costo.graph.types.CostoBoolean;
import costo.graph.types.CostoInteger;
import costo.graph.types.CostoString;
import costo.graph.types.CostoType;
import costo.graph.types.CostoUnknownType;
import costo.graph.visitors.KmlElementVisitor;
import costo.graph.visitors.VariableUsageComponentVisitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public class ComponentFactory
implements KmlContext {
    private CostoLibrary startingLibrary;
    private String libraryPath = String.valueOf(System.getProperty("user.dir")) + File.separator + "KmlLibs" + File.separator;
    private boolean debug = false;
    protected HashMap<String, Component> componentTypes;
    protected String name;
    private String absSpecDir = "";
    private LinkedHashSet<String> compPaths = new LinkedHashSet();
    private KmlLogger logger;
    private String currentFile = "";
    private String oldfile;
    private ArrayList<String> preLoad = new ArrayList();
    private ArrayList<KmlElementVisitor> visitors = new ArrayList();

    public ComponentFactory() {
        this.visitors.add(new VariableUsageComponentVisitor(this));
    }

    public void init() {
        this.componentTypes = new HashMap();
        this.logger = new KmlLogger(this);
    }

    public void loadDefaultLibrary(String libpath) {
        this.setLibraryPath(libpath);
        this.loadCostolib();
    }

    public void loadCostolib() {
        if (this.startingLibrary == null) {
            this.startingLibrary = new CostoLibrary("DEFAULT", this);
        }
        ArrayList<CostoType> twobools = new ArrayList<CostoType>();
        twobools.add(CostoBoolean.instance);
        twobools.add(CostoBoolean.instance);
        ArrayList<CostoType> twostrings = new ArrayList<CostoType>();
        twostrings.add(CostoString.instance);
        twostrings.add(CostoString.instance);
        ArrayList<CostoType> stringint = new ArrayList<CostoType>();
        stringint.add(CostoString.instance);
        stringint.add(CostoInteger.instance);
        ArrayList<CostoType> twoints = new ArrayList<CostoType>();
        twoints.add(CostoInteger.instance);
        twoints.add(CostoInteger.instance);
        ArrayList<CostoType> twoany = new ArrayList<CostoType>();
        twoany.add(AnyType.instance);
        twoany.add(AnyType.instance);
        ArrayList<CostoType> onebool = new ArrayList<CostoType>();
        onebool.add(CostoBoolean.instance);
        ArrayList<CostoType> oneint = new ArrayList<CostoType>();
        oneint.add(CostoInteger.instance);
        this.startingLibrary.addFunction(new KmlSignature("+", twoints, CostoInteger.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("+", twostrings, CostoString.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("+", stringint, CostoString.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("-", twoints, CostoInteger.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("-", oneint, CostoInteger.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("/", twoints, CostoInteger.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("div", twoints, CostoInteger.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("*", twoints, CostoInteger.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("&&", twobools, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("||", twobools, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("or", twobools, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("xor", twobools, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("and", twobools, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("implies", twobools, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("equiv", twobools, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("not", onebool, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("!", onebool, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("~", onebool, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("<", twoany, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("<>", twoany, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("!=", twoany, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("=", twoany, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature(">", twoany, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature("<=", twoany, CostoBoolean.instance, true));
        this.startingLibrary.addFunction(new KmlSignature(">=", twoany, CostoBoolean.instance, true));
        for (KmlSignature sig : this.startingLibrary.getFunctions()) {
            if (!sig.getName().startsWith("KW")) continue;
            sig.setName(sig.getName().substring(2));
        }
        this.startingLibrary.check();
    }

    public ComponentFactory(String name, String specdir) {
        this();
        this.init();
        this.name = name;
        this.absSpecDir = specdir;
        this.compPaths.add(specdir);
    }

    protected void loadProperties() {
    }

    public CostoLibrary getDefaultLibrary() {
        return this.startingLibrary;
    }

    public File findFile(String name) {
        File f = new File(name);
        if (f.exists()) {
            this.compPaths.add(f.getParent());
            return f;
        }
        for (String path : this.compPaths) {
            f = new File(String.valueOf(path) + File.separator + name);
            if (!f.exists()) continue;
            return f;
        }
        return f;
    }

    public KmlExpression loadExpression(String str) throws Exception {
        AnalyserLex lexer = new AnalyserLex(new StringReader(str));
        AnalyserSyn parser = new AnalyserSyn((TokenStream)lexer, this);
        try {
            return parser.expression();
        }
        catch (RecognitionException e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        catch (TokenStreamException e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    public ArrayList<Variable> loadVarDecls(String str) throws Exception {
        AnalyserLex lexer = new AnalyserLex(new StringReader(str));
        AnalyserSyn parser = new AnalyserSyn((TokenStream)lexer, this);
        Component nop = new Component("nop");
        nop.addLibrary(this.startingLibrary);
        System.out.println(this.startingLibrary);
        parser.setComponentFactory(this);
        parser.setCurrentComponent(nop);
        try {
            return parser.decl_variables();
        }
        catch (RecognitionException e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        catch (TokenStreamException e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    protected Component load(String compname) {
        Component result = null;
        String newcompname = compname;
        try {
            File file;
            if (!compname.endsWith(".cmp") && !compname.endsWith(".kcp")) {
                newcompname = String.valueOf(newcompname) + ".kcp";
            }
            if ((file = this.findFile(newcompname)) == null) {
                file = this.findFile(String.valueOf(compname) + ".kcp");
            }
            FileReader filer = new FileReader(file);
            this.currentFilePush(file.getAbsolutePath());
            AnalyserLex lexer = new AnalyserLex(filer);
            this.analyselexer(lexer);
            AnalyserSyn parser = new AnalyserSyn((TokenStream)lexer, this);
            ASTFactory factory = new ASTFactory();
            factory.setASTNodeClass(CommonASTWithLines.class);
            parser.setASTFactory(factory);
            System.setProperty("costo.absspecdir", this.absSpecDir);
            result = parser.component();
            result.setAst(parser.getAST());
            result.setLogger(this.logger);
            result.setFactory(this);
            this.componentTypes.get(result.getName());
            this.componentTypes.put(result.getName(), result);
        }
        catch (NullPointerException np) {
            np.printStackTrace();
            System.out.println("TESTNULL" + compname + np);
        }
        catch (RecognitionException e) {
            this.logger.log(e.getMessage(), this, "FATAL PARSING ERROR", e.getLine(), e.getColumn(), this.currentFile);
        }
        catch (TokenStreamRecognitionException tse) {
            this.logger.log(tse.getMessage(), this, "FATAL PARSING ERROR", tse.recog.getLine(), tse.recog.getColumn(), this.currentFile);
        }
        catch (Exception exception) {}
        this.currentFilePop();
        return result;
    }

    private void currentFilePop() {
        if (this.oldfile != null && this.oldfile.length() > 0) {
            this.currentFile = this.oldfile;
        }
    }

    private void currentFilePush(String absolutePath) {
        this.oldfile = this.currentFile;
        this.currentFile = absolutePath;
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(String currentFile) {
        this.currentFile = currentFile;
    }

    private void analyselexer(AnalyserLex lexer) {
    }

    public Component loadComponent(InputStream in) {
        Component result = null;
        try {
            AnalyserLex lexer = new AnalyserLex(in);
            AnalyserSyn parser = new AnalyserSyn((TokenStream)lexer, this);
            this.analyselexer(lexer);
            System.setProperty("costo.absspecdir", this.absSpecDir);
            result = parser.component();
            result.setAst(parser.getAST());
            result.setFilePath(lexer.getFilename());
            this.componentTypes.put(result.getName(), result);
            result.setFactory(this);
        }
        catch (NullPointerException np) {
            np.printStackTrace();
        }
        catch (RecognitionException e) {
            this.logger.log(e.getMessage(), this, "FATAL PARSING ERROR", e.getLine(), e.getColumn(), this.currentFile);
        }
        catch (TokenStreamRecognitionException tse) {
            this.logger.log(tse.getMessage(), this, "FATAL PARSING ERROR", tse.recog.getLine(), tse.recog.getColumn(), this.currentFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Component loadComponent(Reader in) {
        Component result = null;
        try {
            AnalyserLex lexer = new AnalyserLex(in);
            AnalyserSyn parser = new AnalyserSyn((TokenStream)lexer, this);
            this.analyselexer(lexer);
            System.setProperty("costo.absspecdir", this.absSpecDir);
            result = parser.component();
            result.setAst(parser.getAST());
            this.componentTypes.put(result.getName(), result);
            result.setFactory(this);
        }
        catch (NullPointerException np) {
            np.printStackTrace();
        }
        catch (RecognitionException e) {
            this.logger.log(e.getMessage(), this, "FATAL PARSING ERROR", e.getLine(), e.getColumn(), this.currentFile);
        }
        catch (TokenStreamRecognitionException tse) {
            this.logger.log(tse.getMessage(), this, "FATAL PARSING ERROR", tse.recog.getLine(), tse.recog.getColumn(), this.currentFile);
        }
        catch (Throwable throwable) {}
        return result;
    }

    public Component getComponent(String compname) {
        if (this.preLoad.contains(compname)) {
            System.err.println(" loop on compname " + this.currentFile);
            return null;
        }
        this.preLoad.add(compname);
        Component result = this.componentTypes.get(compname);
        if (result == null) {
            try {
                result = this.load(compname);
            }
            catch (Exception e) {
                System.err.println("-----------Error Loading component " + compname);
                e.printStackTrace();
                System.out.println(e.getStackTrace());
            }
        }
        this.preLoad.remove(compname);
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAbsSpecDir() {
        return this.absSpecDir;
    }

    public void setAbsSpecDir(String absSpecDir) {
        this.absSpecDir = absSpecDir;
        this.compPaths.add(absSpecDir);
    }

    public static void main(String[] args) {
        String propertyFile = "Costolib.userprefs";
        String propspecdir = "costo.specdir";
        String propbasedir = "costo.basedir";
        String propcompname = "costo.basecomp";
        Properties userprop = new Properties();
        try {
            userprop.load(new FileInputStream(propertyFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String specdir = userprop.getProperty(propspecdir);
        String absSpecDir = String.valueOf(userprop.getProperty(propbasedir, String.valueOf(System.getProperty("user.dir")) + File.separator)) + specdir;
        String compname = userprop.getProperty(propcompname);
        ComponentFactory cf = new ComponentFactory("mafactory", absSpecDir);
        Component test = cf.getComponent(compname);
        System.out.println(test.toString());
        test.flattenAllLTS();
        System.out.println("#############################################");
        System.err.println("#############################################");
        System.out.println("#############################################");
        System.out.println(test.toString());
        System.out.println(cf.componentTypes.keySet());
        System.out.println(test.makeInstance());
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public void setLibraryPath(String libraryPath) {
        this.libraryPath = libraryPath;
        this.compPaths.add(libraryPath);
    }

    @Override
    public KmlLogger getLogger() {
        return this.logger;
    }

    public void close() {
    }

    public void setStartingLibrary(CostoLibrary startingLibrary) {
        this.startingLibrary = startingLibrary;
    }

    public Assembly loadAssembly(String typeName) {
        return null;
    }

    @Override
    public void setLogger(KmlLogger log) {
        this.logger = log;
    }

    public ArrayList<KmlElementVisitor> getVisitors() {
        return this.visitors;
    }

    public void setVisitors(ArrayList<KmlElementVisitor> visitors) {
        this.visitors = visitors;
    }

    @Override
    public void addFunction(KmlSignature sig) {
    }

    @Override
    public String getFilePath() {
        return null;
    }

    @Override
    public Variable lookupVariable(String n) {
        return null;
    }

    @Override
    public KmlSignature resolveCommunication(KmlCommunication comm) {
        return null;
    }

    @Override
    public KmlSignature resolveFunction(String functionName, ArrayList<CostoType> operandsTypes, KmlExpression source) {
        return null;
    }

    @Override
    public CostoType resolveType(String name) {
        return CostoUnknownType.instance;
    }

    @Override
    public void setFilePath(String fp) {
    }

    @Override
    public Set<KmlSignature> getAllFunctions() {
        return null;
    }
}

