/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.Assembly;
import costo.graph.Component;
import costo.graph.ComponentFactory;
import costo.graph.InitializationsClause;
import costo.graph.VariableData;

public class ComponentVariable
extends VariableData {
    private String tag = "";
    private Component componentType;
    private InitializationsClause initialization;
    Assembly context;

    public ComponentVariable(String varName, String typeName, int line, int column) {
        super(varName, typeName, line, column);
    }

    public ComponentVariable(String varName, Component ctype) {
        super(varName, ctype.getName(), 0, 0);
        this.componentType = ctype;
    }

    @Override
    public void loadType(ComponentFactory cf) {
        try {
            this.componentType = cf.getComponent(this.getTypeName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean bl = this.isLoaded = this.componentType != null;
        if (this.isLoaded && this.initialization != null) {
            this.initialization.resolve(this.componentType, cf.getLogger(), cf.getCurrentFile());
        }
        if (!this.isLoaded) {
            cf.getLogger().log("Component " + this.getTypeName() + " not found ", this, "LOADING ERROR", this.getLine(), this.getColumn(), cf.getCurrentFile());
        }
    }

    public Component getComponentType() {
        return this.componentType;
    }

    public void setComponentType(Component componentType) {
        this.componentType = componentType;
        this.isLoaded = true;
    }

    public InitializationsClause getInitialization() {
        return this.initialization;
    }

    public void setInitialization(InitializationsClause initialization) {
        this.initialization = initialization;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Assembly getContext() {
        return this.context;
    }

    public void setContext(Assembly context) {
        this.context = context;
    }
}

