/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.checks.errorLogger.KmlLogger;
import costo.graph.KmlContext;
import costo.graph.Variable;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlSignature;
import costo.graph.types.CostoType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class CompositeKmlContext
implements KmlContext {
    ArrayList<KmlContext> contexts = new ArrayList();
    String prefix = "";
    KmlContext first = null;
    private KmlLogger logger;
    private String filepath;
    private HashMap<KmlContext, KmlLogger> loggers = new HashMap();
    private HashMap<KmlContext, String> tempFilePaths = new HashMap();

    public CompositeKmlContext(String prefix) {
        this.prefix = prefix;
    }

    public boolean add(KmlContext e) {
        if (e == null) {
            return false;
        }
        if (this.contexts.size() == 0) {
            this.first = e;
        }
        return this.contexts.add(e);
    }

    @Override
    public void addFunction(KmlSignature sig) {
        this.first.addFunction(sig);
    }

    @Override
    public String getFilePath() {
        return this.first.getFilePath();
    }

    @Override
    public String getName() {
        return this.first.getName();
    }

    @Override
    public Variable lookupVariable(String n) {
        Variable candidate = null;
        for (KmlContext each : this.contexts) {
            candidate = each.lookupVariable(n);
            if (candidate == null && n.startsWith(this.prefix)) {
                System.err.println("loooking for " + n.substring(this.prefix.length()));
                candidate = each.lookupVariable(n.substring(this.prefix.length() + 1));
            }
            if (candidate == null) continue;
            return candidate;
        }
        return candidate;
    }

    public void redirectToMyLogger() {
        for (KmlContext context : this.contexts) {
            if (context == null) continue;
            this.loggers.put(context, context.getLogger());
            this.tempFilePaths.put(context, context.getFilePath());
            context.setLogger(this.logger);
            context.setFilePath(this.filepath);
        }
    }

    public void restoreLogger() {
        for (KmlContext context : this.contexts) {
            if (context == null) continue;
            context.setLogger(this.loggers.get(context));
            context.setFilePath(this.tempFilePaths.get(context));
        }
    }

    @Override
    public KmlSignature resolveCommunication(KmlCommunication comm) {
        return this.first.resolveCommunication(comm);
    }

    @Override
    public KmlSignature resolveFunction(String functionName, ArrayList<CostoType> operandsTypes, KmlExpression source) {
        KmlSignature candidate = null;
        for (KmlContext each : this.contexts) {
            candidate = each.resolveFunction(functionName, operandsTypes, source);
            if (candidate == null) continue;
            return candidate;
        }
        return candidate;
    }

    @Override
    public CostoType resolveType(String name) {
        CostoType candidate = null;
        for (KmlContext each : this.contexts) {
            candidate = each.resolveType(name);
            if (candidate == null) continue;
            return candidate;
        }
        return candidate;
    }

    @Override
    public KmlLogger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(KmlLogger logger) {
        this.logger = logger;
    }

    @Override
    public void setFilePath(String fp) {
        this.filepath = fp;
    }

    @Override
    public Set<KmlSignature> getAllFunctions() {
        return this.first.getAllFunctions();
    }
}

