/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.KmlContext;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlIdentifier;
import costo.graph.expressions.Localizable;

public class ContextMapping
implements Localizable {
    private KmlIdentifier virtualVariable;
    private KmlExpression value;

    public ContextMapping(KmlIdentifier virtualVariable, KmlExpression value) {
        this.virtualVariable = virtualVariable;
        this.value = value;
    }

    public KmlIdentifier getVirtualVariable() {
        return this.virtualVariable;
    }

    public String toString() {
        return String.valueOf(this.virtualVariable.getRawValue()) + " = " + this.value.getRawValue();
    }

    public void setVirtualVariable(KmlIdentifier virtualVariable) {
        this.virtualVariable = virtualVariable;
    }

    public KmlExpression getValue() {
        return this.value;
    }

    public void setValue(KmlExpression value) {
        this.value = value;
    }

    public boolean resolveType(KmlContext context) {
        this.virtualVariable.resolveType(context);
        this.value.resolveType(context);
        if (!this.value.getType().conformsTo(this.virtualVariable.getType())) {
            context.getLogger().log("value type does not conform to virtual variable " + this.virtualVariable.getRawValue(), context, "TYPE ERROR", this.value.getLine(), this.value.getColumn(), "");
        }
        return true;
    }

    @Override
    public int getColumn() {
        return this.virtualVariable.getColumn();
    }

    @Override
    public int getLine() {
        return this.virtualVariable.getLine();
    }

    @Override
    public String getPositionAsText() {
        return this.virtualVariable.getPositionAsText();
    }

    @Override
    public void setColumn(int column) {
    }

    @Override
    public void setLine(int line) {
    }
}

