/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamRecognitionException;
import costo.checks.errorLogger.KmlLogger;
import costo.grammar.AnalyserLex;
import costo.grammar.AnalyserSyn;
import costo.graph.Component;
import costo.graph.ComponentFactory;
import costo.graph.KmlContext;
import costo.graph.Spec;
import costo.graph.Variable;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlSignature;
import costo.graph.expressions.KmlTypedStuff;
import costo.graph.types.CostoEnum;
import costo.graph.types.CostoType;
import costo.graph.types.SameType;
import costo.graph.visitors.KmlElementVisitor;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CostoLibrary
implements KmlContext {
    private String filePath;
    private KmlContext parentContext;
    private String name;
    private KmlLogger logger;
    private String basepath;
    private ArrayList<KmlSignature> functions = new ArrayList();
    private HashMap<String, Variable> constants = new HashMap();
    private HashMap<String, Variable> enumconstants = new HashMap();
    private HashMap<String, CostoType> types = new HashMap();

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public void addFunction(KmlSignature sig) {
        if (this.functions == null) {
            this.functions = new ArrayList();
        }
        this.functions.add(sig);
    }

    public CostoLibrary() {
        this.name = "anonymousContext" + Spec.getIndex();
    }

    public CostoLibrary(ComponentFactory comp, String name, InputStream typesStream, InputStream functionsStream, InputStream constantStream) {
        AnalyserSyn parser;
        AnalyserLex lexer;
        String constantsfile;
        String functionsfile;
        this.name = name;
        String compfactorycurrentfile = comp.getCurrentFile();
        Component dummy = new Component("not");
        dummy.setLogger(comp.getLogger());
        if (comp.getDefaultLibrary() == null) {
            dummy.addLibrary(this);
        } else {
            dummy.addLibrary(comp.getDefaultLibrary());
        }
        this.logger = comp.getLogger();
        comp.setCurrentFile(name);
        String thebasepath = "";
        String typesfile = "types.txt";
        File ft = new File(thebasepath, "types.txt");
        if (!ft.exists()) {
            typesfile = "types.klt";
        }
        if (!(ft = new File(thebasepath, functionsfile = "functions.txt")).exists()) {
            typesfile = "functions.klf";
        }
        if (!(ft = new File(thebasepath, constantsfile = "constants.txt")).exists()) {
            typesfile = "constants.klc";
        }
        if (typesStream != null) {
            try {
                comp.setCurrentFile(String.valueOf(name) + File.separator + typesfile);
                lexer = new AnalyserLex(typesStream);
                parser = new AnalyserSyn((TokenStream)lexer, comp);
                parser.setCurrentComponent(dummy);
                parser.decl_kml_types();
                this.types = new HashMap();
                this.types.putAll(dummy.getTypes());
            }
            catch (RecognitionException e) {
                this.logger.log(e.getMessage(), this, "FATAL PARSING ERROR", e.getLine(), e.getColumn(), String.valueOf(thebasepath) + typesfile);
            }
            catch (TokenStreamRecognitionException tse) {
                this.logger.log(tse.getMessage(), this, "FATAL PARSING ERROR", tse.recog.getLine(), tse.recog.getColumn(), String.valueOf(thebasepath) + typesfile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (functionsStream != null) {
            try {
                comp.setCurrentFile(String.valueOf(thebasepath) + name + File.separator + functionsfile);
                lexer = new AnalyserLex(functionsStream);
                parser = new AnalyserSyn((TokenStream)lexer, comp);
                parser.setCurrentComponent(dummy);
                parser.decl_kml_functions();
                if (this.functions == null) {
                    this.functions = new ArrayList();
                }
                this.functions.addAll(dummy.getFunctions());
            }
            catch (RecognitionException e) {
                this.logger.log(e.getMessage(), this, "FATAL PARSING ERROR", e.getLine(), e.getColumn(), String.valueOf(thebasepath) + functionsfile);
            }
            catch (TokenStreamRecognitionException tse) {
                this.logger.log(tse.getMessage(), this, "FATAL PARSING ERROR", tse.recog.getLine(), tse.recog.getColumn(), String.valueOf(thebasepath) + functionsfile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (constantStream != null) {
            try {
                comp.setCurrentFile(String.valueOf(thebasepath) + name + File.separator + constantsfile);
                lexer = new AnalyserLex(constantStream);
                parser = new AnalyserSyn((TokenStream)lexer, comp);
                parser.setCurrentComponent(dummy);
                HashMap<String, Variable> cst = parser.lib_constants();
                if (this.constants == null) {
                    this.constants = new HashMap();
                }
                this.constants.putAll(cst);
                for (Variable constant : this.constants.values()) {
                    constant.setObservable(true);
                }
            }
            catch (RecognitionException e) {
                this.logger.log(e.getMessage(), this, "FATAL PARSING ERROR", e.getLine(), e.getColumn(), String.valueOf(thebasepath) + constantsfile);
            }
            catch (TokenStreamRecognitionException tse) {
                this.logger.log(tse.getMessage(), this, "FATAL PARSING ERROR", tse.recog.getLine(), tse.recog.getColumn(), String.valueOf(thebasepath) + constantsfile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.functions == null && this.constants == null && this.types == null) {
            System.err.println("Library " + name + " in " + thebasepath + " is inexistant or empty ");
        }
        comp.setCurrentFile(compfactorycurrentfile);
    }

    public CostoLibrary(String name, ComponentFactory comp) {
        String constantsfile;
        File fc;
        String functionsfile;
        File ff;
        this.name = name;
        String compfactorycurrentfile = comp.getCurrentFile();
        String thebasepath = String.valueOf(System.getProperty("user.dir")) + File.separator + "KmlLib" + File.separator;
        Component dummy = new Component("not");
        dummy.setLogger(comp.getLogger());
        this.parentContext = comp.getDefaultLibrary();
        thebasepath = comp.getLibraryPath();
        comp.setCurrentFile(String.valueOf(thebasepath) + name);
        if (comp.getDefaultLibrary() == null) {
            dummy.addLibrary(this);
        } else {
            dummy.addLibrary(comp.getDefaultLibrary());
        }
        this.logger = comp.getLogger();
        this.basepath = thebasepath = String.valueOf(thebasepath) + name + File.separator;
        File f = new File(thebasepath);
        if (!f.exists() && (f = comp.findFile(name)) != null) {
            thebasepath = String.valueOf(f.getAbsolutePath()) + File.separator;
        }
        dummy.setFilePath(String.valueOf(thebasepath) + name);
        comp.setCurrentFile(String.valueOf(thebasepath) + name);
        this.filePath = String.valueOf(thebasepath) + name;
        String typefile = "types.txt";
        File ft = new File(thebasepath, "types.txt");
        if (!ft.exists()) {
            ft = new File(thebasepath, "types.klt");
            typefile = "types.klt";
        }
        if (ft.exists()) {
            try {
                comp.setCurrentFile(String.valueOf(thebasepath) + name + File.separator + typefile);
                AnalyserSyn parser = this.getParserForFile(String.valueOf(thebasepath) + typefile, comp);
                parser.setCurrentComponent(dummy);
                parser.decl_kml_types();
                this.types = new HashMap();
                this.types.putAll(dummy.getTypes());
            }
            catch (RecognitionException e) {
                this.logger.log(e.getMessage(), this, "FATAL PARSING ERROR", e.getLine(), e.getColumn(), String.valueOf(thebasepath) + typefile);
            }
            catch (IOException iOException) {
            }
            catch (TokenStreamRecognitionException tse) {
                this.logger.log(tse.getMessage(), this, "FATAL PARSING ERROR", tse.recog.getLine(), tse.recog.getColumn(), String.valueOf(thebasepath) + typefile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!(ff = new File(thebasepath, functionsfile = "functions.txt")).exists()) {
            ff = new File(thebasepath, "functions.klf");
            functionsfile = "functions.klf";
        }
        if (ff.exists()) {
            try {
                comp.setCurrentFile(String.valueOf(thebasepath) + File.separator + functionsfile);
                AnalyserSyn parser = this.getParserForFile(String.valueOf(thebasepath) + functionsfile, comp);
                parser.setCurrentComponent(dummy);
                parser.decl_kml_functions();
                if (this.functions == null) {
                    this.functions = new ArrayList();
                }
                if (dummy.getFunctions() != null) {
                    this.functions.addAll(dummy.getFunctions());
                }
            }
            catch (RecognitionException e) {
                this.logger.log(e.getMessage(), this, "FATAL PARSING ERROR", e.getLine(), e.getColumn(), String.valueOf(thebasepath) + functionsfile);
            }
            catch (IOException iOException) {
            }
            catch (TokenStreamRecognitionException tse) {
                this.logger.log(tse.getMessage(), this, "FATAL PARSING ERROR", tse.recog.getLine(), tse.recog.getColumn(), String.valueOf(thebasepath) + functionsfile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!(fc = new File(thebasepath, constantsfile = "constants.txt")).exists()) {
            constantsfile = "constants.klc";
            fc = new File(thebasepath, constantsfile);
        }
        if (fc.exists()) {
            try {
                comp.setCurrentFile(String.valueOf(thebasepath) + name + File.separator + constantsfile);
                AnalyserSyn parser = this.getParserForFile(String.valueOf(thebasepath) + constantsfile, comp);
                parser.setCurrentComponent(dummy);
                HashMap<String, Variable> cst = parser.lib_constants();
                if (this.constants == null) {
                    this.constants = new HashMap();
                }
                this.constants.putAll(cst);
                for (Variable constant : this.constants.values()) {
                    constant.setObservable(true);
                }
            }
            catch (RecognitionException e) {
                this.logger.log(e.getMessage(), this, "FATAL PARSING ERROR", e.getLine(), e.getColumn(), String.valueOf(thebasepath) + constantsfile);
            }
            catch (IOException iOException) {
            }
            catch (TokenStreamRecognitionException tse) {
                this.logger.log(tse.getMessage(), this, "FATAL PARSING ERROR", tse.recog.getLine(), tse.recog.getColumn(), String.valueOf(thebasepath) + constantsfile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.functions == null && this.constants == null && this.types == null) {
            System.err.println("Library " + name + " in " + thebasepath + " is inexistant or empty ");
        }
        comp.setCurrentFile(compfactorycurrentfile);
    }

    private void checkConstants() {
        String old = this.getFilePath();
        this.setFilePath(String.valueOf(old) + File.separator + "constants.klc");
        if (this.constants != null) {
            for (Variable var : this.constants.values()) {
                if (!var.getExpression().resolveType(this)) {
                    this.logger.log("Cannot type " + var, var, "TYPE ERROR", var.getExpression().getLine(), var.getExpression().getColumn(), String.valueOf(this.basepath) + this.name + File.separator + "constants.klc");
                    continue;
                }
                if (KmlTypedStuff.typeCheck(var.getExpression(), var.getCtype())) continue;
                this.getLogger().log(" in " + var + " : " + var.getExpression() + " of type " + var.getExpression().getType() + "cannot be assigned to " + var.getName() + " of type " + var.getType(), var, "TYPE ERROR", var.getExpression().getLine(), var.getExpression().getColumn(), String.valueOf(this.basepath) + this.name + File.separator + "constants.klc");
            }
        }
        this.setFilePath(old);
    }

    private AnalyserSyn getParserForFile(String filepath, ComponentFactory comp) throws IOException {
        FileReader file = new FileReader(filepath);
        AnalyserLex lexer = new AnalyserLex(file);
        AnalyserSyn parser = new AnalyserSyn((TokenStream)lexer, comp);
        return parser;
    }

    @Override
    public Variable lookupVariable(String name) {
        int index;
        String n = name;
        if (n.startsWith(this.name)) {
            n = n.substring(name.length() + 1);
        }
        if ((index = n.indexOf(".")) > 0) {
            n = n.substring(0, index);
        }
        Variable temp = null;
        if (this.constants != null) {
            temp = this.constants.get(n);
        }
        if (temp == null && this.enumconstants != null) {
            temp = this.enumconstants.get(n);
        }
        if (temp != null && index > 0) {
            temp = temp.resolve(name.substring(index + 1));
        }
        if (temp == null && this.parentContext != null) {
            temp = this.parentContext.lookupVariable(name);
        }
        return temp;
    }

    private void checkTypes() {
        String old = this.getFilePath();
        this.setFilePath(String.valueOf(old) + File.separator + "types.klc");
        for (CostoType ctype : this.types.values()) {
            ctype.resolve(this);
            if (!(ctype instanceof CostoEnum)) continue;
            if (this.enumconstants == null) {
                this.enumconstants = new HashMap();
            }
            this.enumconstants.putAll(((CostoEnum)ctype).generateConstants());
        }
        this.setFilePath(old);
    }

    @Override
    public KmlSignature resolveFunction(String functionName, ArrayList<CostoType> operandsTypes, KmlExpression source) {
        KmlSignature temp = null;
        ArrayList<KmlSignature> candidates = new ArrayList<KmlSignature>();
        if (this.functions != null) {
            for (KmlSignature func : this.functions) {
                SameType.instance.resetLastType();
                if (!func.getName().equals(functionName) || !func.canBeCalledWithTypes(operandsTypes)) continue;
                candidates.add(func.getSignatureWithCurrentTypes());
            }
        }
        if (candidates.size() == 1) {
            return (KmlSignature)candidates.get(0);
        }
        if (candidates.size() > 1) {
            this.getLogger().log("the compiler is currently too stupid to choose between the following functions " + Spec.listToString(candidates, "", "\n", "\n") + " selecting the first one.", source, "RESOLUTION WARNING", source.getLine(), source.getColumn(), "");
            return (KmlSignature)candidates.get(0);
        }
        if (temp == null && this.parentContext != null) {
            temp = this.parentContext.resolveFunction(functionName, operandsTypes, source);
        }
        return temp;
    }

    @Override
    public CostoType resolveType(String name) {
        CostoType temp = null;
        if (this.types != null) {
            temp = this.types.get(name);
        }
        if (temp == null && this.parentContext != null) {
            temp = this.parentContext.resolveType(name);
        }
        return temp;
    }

    @Override
    public Set<KmlSignature> getAllFunctions() {
        HashSet<KmlSignature> fset = new HashSet<KmlSignature>(this.functions);
        if (this.parentContext != null) {
            fset.addAll(this.parentContext.getAllFunctions());
        }
        return fset;
    }

    public void setFunctions(ArrayList<KmlSignature> functions) {
        this.functions = functions;
    }

    public HashMap<String, Variable> getConstants() {
        return this.constants;
    }

    public void setConstants(HashMap<String, Variable> constants) {
        this.constants = constants;
    }

    public HashMap<String, CostoType> getTypes() {
        return this.types;
    }

    public void setTypes(HashMap<String, CostoType> types) {
        this.types = types;
    }

    public KmlContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(KmlContext parentContext) {
        this.parentContext = parentContext;
        if (this.logger == null) {
            this.logger = parentContext.getLogger();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public KmlSignature resolveCommunication(KmlCommunication comm) {
        System.err.println("Library " + this.name + " cannot resolve communication" + comm.getRawValue());
        return null;
    }

    public String asText() {
        String s = "";
        s = String.valueOf(s) + Spec.listToString(this.functions, "FUNCTIONS\n", "FUNCTION \n", "\n");
        s = String.valueOf(s) + Spec.listToString(this.types.values(), "TYPES\n", "TYPE\n", "\n");
        return s;
    }

    @Override
    public KmlLogger getLogger() {
        if (this.logger == null && this.parentContext != null) {
            return this.parentContext.getLogger();
        }
        return this.logger;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.name;
    }

    public void addConstant(Variable v) {
        if (this.constants == null) {
            this.constants = new HashMap();
        }
        this.constants.put(v.getName(), v);
    }

    public void check() {
        this.checkTypes();
        this.checkFunctions();
        this.checkConstants();
    }

    private void checkFunctions() {
        String old = this.getFilePath();
        this.setFilePath(String.valueOf(old) + File.separator + "functions.klf");
        for (KmlSignature func : this.functions) {
            func.resolveType(this);
        }
        this.setFilePath(old);
    }

    public void accept(KmlElementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void setLogger(KmlLogger logger) {
        this.logger = logger;
    }

    public ArrayList<KmlSignature> getFunctions() {
        return this.functions;
    }
}

