/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.Graph;
import costo.graph.InterlocutorSet;
import costo.graph.KmlVisitable;
import costo.graph.Label;
import costo.graph.Service;
import costo.graph.ServiceHook;
import costo.graph.ServiceInterface;
import costo.graph.Spec;
import costo.graph.State;
import costo.graph.Transition;
import costo.graph.expressions.KmlAssignmentExpression;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlCompositeExpression;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlNopExpression;
import costo.graph.ltsutils.LTSUtils;
import costo.graph.visitors.KmlElementVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class LTS
extends Graph
implements KmlVisitable {
    private State initialState;
    private ArrayList<State> finalStates;
    private ArrayList<State> terminalStates;
    private Service owner;

    public LTS() {
    }

    public LTS(LTS a) {
        this.owner = a.getOwner();
        this.stateMap = new HashMap();
        for (Object v : a.stateMap.values()) {
            State current = (State)v;
            State copy = new State(current.getName());
            copy.setService((ArrayList)current.getServices().clone());
            this.stateMap.put(copy.getName(), copy);
        }
        this.transitionList = new ArrayList();
        for (Transition transition : a.transitionList) {
            this.transitionList.add(new Transition((State)this.stateMap.get(transition.getSource().getName()), (State)this.stateMap.get(transition.getTarget().getName()), transition.getLabel().twin()));
        }
        for (Transition transition : this.transitionList) {
            transition.getSource().addOutGoingTransition(transition);
            transition.getTarget().addInComingTransition(transition);
        }
        this.initialState = (State)this.stateMap.get(a.initialState.getName());
        this.finalStates = new ArrayList();
        for (State state : a.getFinalStates()) {
            this.finalStates.add((State)this.stateMap.get(state.getName()));
        }
    }

    public ArrayList<String> getMessageTypesOnChannel(String chan, int action_type) {
        ArrayList<String> messages = new ArrayList<String>();
        for (Transition t : this.transitionList) {
            Label l = t.getLabel();
            if (l.getActionType() != action_type || !l.getChannel().equalsIgnoreCase(chan)) continue;
            messages.add(l.getMessage());
        }
        return messages;
    }

    public LTS twin() {
        return new LTS(this);
    }

    public LTS(Service serv) {
        this.owner = serv;
    }

    public State getInitialState() {
        return this.initialState;
    }

    public void setInitialState(State noeudInitial) {
        this.initialState = this.updateAndGetState(noeudInitial);
    }

    public ArrayList<KmlCommunication> getCalledServices(String portname) {
        return this.getFilteredActions(portname, 1);
    }

    public ArrayList<KmlCommunication> getFilteredActions(String portname, int actionType) {
        ArrayList<KmlCommunication> servnamelist = new ArrayList<KmlCommunication>();
        for (Transition current : this.transitionList) {
            Label l = current.getLabel();
            if (!l.getExpression().isCommunication() || !l.getChannel().equals(portname) || l.getActionType() != actionType || servnamelist.contains(l.getMessage())) continue;
            servnamelist.add((KmlCommunication)l.getExpression());
        }
        return servnamelist;
    }

    public String toString() {
        String s = "# LTS of " + this.owner.getFullName() + "\n";
        s = String.valueOf(s) + "Init " + this.initialState.getName() + "\n";
        s = String.valueOf(s) + Spec.listToString(this.finalStates, "Final ", ", ", "\n");
        s = String.valueOf(s) + Spec.listToString(this.terminalStates, "Terminal ", ", ", "\n");
        if (this.stateMap != null) {
            s = String.valueOf(s) + "# LTS states are : ";
            Iterator<State> iter = this.iteratorOnStates();
            while (iter.hasNext()) {
                State aState = iter.next();
                s = String.valueOf(s) + aState.toLongString();
                if (!iter.hasNext()) continue;
                s = String.valueOf(s) + ",";
            }
            s = String.valueOf(s) + "\n";
        }
        s = String.valueOf(s) + "{";
        s = String.valueOf(s) + Spec.listToString(this.getTransitions(), "\n", ",\n  ", "");
        s = String.valueOf(s) + "\n}\n";
        return s;
    }

    public ArrayList<State> getFinalStates() {
        return this.finalStates;
    }

    public void setFinalStates(ArrayList<State> noeudsFinals) {
        this.finalStates = new ArrayList();
        for (State element : noeudsFinals) {
            this.finalStates.add(this.updateAndGetState(element));
        }
    }

    public void setOwner(Service service) {
        this.owner = service;
    }

    public Service getOwner() {
        return this.owner;
    }

    public String getComponentName() {
        if (this.owner == null) {
            return "";
        }
        if (this.owner.getOwner() == null) {
            return "";
        }
        return this.owner.getOwner().getName();
    }

    public String getServiceName() {
        if (this.owner != null) {
            return this.owner.getName();
        }
        return "";
    }

    public void chainIncoming() {
        for (Transition temp : this.transitionList) {
            State target = temp.getTarget();
            target.addInComingTransition(temp);
            State source = temp.getSource();
            source.addOutGoingTransition(temp);
        }
    }

    public void insertLTSAt(LTS lts, State start, State end, String channame, boolean bypass) throws Exception {
        Object bypasscalllts;
        LTSUtils.prefixStates(lts, String.valueOf(start.getName()) + "_" + lts.getOwner().getName() + "_");
        ArrayList<String> commonnames = new ArrayList<String>();
        commonnames.addAll(lts.getStatesMap().keySet());
        commonnames.retainAll(this.stateMap.keySet());
        if (!commonnames.isEmpty()) {
            throw new Exception("Couldn't insert LTS: Name clash " + commonnames);
        }
        this.transitionList.addAll(lts.getTransitions());
        this.stateMap.putAll(lts.getStatesMap());
        if (!bypass) {
            InterlocutorSet inter = new InterlocutorSet();
            inter.setChannel(channame);
            KmlCommunication callexpr = new KmlCommunication(inter, 2, lts.getOwner().getName(), new ArrayList<KmlExpression>());
            Label callserv = new Label(callexpr);
            Transition calllts = new Transition(start, lts.getInitialState(), callserv);
            start.addOutGoingTransition(calllts);
            lts.getInitialState().addInComingTransition(calllts);
            this.transitionList.add(calllts);
        }
        Label nop = new Label(new KmlNopExpression());
        if (bypass) {
            Label bypassT = new Label(nop.twin());
            bypasscalllts = new Transition(start, lts.getInitialState(), bypassT);
            start.addOutGoingTransition((Transition)bypasscalllts);
            lts.getInitialState().addInComingTransition((Transition)bypasscalllts);
            this.transitionList.add(bypasscalllts);
        }
        bypasscalllts = lts.finalStates.iterator();
        while (bypasscalllts.hasNext()) {
            State element;
            State afinal = element = bypasscalllts.next();
            Transition endTrans = new Transition(afinal, end, nop.twin());
            afinal.addOutGoingTransition(endTrans);
            end.addInComingTransition(endTrans);
            this.transitionList.add(endTrans);
        }
        ServiceInterface ownerServIf = this.getOwner().getInterface();
        ServiceInterface subServIf = lts.getOwner().getInterface();
        ownerServIf.addCalrequired(subServIf.getCalrequired());
        ownerServIf.addIntrequired(subServIf.getIntrequired());
        ownerServIf.addExtrequired(subServIf.getExtrequired());
    }

    public void flattenLabels() {
        ArrayList copy = new ArrayList();
        copy.addAll(this.transitionList);
        for (Transition curTrans : copy) {
            State source = curTrans.getSource();
            State target = curTrans.getTarget();
            Label curLab = curTrans.getLabel();
            int labelnumber = 0;
            Transition newt = null;
            KmlExpression expr = curLab.getExpression();
            if (expr.getClass() == KmlAssignmentExpression.class) {
                if (!((KmlAssignmentExpression)expr).isCommunication()) continue;
                State middlestate = new State(String.valueOf(curTrans.getSource().getName()) + "_sync");
                this.stateMap.put(middlestate.getName(), middlestate);
                KmlCommunication calexpr = (KmlCommunication)((KmlAssignmentExpression)expr).getRightOperand();
                Label callLab = new Label(calexpr);
                callLab.setGuard(curLab.getGuard());
                Transition newtc = new Transition(source, middlestate, callLab);
                source.addOutGoingTransition(newtc);
                middlestate.addInComingTransition(newtc);
                ArrayList<KmlExpression> retparam = new ArrayList<KmlExpression>();
                retparam.add(((KmlAssignmentExpression)expr).getLeftOperand());
                KmlCommunication retexpr = new KmlCommunication(calexpr.getInterlocutorSet(), 4, calexpr.getCommunicationName(), retparam);
                retexpr.setParameters(retparam);
                Label retLab = new Label(retexpr);
                newt = new Transition(middlestate, target, retLab);
                middlestate.addOutGoingTransition(newt);
                target.addInComingTransition(newt);
                this.addTransition(newt);
                this.addTransition(newtc);
                this.removeTransition(curTrans);
                continue;
            }
            if (!expr.isComposite()) continue;
            KmlCompositeExpression cExpr = (KmlCompositeExpression)expr;
            if (cExpr.getOperatorType() == ";") {
                Iterator<KmlExpression> iterator = cExpr.getExpressions().iterator();
                while (iterator.hasNext()) {
                    KmlExpression subexpr = iterator.next();
                    Label newLab = new Label(subexpr);
                    if (++labelnumber == 1) {
                        newLab.setGuard(curLab.getGuard());
                    }
                    target = iterator.hasNext() ? new State(String.valueOf(curTrans.getSource().getName()) + "_" + labelnumber) : curTrans.getTarget();
                    newt = new Transition(source, target, newLab);
                    source.addOutGoingTransition(newt);
                    target.addInComingTransition(newt);
                    this.addTransition(newt);
                    source = target;
                }
            } else {
                System.err.println("op_type error:" + cExpr.getOperatorType() + " not handled");
            }
            this.removeTransition(curTrans);
        }
    }

    public void flatten(String channame) {
        try {
            this.expandSubServices(channame);
            this.flattenLabels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LTS getFlatVersion(String channame) {
        LTS copy = this.twin();
        copy.flatten(channame);
        return copy;
    }

    public LTS getFlatVersion() {
        return this.getFlatVersion("__CALLER");
    }

    public void expandSubServices(String channame) throws Exception {
        if (!channame.startsWith("_")) {
            channame = "_" + channame;
        }
        ArrayList copy = new ArrayList();
        copy.addAll(this.stateMap.values());
        for (State element : copy) {
            for (ServiceHook hook : element.getServices()) {
                if (hook.getChannel() != null && !hook.getChannel().equals(channame) && !hook.getChannel().equals("_" + channame) && !"".equals(hook.getChannel())) continue;
                LTS copyLTS = new LTS(hook.getService().getBehavior());
                copyLTS.expandSubServices(channame);
                copyLTS.redirectCaller(channame);
                this.insertLTSAt(copyLTS, element, element, channame, hook.getHooktype().isAnonymous());
            }
            element.setService(null);
        }
        ArrayList copyt = new ArrayList();
        copyt.addAll(this.transitionList);
        for (Transition curTrans : copyt) {
            Label curLab = curTrans.getLabel();
            if (curLab.getActionType() != 512) continue;
            String servname = curLab.getMessage();
            Service subserv = this.owner.getOwner().getService(servname);
            if (subserv == null) {
                System.err.println("ERROR : subservice" + servname + " of service " + this.owner.getName() + "can't be found in component " + this.owner.getOwner().getName());
                continue;
            }
            LTS copyLTS = new LTS(subserv.getBehavior());
            copyLTS.expandSubServices(channame);
            copyLTS.redirectCaller(channame);
            this.insertLTSAt(copyLTS, curTrans.getSource(), curTrans.getTarget(), channame, false);
        }
    }

    private void redirectCaller(String channame) {
        for (Object element2 : this.transitionList) {
            Transition element = (Transition)element2;
            element.getLabel().redirectCaller(channame);
        }
    }

    public void checkVariables() {
        for (Transition t : this.transitionList) {
            t.getLabel().checkVariables(this.owner, t);
        }
    }

    public void checkStates() {
        ArrayList<String> intsub = this.owner.getInterface().getSubprovided();
        for (State st : this.stateMap.values()) {
            for (ServiceHook sh : st.getServices()) {
                if (intsub.contains(sh.getServname())) continue;
                this.getOwner().getLogger().log("callable service " + sh.getServname() + " on node " + st.getName() + " not declared subprovided in the  interface of " + this.owner.getFullName() + ":" + sh.getHooktype() + intsub, this, "INTERFACE WARNING", sh.getLine(), this.getColumn(), this.owner.getFilePath());
            }
        }
    }

    public void resolveServiceHooks() {
        for (State st : this.stateMap.values()) {
            for (ServiceHook sh : st.getServices()) {
                sh.setService(this.getOwner().getOwner().getService(sh.getServname()));
            }
        }
    }

    @Override
    public void accept(KmlElementVisitor visitor) {
        if (visitor.visit(this)) {
            for (State st : this.stateMap.values()) {
                st.accept(visitor);
            }
            for (Transition tr : this.transitionList) {
                tr.accept(visitor);
            }
        }
    }

    public void removeState(State s) {
        if (s.getInComingTransitions() != null) {
            for (Transition t : s.getInComingTransitions()) {
                if (t.getSource() == s) continue;
                t.getSource().getOutGoingTransitions().remove(t);
                this.transitionList.remove(t);
            }
        }
        if (s.getOutGoingTransitions() != null) {
            for (Transition t : s.getOutGoingTransitions()) {
                if (t.getTarget() == s) continue;
                t.getTarget().getInComingTransitions().remove(t);
                this.transitionList.remove(t);
            }
        }
        this.stateMap.remove(s.getName());
    }

    public ArrayList<State> getTerminalStates() {
        return this.terminalStates;
    }

    public void setTerminalStates(ArrayList<State> terminalStates) {
        this.terminalStates = terminalStates;
    }
}

