/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.checks.errorLogger.KmlLogger;
import costo.checks.process.LTSChecker;
import costo.checks.process.ObservablePredicateCheckingVisitor;
import costo.graph.Component;
import costo.graph.ComponentVariable;
import costo.graph.KmlAssertionClause;
import costo.graph.KmlContext;
import costo.graph.KmlStructuralElement;
import costo.graph.LTS;
import costo.graph.ServiceInterface;
import costo.graph.Spec;
import costo.graph.State;
import costo.graph.Variable;
import costo.graph.expressions.AbstractExpressionVisitor;
import costo.graph.expressions.KmlAssignmentExpression;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlPredicate;
import costo.graph.expressions.KmlSignature;
import costo.graph.expressions.KmlTypedStuff;
import costo.graph.promotionVarAdapterVisitor;
import costo.graph.types.CostoType;
import costo.graph.types.CostoUnknownType;
import costo.graph.types.CostoVoid;
import costo.graph.visitors.KmlElementAbstractVisitor;
import costo.graph.visitors.KmlElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Service
extends KmlStructuralElement
implements KmlContext {
    promotionVarAdapterVisitor visitor = null;
    private String comment = "";
    @Deprecated
    private ComponentVariable origin;
    private HashMap<String, Variable> parametersMap;
    private ArrayList<Variable> parameters;
    private CostoType returnCostoType;
    private Component owner;
    private ArrayList<String> properties;
    protected ServiceInterface serviceInterface;
    private boolean provided;
    private boolean query = false;
    private int line;
    private int column;
    private KmlAssertionClause preClause = new KmlAssertionClause("Pre");
    private KmlAssertionClause postClause = new KmlAssertionClause("Post");
    private HashMap<String, KmlPredicate> invMap;
    private KmlAssertionClause invClause = new KmlAssertionClause("Invariant");
    private HashMap<String, Variable> variables;
    private HashMap<String, Variable> constants;
    private HashMap<String, KmlAssignmentExpression> initializations;
    protected LTS behavior;
    private Variable result;
    private ArrayList<Variable> unchangedVars = new ArrayList();
    protected boolean isPromoted = false;
    private Service originalservice;
    private String origCompName;
    private String origServName;

    @Override
    public String getFilePath() {
        return this.owner.getFilePath();
    }

    public Service twin() {
        Service twin = new Service(new String(this.getName()), this.provided);
        twin.setBehavior(this.behavior.twin());
        twin.column = this.column;
        twin.comment = this.comment;
        twin.line = this.line;
        twin.constants = this.constants;
        twin.initializations = this.initializations;
        twin.invClause = this.invClause;
        twin.invMap = this.invMap;
        twin.isPromoted = this.isPromoted;
        twin.origCompName = this.origCompName;
        twin.originalservice = this.originalservice;
        twin.owner = this.owner;
        twin.parameters = this.parameters;
        twin.parametersMap = this.parametersMap;
        twin.postClause = this.postClause;
        twin.preClause = this.preClause;
        twin.properties = this.properties;
        twin.query = this.query;
        twin.result = this.result;
        twin.returnCostoType = this.returnCostoType;
        twin.serviceInterface = this.serviceInterface;
        twin.unchangedVars = this.unchangedVars;
        twin.variables = this.variables;
        return twin;
    }

    public void setPromotionOrigin(String cname, String servname) {
        this.isPromoted = true;
        this.origCompName = cname;
        this.origServName = servname;
    }

    public String toString() {
        String s = "";
        s = this.isProvided() ? String.valueOf(s) + "provided " : String.valueOf(s) + "required ";
        s = String.valueOf(s) + this.getSignature();
        if (this.isPromoted()) {
            s = String.valueOf(s) + " From " + (this.originalservice == null ? "?" : String.valueOf(this.getOrigCompName()) + "." + this.getOrigServName()) + "\n";
        } else {
            s = String.valueOf(s) + "\n" + this.comment + "\n";
            if (this.getInterface() != null) {
                s = String.valueOf(s) + this.getInterface();
            }
            if (this.properties != null) {
                s = String.valueOf(s) + Spec.listToString(this.properties, "Properties : {", ",", "}\n");
            }
            if (this.preClause != null) {
                s = String.valueOf(s) + this.preClause.toString();
            }
            if (this.constants != null) {
                s = String.valueOf(s) + Spec.listToString(this.constants.values(), "Constants\n  ", ";\n  ", "\n");
            }
            if (this.variables != null) {
                s = String.valueOf(s) + Spec.listToString(this.variables.values(), "Variables\n  ", ";\n  ", "\n");
            }
            if (this.initializations != null) {
                s = String.valueOf(s) + Spec.listToString(this.initializations.values(), "Initialization\n  ", ";\n  ", "\n");
            }
            if (this.behavior != null) {
                s = String.valueOf(s) + "\nBehavior \n" + this.getBehavior().toString();
            }
            if (this.postClause != null) {
                s = String.valueOf(s) + this.postClause.toString();
            }
        }
        s = String.valueOf(s) + "End # of service " + this.getName() + "\n";
        return s;
    }

    public Service(String name, boolean provided) {
        this.setName(name);
        this.provided = provided;
        this.returnCostoType = CostoVoid.instance;
    }

    public void setBehavior(LTS a) {
        this.behavior = a;
        if (this.behavior != null) {
            this.behavior.setOwner(this);
        }
    }

    public LTS getBehavior() {
        if (!this.isPromoted || this.behavior != null) {
            return this.behavior;
        }
        return this.originalservice == null ? null : this.originalservice.getBehavior();
    }

    public String getFullName() {
        return String.valueOf(this.getOwner().getName()) + "." + this.getName();
    }

    public Component getOwner() {
        return this.owner;
    }

    public boolean isProvided() {
        return this.provided;
    }

    public boolean isOwned() {
        return this.provided;
    }

    public boolean isRequired() {
        return !this.provided;
    }

    public HashMap<String, Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(HashMap<String, Variable> variables) {
        this.variables = variables;
        for (Variable var : variables.values()) {
            var.setDeclarationContext(this);
        }
    }

    public ServiceInterface getInterface() {
        if (this.isPromoted && this.serviceInterface == null && this.originalservice != null) {
            return this.originalservice.getInterface();
        }
        return this.serviceInterface;
    }

    public void setInterface(ServiceInterface serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setProvided(boolean provided) {
        this.provided = provided;
    }

    public void setOwned(boolean provided) {
        this.provided = provided;
    }

    public void setOwner(Component component) {
        this.owner = component;
        if (this.behavior != null) {
            this.behavior.setOwner(this);
        }
    }

    public String getParams() {
        if (this.isPromoted && this.originalservice != null) {
            return this.originalservice.getParams();
        }
        if (this.parameters == null) {
            return "";
        }
        return Spec.listToString(this.parameters, "(", ";", ")");
    }

    public boolean isPromoted() {
        return this.isPromoted;
    }

    public void setPromoted(boolean isPromoted) {
        this.isPromoted = isPromoted;
    }

    public Service getOriginalservice() {
        return this.originalservice;
    }

    public void setOriginalservice(Service originalservice) {
        this.isPromoted = true;
        this.originalservice = originalservice;
    }

    public String getSignature() {
        return String.valueOf(this.getName()) + this.getParams() + (this.getReturnCostoType() == null || this.getReturnCostoType().equals(CostoVoid.instance) ? "" : " : " + this.getReturnCostoType().getName());
    }

    public HashMap<String, KmlAssignmentExpression> getInitializations() {
        return this.initializations;
    }

    public void setInitializations(HashMap<String, KmlAssignmentExpression> initializations) {
        this.initializations = initializations;
    }

    private void checkInitialization() {
        if (this.initializations != null) {
            for (Map.Entry<String, KmlAssignmentExpression> element : this.initializations.entrySet()) {
                Variable var = this.lookupVariable(element.getKey());
                if (var == null) {
                    this.getLogger().log("Undeclared Variable " + element.getKey() + " in service " + this.getFullName(), element.getValue(), "RESOLUTION ERROR", element.getValue().getLine(), element.getValue().getLine(), this.getFilePath());
                    continue;
                }
                element.getValue().resolveType(this);
            }
        }
    }

    @Override
    public Variable lookupVariable(String name) {
        if (name.equals("Result")) {
            return this.result;
        }
        String n = "";
        int index = name.indexOf(".");
        n = index > 0 ? name.substring(0, index) : name;
        Variable temp = null;
        if (this.variables != null) {
            temp = this.variables.get(n);
        }
        if (temp == null && this.constants != null) {
            temp = this.constants.get(n);
        }
        if (temp == null && this.parametersMap != null) {
            temp = this.parametersMap.get(n);
        }
        if (temp != null && index > 0) {
            temp = temp.resolve(name.substring(index + 1));
        }
        if (temp == null) {
            temp = this.owner.lookupVariable(name);
        }
        return temp;
    }

    public void checkService() {
        this.result = new Variable("Result", CostoUnknownType.instance);
        if (this.returnCostoType != null) {
            this.result = this.returnCostoType.createVariable("Result", false);
        }
        this.result.setObservable(true);
        this.result.setDeclarationContext(this);
        if (this.variables == null) {
            this.variables = new HashMap();
        }
        if (!this.isPromoted) {
            this.checkVariables();
            this.checkConstants();
            this.checkInitialization();
            this.checkInvariant();
        } else {
            this.checkSignaturePromotionCompatibility();
        }
        this.checkPre();
        this.checkPost();
        if (this.behavior != null) {
            this.behavior.checkVariables();
            this.behavior.checkStates();
            Collection<State> wells = LTSChecker.statesNotReachingFinal(this.behavior);
            if (wells != null) {
                this.getLogger().log("States " + wells + " do not lead to final states ", this, "BEHAVIOURAL ERROR", this.behavior.getLine(), this.behavior.getColumn(), this.getFilePath());
            }
            if ((wells = LTSChecker.unreachableStates(this.behavior)) != null) {
                this.getLogger().log("States " + wells + " cannot be reached from initial state" + this.behavior.getInitialState().getName(), this, "BEHAVIOURAL ERROR", this.behavior.getLine(), this.behavior.getColumn(), this.getFilePath());
            }
        }
        this.checkReturnService();
        if (this.serviceInterface != null) {
            this.serviceInterface.checkExistenceAndUse(this.owner);
        }
        if (this.isPromoted && this.originalservice != null) {
            this.visitor = new promotionVarAdapterVisitor(this.owner, this.originalservice.owner);
        }
    }

    private void checkInvariant() {
        if (this.getInvMap() == null || this.getInvMap().isEmpty()) {
            return;
        }
        if (this.isPromoted) {
            System.err.println("can't handle promoted inv");
            return;
        }
        for (KmlPredicate pred : this.getInvMap().values()) {
            pred.resolveType(this);
        }
    }

    private void checkSignaturePromotionCompatibility() {
        KmlSignature secondsig;
        if (this.originalservice == null) {
            return;
        }
        KmlSignature firstsig = this.getKmlSignature();
        if (!firstsig.equalsIgnoreName(secondsig = this.getOriginalservice().getKmlSignature())) {
            this.owner.getLogger().log("incompatible signatures   in service promotion " + firstsig.toString() + " != " + secondsig.toString(), this, "SERVICE PROMOTION ERROR", this.getLine(), this.getColumn(), this.owner.getFilePath());
        }
    }

    private void checkReturnService() {
        if (this.returnCostoType == CostoVoid.instance) {
            return;
        }
    }

    private void checkPre() {
        if (this.getPreMap() == null || this.getPreMap().isEmpty()) {
            return;
        }
        if (this.isPromoted) {
            this.checkPromotedPre();
        } else if (this.preClause != null && !this.preClause.isUnchanged()) {
            this.getLogger().log("A precondition clause can only be strengthened during a promotion of service, please use only the Pre keyword ", this.preClause, "PRECONDITION ERROR", this.preClause.getLine(), this.preClause.getColumn(), this.getFilePath());
        }
        for (KmlPredicate pred : this.getPreMap().values()) {
            pred.resolveType(this);
            if (this.isProvided()) {
                pred.setObservable(true);
            }
            if (!pred.isObservable()) continue;
            pred.accept(new ObservablePredicateCheckingVisitor(this));
        }
    }

    private void checkPromotedPre() {
        if (this.isProvided() && this.preClause != null && (this.preClause.isWeakenedClause() || this.preClause.isUnchanged())) {
            this.getLogger().log("Pre clause of a promoted service can not be weakened, please either remove the Pre condition or use RedefinedPre Stronger or RedefinedPre Stronger With ", this.preClause, "PROMOTION ERROR", this.preClause.getLine(), this.preClause.getColumn(), this.getFilePath());
        }
    }

    private void checkPost() {
        if (this.getPostMap() == null || this.getPostMap().isEmpty()) {
            return;
        }
        if (this.isPromoted) {
            this.checkPromotedPost();
        } else if (this.postClause != null && !this.postClause.isUnchanged()) {
            this.getLogger().log("A postcondition clause can only be strengthened or weakened during a promotion of service, please use only the POST keyword ", this.postClause, "POSTCONDITION ERROR", this.postClause.getLine(), this.postClause.getColumn(), this.getFilePath());
        }
        for (KmlPredicate pred : this.getPostMap().values()) {
            pred.resolveType(this);
            if (!pred.isObservable()) continue;
            pred.accept(new ObservablePredicateCheckingVisitor(this));
        }
    }

    private void checkPromotedPost() {
        if (this.isProvided() && this.postClause != null && this.postClause.isUnchanged()) {
            this.getLogger().log("Either remove the precondition to leave it unchanged from the original, state that you are weakening it (RedefinedPost Weaker or RedefinedPost Weaker With)  or strengthening  it (RedefinedPost Stronger or RedefinedPost Stronger With)  ", this.postClause, "PROMOTION ERROR", this.postClause.getLine(), this.postClause.getColumn(), this.getFilePath());
        }
    }

    private void checkVariables() {
        if (this.variables == null) {
            return;
        }
        for (Variable var : this.variables.values()) {
            if (var == null) continue;
            try {
                if (var.getCtype() == null) continue;
                var.getCtype().resolve(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void checkConstants() {
        if (this.constants != null) {
            for (Variable var : this.constants.values()) {
                if (!var.getExpression().resolveType(this)) {
                    this.getLogger().log("Cannot type " + var, var, "TYPE ERROR", var.getExpression().getLine(), var.getExpression().getColumn(), this.getFilePath());
                    continue;
                }
                if (KmlTypedStuff.typeCheck(var.getExpression(), var.getCtype())) continue;
                this.getLogger().log(" in " + var + " : " + var.getExpression() + " of type " + var.getExpression().getType() + "cannot be assigned to " + var.getName() + " of type " + var.getType(), var, "TYPE ERROR", var.getExpression().getLine(), var.getExpression().getColumn(), this.getFilePath());
            }
        }
    }

    public boolean isValidChannel(String chan) {
        if (chan == null) {
            return false;
        }
        if (chan.equals("")) {
            return false;
        }
        if ((chan = chan.substring(1)).equals("_CALLER")) {
            return true;
        }
        if (chan.equals("_SELF")) {
            return true;
        }
        for (String element : this.getInterface().getExtrequired()) {
            if (!chan.equalsIgnoreCase(element)) continue;
            return true;
        }
        return false;
    }

    public HashMap<String, Variable> getConstants() {
        return this.constants;
    }

    public void setConstants(HashMap<String, Variable> constants) {
        this.constants = constants;
        for (Variable var : constants.values()) {
            var.setDeclarationContext(this);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void resolveServiceHooks() {
        if (this.behavior != null) {
            this.behavior.resolveServiceHooks();
        }
    }

    public ArrayList<String> getProperties() {
        return this.properties;
    }

    public void setProperties(ArrayList<String> properties) {
        this.properties = properties;
    }

    public ServiceInterface getDeepInterface() {
        ServiceInterface s = new ServiceInterface(this.getInterface());
        ArrayList subprovided_old = (ArrayList)s.getSubprovided().clone();
        for (String element : subprovided_old) {
            ServiceInterface serv = this.owner.getService(element).getDeepInterface();
            s.addCalrequired(serv.getCalrequired());
            s.addExtrequired(serv.getExtrequired());
            s.addIntrequired(serv.getIntrequired());
            s.addReceptions(serv.getReceptions());
            s.addSendings(serv.getSendings());
            s.addSubprovided(serv.getSubprovided());
        }
        return s;
    }

    public CostoType getReturnCostoType() {
        if (this.isPromoted && this.originalservice != null) {
            return this.originalservice.getReturnCostoType();
        }
        return this.returnCostoType;
    }

    public void setReturnCostoType(CostoType returnCostoType) {
        this.returnCostoType = returnCostoType;
    }

    @Deprecated
    public HashMap<String, Variable> getParametersMap() {
        return this.parametersMap;
    }

    @Deprecated
    public void setParametersMap(HashMap<String, Variable> parametersMap) {
        this.parametersMap = parametersMap;
        this.parameters = new ArrayList();
        this.parameters.addAll(parametersMap.values());
        for (Variable var : parametersMap.values()) {
            var.setObservable(true);
            var.setDeclarationContext(this);
        }
    }

    public void setParametersMap(ArrayList<Variable> parameterlist) {
        this.parameters = parameterlist;
        this.parametersMap = new HashMap();
        if (this.parameters != null) {
            for (Variable var : this.parameters) {
                var.setObservable(true);
                var.setDeclarationContext(this);
                this.parametersMap.put(var.getName(), var);
            }
        }
    }

    public HashMap<String, KmlPredicate> getPreMap() {
        if (this.isPromoted && (this.preClause == null || this.preClause.getAssertMap() == null)) {
            return this.originalservice != null ? this.adaptPromotedPredicate(this.originalservice.getPreMap()) : null;
        }
        if (this.preClause == null) {
            return null;
        }
        return this.preClause.getAssertMap();
    }

    private HashMap<String, KmlPredicate> adaptPromotedPredicate(HashMap<String, KmlPredicate> predMap) {
        if (this.visitor == null) {
            return predMap;
        }
        if (predMap == null) {
            return null;
        }
        HashMap<String, KmlPredicate> adaptedPredMap = new HashMap<String, KmlPredicate>();
        for (Map.Entry<String, KmlPredicate> entry : predMap.entrySet()) {
            KmlPredicate pred = (KmlPredicate)entry.getValue().deepCopy();
            pred.accept(this.visitor);
            adaptedPredMap.put(entry.getKey(), pred);
        }
        return adaptedPredMap;
    }

    public void setPreMap(HashMap<String, KmlPredicate> preMap) {
        if (this.preClause == null) {
            this.preClause = new KmlAssertionClause("Pre");
        }
        this.preClause.setAssertMap(preMap);
    }

    public HashMap<String, KmlPredicate> getPostMap() {
        if (this.isPromoted && (this.postClause == null || this.postClause.getAssertMap() == null)) {
            return this.originalservice != null ? this.adaptPromotedPredicate(this.originalservice.getPostMap()) : null;
        }
        if (this.postClause == null) {
            return null;
        }
        return this.postClause.getAssertMap();
    }

    public void setPostMap(HashMap<String, KmlPredicate> postMap) {
        if (this.postClause == null) {
            this.postClause = new KmlAssertionClause("Post");
        }
        this.postClause.setAssertMap(postMap);
    }

    @Override
    public KmlSignature resolveFunction(String functionName, ArrayList<CostoType> operandsTypes, KmlExpression source) {
        return this.owner.resolveFunction(functionName, operandsTypes, source);
    }

    @Override
    public CostoType resolveType(String name) {
        return this.owner.resolveType(name);
    }

    @Override
    public KmlSignature resolveCommunication(KmlCommunication comm) {
        ArrayList<String> required = null;
        String channel = comm.getInterlocutorSet().getChannel().substring(1);
        if (comm.getActionType() == 32) {
            return this.getKmlSignature();
        }
        if (channel == null || channel.equals("_CALLER")) {
            required = this.serviceInterface.getCalrequired();
        } else if (channel.equals("_SELF")) {
            required = this.serviceInterface.getIntrequired();
            if (!required.contains(comm.getCommunicationName())) {
                this.getLogger().log("service " + comm.getCommunicationName() + " not found in " + this.getFullName() + " interface ", comm, "RESOLUTION WARNING", comm.getLine(), comm.getColumn(), this.getFilePath());
            }
        } else {
            required = this.serviceInterface.getAllRequired();
            if (!required.contains(channel)) {
                this.getLogger().log("service " + channel + " not found in " + this.getFullName() + " interface ", comm, "RESOLUTION WARNING", comm.getLine(), comm.getColumn(), this.getFilePath());
            }
        }
        if (comm.getActionType() == 1 || comm.getActionType() == 4) {
            Service called = this.owner.getService(comm.getCommunicationName());
            if (called == null) {
                this.getLogger().log("couldn't find service " + comm.getCommunicationName() + " in component " + this.owner.getName(), comm, "RESOLUTION WARNING", comm.getLine(), comm.getColumn(), this.getFilePath());
                return null;
            }
            KmlSignature sig = called.getKmlSignature();
            return sig;
        }
        return new KmlSignature(comm.getCommunicationName(), null, CostoVoid.instance);
    }

    public KmlSignature getKmlSignature() {
        ArrayList<CostoType> parametersTypes = null;
        if (this.getParameters() != null) {
            parametersTypes = new ArrayList<CostoType>();
            for (Variable param : this.getParameters()) {
                parametersTypes.add(param.getCtype());
            }
        }
        return new KmlSignature(this.getName(), parametersTypes, this.getReturnCostoType());
    }

    @Override
    public void addFunction(KmlSignature sig) {
        System.err.println("Cannot  add function to a service. This should be an exception since it cannot be generated from the grammar, only through API");
    }

    @Override
    public void accept(KmlElementVisitor visitor) {
        if (visitor.visit(this) && this.behavior != null) {
            this.behavior.accept(visitor);
        }
    }

    public HashMap<String, KmlPredicate> getInvMap() {
        return this.invMap;
    }

    public void setInvMap(HashMap<String, KmlPredicate> invMap) {
        this.invMap = invMap;
    }

    @Override
    public KmlLogger getLogger() {
        return this.owner.getLogger();
    }

    public boolean isQuery() {
        return this.query;
    }

    public void setQuery(boolean query) {
        this.query = query;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public void setColumn(int column) {
        this.column = column;
    }

    public Service getObs() {
        Service s = new Service(this.getName(), this.isProvided());
        HashMap<String, Variable> vars = new HashMap<String, Variable>();
        HashMap<String, Variable> csts = new HashMap<String, Variable>();
        ArrayList<Variable> params = new ArrayList<Variable>();
        HashMap<String, KmlPredicate> pre = new HashMap<String, KmlPredicate>();
        HashMap<String, KmlPredicate> post = new HashMap<String, KmlPredicate>();
        HashMap<String, KmlAssignmentExpression> init = new HashMap<String, KmlAssignmentExpression>();
        this.result = new Variable("Result", CostoUnknownType.instance);
        if (this.getReturnCostoType() != null) {
            this.result = this.getReturnCostoType().createVariable("Result", false);
        }
        this.result.setObservable(true);
        if (this.parameters != null) {
            params.addAll(this.parameters);
        }
        s.setParameters(params);
        if (this.variables != null) {
            for (Variable variable : this.variables.values()) {
                if (variable == null || !variable.isObservable()) continue;
                vars.put(variable.getName(), variable);
            }
        }
        s.setVariables(vars);
        if (this.constants != null) {
            for (Variable variable : this.constants.values()) {
                if (variable == null || !variable.isObservable()) continue;
                csts.put(variable.getName(), variable);
            }
        }
        s.setConstants(csts);
        if (this.getPreMap() != null) {
            for (KmlPredicate kmlPredicate : this.getPreMap().values()) {
                if (kmlPredicate.isLocal()) continue;
                pre.put(kmlPredicate.getName(), kmlPredicate);
            }
        }
        s.setPreMap(pre);
        if (this.getPostMap() != null) {
            for (KmlPredicate kmlPredicate : this.getPostMap().values()) {
                if (kmlPredicate.isLocal()) continue;
                post.put(kmlPredicate.getName(), kmlPredicate);
            }
        }
        s.setPostMap(post);
        if (this.initializations != null) {
            for (Map.Entry entry : this.initializations.entrySet()) {
                Variable var = this.lookupVariable((String)entry.getKey());
                if (var == null || !var.isObservable()) continue;
                init.put(var.getName(), (KmlAssignmentExpression)entry.getValue());
            }
        }
        s.setInitializations(init);
        return s;
    }

    @Override
    public void setFilePath(String fp) {
        this.owner.setFilePath(fp);
    }

    @Override
    public void setLogger(KmlLogger log) {
        this.owner.setLogger(log);
    }

    public ArrayList<Variable> getParameters() {
        if (this.isPromoted && this.originalservice != null && this.parameters == null) {
            return this.originalservice.getParameters();
        }
        return this.parameters;
    }

    public void setParameters(ArrayList<Variable> parameters) {
        this.parameters = parameters;
        this.parametersMap = new HashMap();
        if (parameters != null) {
            for (Variable var : parameters) {
                var.setObservable(true);
                var.setDeclarationContext(this);
                this.parametersMap.put(var.getName(), var);
            }
        }
    }

    public void addUnchangedVar(Variable var) {
        if (var != null) {
            this.unchangedVars.add(var);
        }
    }

    public ArrayList<Variable> getUnchangedVars() {
        return this.unchangedVars;
    }

    public ComponentVariable getOrigin() {
        return this.origin;
    }

    public void setOrigin(ComponentVariable origin) {
        this.origin = origin;
    }

    public KmlAssertionClause getPreClause() {
        return this.preClause;
    }

    public void setPreClause(KmlAssertionClause preClause) {
        this.preClause = preClause;
    }

    public KmlAssertionClause getPostClause() {
        return this.postClause;
    }

    public void setPostClause(KmlAssertionClause postClause) {
        this.postClause = postClause;
    }

    public String getOrigServName() {
        return this.origServName;
    }

    public void setOrigServName(String origServName) {
        this.origServName = origServName;
    }

    public String getOrigCompName() {
        return this.origCompName;
    }

    public void setOrigCompName(String origCompName) {
        this.origCompName = origCompName;
    }

    public boolean meetsCriterion(int criterion) {
        if ((criterion & 1) > 0 && !this.provided) {
            return false;
        }
        if ((criterion & 2) > 0 && this.provided) {
            return false;
        }
        if ((criterion & 4) > 0 && !this.owner.getInterface().isDirectlyAccessible(this.getName())) {
            return false;
        }
        if ((criterion & 8) > 0 && this.owner.getInterface().isDirectlyAccessible(this.getName())) {
            return false;
        }
        if ((criterion & 0x10) > 0 && !this.isPromoted()) {
            return false;
        }
        return (criterion & 0x20) <= 0 || !this.isPromoted();
    }

    @Override
    public Set<KmlSignature> getAllFunctions() {
        return null;
    }

    public Set<KmlSignature> getAllSignaturesOnChan(final String chan, final int commMask) {
        final HashSet<KmlSignature> theset = new HashSet<KmlSignature>();
        if (this.behavior == null) {
            return theset;
        }
        this.behavior.accept(new KmlElementAbstractVisitor(new AbstractExpressionVisitor(){

            @Override
            public void defaultExpressionOperation(KmlTypedStuff expr) {
            }

            @Override
            public boolean visit(KmlCommunication expression) {
                if ((expression.getActionType() & commMask) > 0 && expression.getInterlocutorSet().getChannel().equals(chan)) {
                    theset.add(expression.getSignature());
                }
                return super.visit(expression);
            }
        }));
        return theset;
    }

    public Map<String, KmlSignature> getAllSignaturesByChan(final int commMask) {
        final HashMap<String, KmlSignature> themap = new HashMap<String, KmlSignature>();
        if (this.behavior == null) {
            return themap;
        }
        this.behavior.accept(new KmlElementAbstractVisitor(new AbstractExpressionVisitor(){

            @Override
            public void defaultExpressionOperation(KmlTypedStuff expr) {
            }

            @Override
            public boolean visit(KmlCommunication expression) {
                if ((expression.getActionType() & commMask) > 0) {
                    themap.put(expression.getInterlocutorSet().getChannel(), expression.getSignature());
                }
                return super.visit(expression);
            }
        }));
        return themap;
    }

    public ArrayList<Service> getRequired() {
        ArrayList<Service> reqs = new ArrayList<Service>();
        if (this.getInterface() != null) {
            for (String req : this.getInterface().getRequired()) {
                reqs.add(this.getOwner().getService(req));
            }
        }
        return reqs;
    }

    public Variable getResultVar() {
        return this.result;
    }
}

