/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.Expression;
import costo.graph.KmlContext;
import costo.graph.StructuredVariable;
import costo.graph.expressions.KmlExpression;
import costo.graph.types.CostoType;

public class Variable
extends Expression {
    private String type;
    private CostoType ctype = null;
    private KmlContext declarationContext = null;
    private boolean writable = true;
    private boolean constant = false;
    private boolean observable = false;
    private KmlExpression expression = null;
    private StructuredVariable container;

    public Variable() {
    }

    public Variable deepCopy() {
        Variable twin = new Variable(this.getName(), this.ctype, this.constant);
        if (this.expression != null) {
            twin.expression = this.expression.deepCopy();
        }
        return twin;
    }

    public Variable(String name, CostoType ctype) {
        super(name);
        this.ctype = ctype;
        if (this.type != null) {
            this.type = ctype.getName();
        }
    }

    public Variable(String name, CostoType ctype, boolean constant) {
        super(name);
        this.ctype = ctype;
        this.type = ctype.getName();
        this.constant = constant;
    }

    public CostoType getCtype() {
        return this.ctype;
    }

    public KmlExpression getExpression() {
        return this.expression;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        String s = "";
        if (this.expression != null) {
            s = this.expression.getRawValue();
        }
        return s;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public boolean isObservable() {
        return this.observable;
    }

    public Variable resolve(String substring) {
        return null;
    }

    public boolean sameType(Variable v) {
        if (this.type == null || v.type == null) {
            return false;
        }
        return this.type.equals(v.type);
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
        this.writable = false;
    }

    public void setCtype(CostoType ctype) {
        this.ctype = ctype;
    }

    public void setExpression(KmlExpression expression) {
        this.expression = expression;
    }

    public void setObservable(boolean observable) {
        this.observable = observable;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        if (this.getName().equals(this.getValue())) {
            return this.getValue();
        }
        String s = String.valueOf(this.getName()) + " : ";
        if (this.ctype != null) {
            s = this.getCtype().isAnonymous() ? String.valueOf(s) + this.getCtype().getRawdescription() : String.valueOf(s) + this.getCtype().getName();
        }
        if (this.expression != null) {
            s = String.valueOf(s) + " := " + this.expression.getRawValue();
        } else if (!this.getValue().equals("")) {
            s = String.valueOf(s) + " := " + this.getValue();
        }
        return s;
    }

    public KmlContext getDeclarationContext() {
        return this.declarationContext;
    }

    public void setDeclarationContext(KmlContext declarationContext) {
        this.declarationContext = declarationContext;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Variable) {
            Variable other = (Variable)obj;
            return this.getName().equals(other.getName()) && this.sameType(other);
        }
        return super.equals(obj);
    }

    public boolean isSimple() {
        return true;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void setWritable(boolean writable) {
        this.writable = writable;
    }

    public void setContainer(StructuredVariable structuredVariable) {
        this.container = structuredVariable;
    }

    public StructuredVariable getContainer() {
        return this.container;
    }
}

