/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.expressions.AbstractExpressionVisitor;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlTypedStuff;
import java.util.ArrayList;

public class CommunicationVisitorExtractor
extends AbstractExpressionVisitor {
    private ArrayList<KmlCommunication> comms = new ArrayList();
    private int actionmask;
    private String Channelmask;

    public CommunicationVisitorExtractor(int actionmask) {
        this.actionmask = actionmask;
    }

    public CommunicationVisitorExtractor(String channelmask) {
        this.Channelmask = channelmask;
    }

    public CommunicationVisitorExtractor(int actionmask, String channelmask) {
        this.actionmask = actionmask;
        this.Channelmask = channelmask;
    }

    @Override
    public void defaultExpressionOperation(KmlTypedStuff expr) {
    }

    @Override
    public boolean visit(KmlCommunication expression) {
        if (this.filterChannel(expression.getInterlocutorSet().getChannel()) && this.filterActionType(expression.getActionType())) {
            this.comms.add(expression);
        }
        return super.visit(expression);
    }

    private boolean filterActionType(int actionType) {
        if (this.actionmask == 0) {
            return true;
        }
        return (actionType & this.actionmask) > 0;
    }

    private boolean filterChannel(String channel) {
        if (this.Channelmask == null) {
            return true;
        }
        return this.Channelmask.equals(channel);
    }

    public ArrayList<KmlCommunication> getComms() {
        return this.comms;
    }

    public int getActionmask() {
        return this.actionmask;
    }

    public void setActionmask(int actionmask) {
        this.actionmask = actionmask;
    }

    public String getChannelmask() {
        return this.Channelmask;
    }

    public void setChannelmask(String channelmask) {
        this.Channelmask = channelmask;
    }

    public void reset() {
        this.comms = new ArrayList();
    }
}

