/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.Spec;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.KmlCompositeExpression;
import costo.graph.expressions.KmlExpression;
import costo.graph.types.CostoType;
import java.util.ArrayList;

public class KmlArrayInitializer
extends KmlCompositeExpression {
    public KmlArrayInitializer(String operatorType) {
        super(operatorType);
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public KmlArrayInitializer() {
        this(",");
    }

    @Override
    public boolean resolveType(KmlContext context) {
        boolean ok = true;
        CostoType first = null;
        boolean sametypes = true;
        ArrayList elemtypes = new ArrayList();
        for (KmlExpression operand : this.getExpressions()) {
            boolean newok = operand.resolveType(context);
            if (first == null) {
                first = operand.getType();
            } else if (!first.conformsTo(operand.getType()) || !operand.getType().conformsTo(first)) {
                sametypes = false;
            }
            boolean bl = ok = ok && newok;
        }
        if (!sametypes) {
            context.getLogger().log("incompatible types in" + this + ":" + Spec.listToString(elemtypes, "[", ";", "]"), this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
        }
        this.type = first;
        return ok && sametypes;
    }

    @Override
    public KmlExpression deepCopy() {
        return new KmlArrayInitializer(this.getOperatorType());
    }
}

