/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.Variable;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlExpression;
import costo.graph.types.CostoUnknownType;

public class KmlIdentifier
extends KmlExpression {
    private Variable var;

    public KmlIdentifier(Variable var) {
        super(var.getName());
        this.var = var;
        this.type = var.getCtype();
    }

    public KmlIdentifier() {
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean resolveType(KmlContext context) {
        if (this.var == null) {
            this.var = context.lookupVariable(this.getRawValue());
        }
        if (this.var == null) {
            context.getLogger().log("cannot resolve identifier " + this.getRawValue(), this, "RESOLUTION ERROR", this.getLine(), this.getColumn(), context.getFilePath());
            this.setType(CostoUnknownType.instance);
            return false;
        }
        this.setType(this.var.getCtype());
        return true;
    }

    public Variable getVar() {
        return this.var;
    }

    @Override
    public KmlExpression deepCopy() {
        KmlIdentifier twin = new KmlIdentifier();
        twin.setType(this.type);
        twin.setRawValue(this.getRawValue());
        twin.setLine(this.getLine());
        twin.setColumn(this.getColumn());
        twin.var = this.var;
        return twin;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public void setVar(Variable var) {
        this.var = var;
        this.setRawValue(var.getName());
    }

    @Override
    public String getRawValue() {
        if (this.var != null && this.var.getContainer() == null) {
            return this.var.getName();
        }
        return super.getRawValue();
    }
}

