/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlExpression;
import costo.graph.types.CostoBoolean;
import costo.graph.types.CostoType;
import costo.graph.types.CostoVoid;

public class KmlIfExpression
extends KmlExpression {
    private KmlExpression ifexp;
    private KmlExpression thenexp;
    private KmlExpression elseexp;

    public KmlIfExpression(KmlExpression ifexp, KmlExpression thenexp, KmlExpression elseexp) {
        this.ifexp = ifexp;
        this.setLine(ifexp.getLine() - 3);
        this.setColumn(ifexp.getColumn());
        this.thenexp = thenexp;
        this.elseexp = elseexp;
    }

    public KmlExpression getIfexp() {
        return this.ifexp;
    }

    public KmlExpression getThenexp() {
        return this.thenexp;
    }

    public KmlExpression getElseexp() {
        return this.elseexp;
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getRawValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("if (");
        stringBuilder.append(this.ifexp.getRawValue());
        stringBuilder.append(") then ");
        stringBuilder.append(this.thenexp.getRawValue());
        if (this.elseexp != null) {
            stringBuilder.append(" else ");
            stringBuilder.append(this.elseexp.getRawValue());
        }
        stringBuilder.append(" fi");
        return stringBuilder.toString();
    }

    @Override
    public CostoType getType() {
        return CostoVoid.instance;
    }

    @Override
    public boolean resolveType(KmlContext context) {
        this.ifexp.resolveType(context);
        if (!this.typeCheckAgainst(this.ifexp, CostoBoolean.instance)) {
            context.getLogger().log(this.ifexp + " must be Boolean ", this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
            return false;
        }
        this.thenexp.resolveType(context);
        if (!this.typeCheckAgainst(this.thenexp, CostoVoid.instance)) {
            context.getLogger().log(this.thenexp + " is not a statement. " + this.thenexp.getType() + " found, type Void expected.", this, "TYPE ERROR", this.thenexp.getLine(), this.thenexp.getColumn(), context.getFilePath());
        }
        if (this.elseexp != null) {
            this.elseexp.resolveType(context);
            if (!this.typeCheckAgainst(this.elseexp, CostoVoid.instance)) {
                context.getLogger().log(this.elseexp + " is not a statement. " + this.elseexp.getType() + " found, type Void expected.", this, "TYPE ERROR", this.elseexp.getLine(), this.elseexp.getColumn(), context.getFilePath());
            }
        }
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            this.ifexp.accept(visitor);
            this.thenexp.accept(visitor);
            if (this.elseexp != null) {
                this.elseexp.accept(visitor);
            }
        }
    }

    @Override
    public KmlExpression deepCopy() {
        KmlExpression twinelse = this.elseexp != null ? this.elseexp.deepCopy() : this.elseexp;
        KmlIfExpression twin = new KmlIfExpression(this.ifexp.deepCopy(), this.thenexp.deepCopy(), twinelse);
        twin.setType(this.type);
        twin.setRawValue(this.getRawValue());
        twin.setLine(this.getLine());
        twin.setColumn(this.getColumn());
        return twin;
    }
}

