/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.InterlocutorSet;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.KmlExpression;

public class KmlMandatoryCall
extends KmlExpression {
    private InterlocutorSet interlocutorSet;
    private String serviceName;

    public KmlMandatoryCall(InterlocutorSet interlocutorSet, String serviceName) {
        this.interlocutorSet = interlocutorSet;
        this.setColumn(interlocutorSet.getColumn());
        this.setLine(interlocutorSet.getLine());
        this.serviceName = serviceName;
    }

    public InterlocutorSet getInterlocutorSet() {
        return this.interlocutorSet;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getRawValue() {
        return "[[" + this.interlocutorSet + this.serviceName + "]]";
    }

    @Override
    public KmlExpression deepCopy() {
        KmlMandatoryCall twin = new KmlMandatoryCall(this.interlocutorSet.deepCopy(), this.serviceName);
        twin.setType(this.type);
        twin.setRawValue(this.getRawValue());
        twin.setLine(this.getLine());
        twin.setColumn(this.getColumn());
        return twin;
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

