/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.ltsutils;

import costo.graph.LTS;
import costo.graph.Label;
import costo.graph.State;
import costo.graph.Transition;
import costo.graph.expressions.KmlNopExpression;
import costo.graph.ltsutils.IStateAction;
import costo.graph.ltsutils.ITransitionAction;
import costo.graph.ltsutils.ITransitionPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;

public class LTSUtils {
    public static void removeMarks(LTS l, String mark) {
        for (State s : l.getStatesMap().values()) {
            s.setProperty(mark, null);
        }
    }

    public static Collection<State> getMarkedStates(LTS l, String mark) {
        ArrayList<State> list = new ArrayList<State>();
        for (State s : l.getStatesMap().values()) {
            if (s.getProperty(mark) == null) continue;
            list.add(s);
        }
        return list;
    }

    public static void extendFinals(LTS lts, State newFinal, Label newLabels) {
        if (lts == null) {
            return;
        }
        if (newFinal == null) {
            return;
        }
        for (State afinal : lts.getFinalStates()) {
            Transition t = new Transition(afinal, newFinal, newLabels.twin());
            lts.addTransition(t);
            afinal.addOutGoingTransition(t);
            newFinal.addInComingTransition(t);
        }
        ArrayList<State> finals = new ArrayList<State>();
        finals.add(newFinal);
        lts.setFinalStates(finals);
    }

    public static void prefixStates(LTS lts, String prefix) {
        HashMap<String, State> statesMap = lts.getStatesMap();
        ArrayList<State> states = new ArrayList<State>();
        states.addAll(statesMap.values());
        for (State element : states) {
            String baseName = element.getName();
            element.setName(String.valueOf(prefix) + baseName);
            statesMap.remove(baseName);
        }
        lts.addStates(states);
    }

    public static void insertLTSbetween(LTS initial, LTS inserted, State startingnode, State endingstate, Label startinglabel, Label endinglabel) {
        LTSUtils.extendFinals(inserted, endingstate, endinglabel);
        new Transition(startingnode, inserted.getInitialState(), startinglabel);
        initial.addStates((ArrayList)inserted.getStatesMap().values());
        initial.addTransitions(inserted.getTransitions());
    }

    public static void parcoursModify(LTS courant, IStateAction sa, ITransitionAction ta) {
        LTSUtils.parcoursrecModify(courant.getInitialState(), sa, ta);
    }

    public static void parcours(LTS courant, IStateAction sa, ITransitionAction ta, boolean order) {
        LTSUtils.parcoursrec(courant.getInitialState(), sa, ta, order);
    }

    public static void parcoursrec(State current_state, IStateAction sa, ITransitionAction ta, boolean order) {
        if (current_state.getProperty(sa.getMark()) != null) {
            return;
        }
        sa.doStuff(current_state);
        current_state.setProperty(sa.getMark(), "parcours");
        for (Transition t : order ? current_state.getOutGoingTransitions() : current_state.getInComingTransitions()) {
            ta.doStuff(t);
            LTSUtils.parcoursrec(order ? t.getTarget() : t.getSource(), sa, ta, order);
        }
    }

    public static void parcoursStop(LTS courant, IStateAction sa, ITransitionAction ta) {
        LTSUtils.parcoursrecStop(courant.getInitialState(), sa, ta);
    }

    public static void parcoursrecStop(State current_state, IStateAction sa, ITransitionAction ta) {
        if (current_state.getProperty(sa.getMark()) != null) {
            System.err.println(" #" + current_state.getName() + " deja vu");
            return;
        }
        sa.doStuff(current_state);
        current_state.setProperty(sa.getMark(), "parcours");
        for (Transition t : current_state.getOutGoingTransitions()) {
            ta.doStuff(t);
            LTSUtils.parcoursrecStop(t.getTarget(), sa, ta);
        }
    }

    public static void parcoursrecModify(State current_state, IStateAction sa, ITransitionAction ta) {
        if (current_state.getProperty(sa.getMark()) != null) {
            System.err.println(" #" + current_state.getName() + " deja vu");
            return;
        }
        sa.doStuff(current_state);
        current_state.setProperty(sa.getMark(), "parcours");
        int i = 0;
        while (i < current_state.getOutGoingTransitions().size()) {
            Transition t = current_state.getOutGoingTransitions().get(i);
            ta.doStuff(t);
            LTSUtils.parcoursrecModify(t.getTarget(), sa, ta);
            ++i;
        }
    }

    public static void eliminateNOPs(LTS lts) {
        boolean changes = true;
        ArrayList<State> states = new ArrayList<State>();
        System.out.println(lts.getTransitions());
        while (changes) {
            states.clear();
            states.addAll(lts.getStatesMap().values());
            changes = false;
            for (State s : states) {
                LTSUtils.removeNOPLoops(lts, s);
                if (!LTSUtils.removalAttempt(lts, s)) continue;
                changes = true;
                System.out.println("removing " + s);
                System.out.println(lts.getTransitions());
            }
        }
    }

    private static void removeNOPLoops(LTS lts, State s) {
        ArrayList<Transition> NOPloops = new ArrayList<Transition>();
        for (Transition t : s.getInComingTransitions()) {
            if (t.getSource() != s || !(t.getLabel().getExpression() instanceof KmlNopExpression)) continue;
            NOPloops.add(t);
        }
        for (Transition t : NOPloops) {
            lts.removeTransition(t);
        }
    }

    private static boolean removalAttempt(LTS lts, State s) {
        if (lts.getInitialState().equals(s)) {
            return false;
        }
        if (lts.getFinalStates().contains(s)) {
            return false;
        }
        if (LTSUtils.allNOPS(s.getInComingTransitions()) || LTSUtils.allNOPS(s.getOutGoingTransitions())) {
            ArrayList<Transition> newtrans = new ArrayList<Transition>();
            for (Transition inT : s.getInComingTransitions()) {
                for (Transition out : s.getOutGoingTransitions()) {
                    Transition bridge = new Transition(inT.getSource(), out.getTarget(), LTSUtils.mergeLabel(inT.getLabel(), out.getLabel()));
                    newtrans.add(bridge);
                }
            }
            for (Transition t : newtrans) {
                lts.addTransition(t);
                t.getSource().addOutGoingTransition(t);
                t.getTarget().addInComingTransition(t);
            }
            lts.removeState(s);
            return true;
        }
        return false;
    }

    private static Label mergeLabel(Label label, Label label2) {
        if (label.getExpression() instanceof KmlNopExpression) {
            return label2.twin();
        }
        return label.twin();
    }

    private static boolean allNOPS(LinkedList<Transition> transitions) {
        if (transitions == null) {
            return true;
        }
        for (Transition t : transitions) {
            if (t.getLabel().getExpression() instanceof KmlNopExpression) continue;
            return false;
        }
        return true;
    }

    public static void NOPifyTransitions(LTS lts, ITransitionPredicate ip) {
        for (Transition t : lts.getTransitions()) {
            if (!ip.checks(t)) continue;
            t.getLabel().setExpression(new KmlNopExpression());
        }
    }
}

