/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.Component;
import costo.graph.PromotedVariable;
import costo.graph.Variable;
import costo.graph.expressions.AbstractExpressionVisitor;
import costo.graph.expressions.KmlIdentifier;
import costo.graph.expressions.KmlTypedStuff;
import java.util.HashMap;

public class promotionVarAdapterVisitor
extends AbstractExpressionVisitor {
    private Component composite;
    private Component originComp;
    private HashMap<Variable, Variable> varMap;

    public promotionVarAdapterVisitor(Component comp, Component subcomp) {
        this.composite = comp;
        this.originComp = subcomp;
        this.varMap = new HashMap();
        for (Variable v : comp.getVariables().values()) {
            if (!(v instanceof PromotedVariable)) continue;
            this.varMap.put(((PromotedVariable)v).getOrigin(), v);
        }
    }

    @Override
    public void defaultExpressionOperation(KmlTypedStuff expr) {
    }

    @Override
    public boolean visit(KmlIdentifier expression) {
        Variable opt;
        Variable var = expression.getVar();
        if (var != null && (opt = this.varMap.get(var)) != null) {
            expression.setVar(opt);
        }
        return super.visit(expression);
    }

    public HashMap<Variable, Variable> getVarMap() {
        return this.varMap;
    }
}

