/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.types;

import costo.graph.KmlContext;
import costo.graph.types.AnyType;
import costo.graph.types.CostoRange;
import costo.graph.types.CostoType;

public class CostoArray
extends CostoType {
    public static final CostoArray instance = new CostoArray(AnyType.instance);
    protected CostoType reftype;
    protected CostoRange range;

    public CostoArray(CostoType reftype, CostoRange range) {
        this.reftype = reftype;
        this.range = range;
    }

    public CostoArray() {
    }

    public CostoArray(CostoType reftype) {
        this.reftype = reftype;
    }

    @Override
    public String getRawdescription() {
        return "array " + (this.range == null ? "[]" : this.range.getRawdescription()) + " of " + (this.reftype == null ? "null" : this.reftype.getRawdescription());
    }

    public CostoType getReftype() {
        return this.reftype;
    }

    public void setReftype(CostoType reftype) {
        this.reftype = reftype;
    }

    public void setReftype(String reftype) {
        this.reftype = new CostoType(reftype);
    }

    public CostoRange getRange() {
        return this.range;
    }

    public void setRange(CostoRange range) {
        this.range = range;
    }

    public int getBorneInf() {
        return this.range.getBorneInf();
    }

    public int getBorneSup() {
        return this.range.getBorneSup();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CostoArray)) {
            return false;
        }
        CostoArray other = (CostoArray)obj;
        return other.reftype == this.reftype;
    }

    @Override
    public boolean conformsTo(CostoType expected) {
        boolean ok = false;
        if (this.reftype == null) {
            return false;
        }
        try {
            CostoArray other = (CostoArray)expected;
            ok = this.reftype.conformsTo(other.getReftype());
        }
        catch (ClassCastException classCastException) {
            ok = false;
        }
        if (!ok) {
            ok = expected.isAssignableFrom(this);
        }
        return ok;
    }

    public boolean isInRange(int index) {
        return this.range.isInRange(index);
    }

    public boolean isInRange(String index) {
        return this.range.isInRange(index);
    }

    @Override
    public CostoType instanciatedWithType(CostoType lastType) {
        if (this.reftype == null) {
            return new CostoArray(this.reftype, this.range);
        }
        return new CostoArray(this.reftype.instanciatedWithType(lastType), this.range);
    }

    @Override
    public boolean resolve(KmlContext context) {
        return this.range.resolve(context);
    }
}

