/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.types;

import costo.graph.Variable;
import costo.graph.expressions.KmlIdentifier;
import costo.graph.types.CostoType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CostoEnum
extends CostoType {
    protected ArrayList<String> enums;

    public CostoEnum() {
    }

    public ArrayList<String> getEnums() {
        return this.enums;
    }

    public void setEnums(ArrayList<String> enums) {
        this.enums = enums;
        String raw = "enum {";
        Iterator<String> iterator = enums.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            raw = String.valueOf(raw) + string2;
            if (!iterator.hasNext()) continue;
            raw = String.valueOf(raw) + ", ";
        }
        this.setRawdescription(String.valueOf(raw) + "}");
    }

    public CostoEnum(ArrayList<String> enums) {
        this.setEnums(enums);
    }

    public CostoEnum(String name, ArrayList<String> enums) {
        super(name);
        this.setEnums(enums);
    }

    public Map<? extends String, ? extends Variable> generateConstants() {
        HashMap<String, Variable> vars = new HashMap<String, Variable>();
        for (String val : this.enums) {
            Variable enumvar = new Variable(val, this, true);
            enumvar.setObservable(true);
            KmlIdentifier value = new KmlIdentifier();
            value.setRawValue(val);
            value.setVar(enumvar);
            value.setType(this);
            enumvar.setExpression(value);
            vars.put(val.trim(), enumvar);
        }
        return vars;
    }
}

