/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.visitors;

import costo.graph.Variable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class VariableUsage {
    private HashSet<Variable> modifiedVarlist = new HashSet();
    private HashSet<Variable> readVarlist = new HashSet();
    private HashMap<Variable, HashSet<Variable>> dependencies = new HashMap();

    public VariableUsage() {
    }

    public VariableUsage(HashSet<Variable> modifiedVarlist, HashSet<Variable> readVarlist) {
        this.modifiedVarlist = modifiedVarlist;
        this.readVarlist = readVarlist;
    }

    public HashSet<Variable> getModifiedVarlist() {
        return this.modifiedVarlist;
    }

    public void setModifiedVarlist(HashSet<Variable> modifiedVarlist) {
        this.modifiedVarlist = modifiedVarlist;
    }

    public HashSet<Variable> getReadVarlist() {
        return this.readVarlist;
    }

    public void setReadVarlist(HashSet<Variable> readVarlist) {
        this.readVarlist = readVarlist;
    }

    public void addDependency(Variable modified, Variable read) {
        HashSet<Variable> deps = this.dependencies.get(modified);
        if (deps == null) {
            deps = new HashSet();
        }
        if (read != null) {
            deps.add(read);
        }
        this.dependencies.put(modified, deps);
    }

    public void addDependencies(Variable modified, HashSet<Variable> read) {
        HashSet<Variable> deps = this.dependencies.get(modified);
        if (deps == null) {
            deps = new HashSet();
        }
        deps.addAll(read);
        this.dependencies.put(modified, deps);
    }

    public void add(VariableUsage other) {
        this.modifiedVarlist.addAll(other.modifiedVarlist);
        this.readVarlist.addAll(other.readVarlist);
        for (Map.Entry<Variable, HashSet<Variable>> dep : other.dependencies.entrySet()) {
            this.addDependencies(dep.getKey(), dep.getValue());
        }
    }

    public String toString() {
        return "VariableUsage [modifiedVarlist=" + this.modifiedVarlist + ", readVarlist=" + this.readVarlist + "]";
    }

    public HashMap<Variable, HashSet<Variable>> getDependencies() {
        return this.dependencies;
    }
}

