/*
 * Decompiled with CFR 0.152.
 */
package costo.utils.query;

import costo.graph.Label;
import costo.graph.Transition;
import costo.utils.query.ElementMatcher;

public class LabelTransitionMatcher<T extends Transition>
implements ElementMatcher<T> {
    private Label referent;
    private int style = 1;
    public static final int RAWLABEL = 1;
    public static final int CHANNEL = 2;
    public static final int ACTIONTYPE = 4;

    public LabelTransitionMatcher(Label referent) {
        this.referent = referent;
    }

    public LabelTransitionMatcher(Label referent, int style) {
        this.referent = referent;
        this.style = style;
    }

    public LabelTransitionMatcher() {
    }

    @Override
    public boolean matches(T t) {
        if (t == null) {
            return false;
        }
        Label l = ((Transition)t).getLabel();
        boolean matches = true;
        if (!(matches &= (this.style & 1) == 0 || l.getRawLabel().equals(this.referent.getRawLabel()))) {
            return false;
        }
        if (!(matches &= (this.style & 2) == 0 || l.getChannel().equals(this.referent.getChannel()))) {
            return false;
        }
        return matches &= (this.style & 4) == 0 || l.getActionType() == this.referent.getActionType();
    }

    public Label getReferent() {
        return this.referent;
    }

    public void setReferent(Label referent) {
        this.referent = referent;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }
}

