/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_kml_test.chaine;

import costo.graph.ComponentFactory;
import costo.graph.ComponentVariable;
import costo.graph.CostoLibrary;
import costo.graph.ServiceIdentifier;
import costo.graph.Variable;
import costolib.ui.Activator;
import costolib_plugin_kml_test.chaine.ITComponent;
import costolib_plugin_kml_test.chaine.TComponent;
import costolib_plugin_kml_test.chaine.TService;
import costolib_plugin_kml_test.chaine.TUtile;
import costolib_plugin_kml_test.utils.JCompositeServSelector;
import costolib_plugin_kml_test.utils.TestIntentionControlPanel;
import costolib_plugin_kml_test.utils.TestPerimeterPanel;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class THarness
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public costo.graph.Component intention = null;
    public costo.graph.Component component = null;
    costo.graph.Component rootCUT;
    private TestPerimeterPanel perimeterPanel;
    TestIntentionControlPanel intentionPanel;
    private JMenuItem itmGenerat = null;
    protected JTabbedPane tabPanel = new JTabbedPane();
    List<ITComponent> tcomponentsUsed = new ArrayList<ITComponent>();
    Set<String> costoLibs = new TreeSet<String>();
    private String intentionFolder = "";
    private String dataFolder = "";
    private String thFileName = "";
    private String testerFileName = "";

    public THarness(costo.graph.Component comp) {
        if (comp == null || !comp.isIntention()) {
            JOptionPane.showMessageDialog(this, "Can not genearte test harness.\nPlease choose a test intention file.", "File type error", 0);
            return;
        }
        this.intention = comp;
        this.initialize();
        this.setTitle("Test Harness Creating Process ");
        this.setLayout(new BorderLayout());
        this.createNorthInfoZone();
        this.setJMenuBar(this.createMenuBar());
        this.perimeterPanel = new TestPerimeterPanel(null);
        this.add((Component)this.perimeterPanel, "South");
        this.add((Component)this.tabPanel, "Center");
        this.setDefaultCloseOperation(2);
        TUtile.init(this, this.intention, this.perimeterPanel);
    }

    private void initialize() {
        this.thFileName = "TH_" + this.intention.getName();
        this.testerFileName = "TESTER_" + this.intention.getName();
        String intentionPath = this.intention.getFactory().getAbsSpecDir();
        this.intentionFolder = String.valueOf(intentionPath) + File.separator + this.intention.getName();
        File dir = new File(this.intentionFolder);
        if (!dir.isDirectory() && !dir.mkdir()) {
            JOptionPane.showMessageDialog(this, "Can't create intention directory!\nHarness construction stopped.", "Errors", 0);
            return;
        }
        this.dataFolder = String.valueOf(this.intentionFolder) + File.separator + "data";
        dir = new File(this.dataFolder);
        if (!dir.isDirectory() && !dir.mkdir()) {
            JOptionPane.showMessageDialog(this, "Can't create data directory!", "Errors", 0);
            return;
        }
    }

    private void createNorthInfoZone() {
        this.intentionPanel = new TestIntentionControlPanel(this.intention);
        this.add((Component)this.intentionPanel, "North");
        TUtile.intentionPanel = this.intentionPanel;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Harness");
        menu.setMnemonic(72);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Select Target");
        menuItem.setMnemonic(83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        menuItem.setActionCommand("select");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Check concrete Mappings");
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        menuItem.setActionCommand("checkMappings");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Generate ");
        menuItem.setMnemonic(71);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(71, 8));
        menuItem.setActionCommand("generate");
        menuItem.setEnabled(false);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.itmGenerat = menuItem;
        menuItem = new JMenuItem("quit");
        menuItem.setMnemonic(81);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        menuItem.setActionCommand("quit");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        return menuBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("select".equals(e.getActionCommand())) {
            this.select();
            return;
        }
        if ("quit".equals(e.getActionCommand())) {
            System.exit(0);
            return;
        }
        if ("generate".equals(e.getActionCommand())) {
            this.generateHarness();
        } else {
            "checkMappings".equals(e.getActionCommand());
        }
    }

    private void generateHarness() {
        this.tcomponentsUsed = new ArrayList<ITComponent>();
        if (!this.setLinks()) {
            return;
        }
        this.costoLibs.add("PLATOONTESTLIB");
        String libs = "";
        for (String lib : this.costoLibs) {
            if (!libs.isEmpty()) {
                libs = String.valueOf(libs) + ", ";
            }
            libs = String.valueOf(libs) + lib;
        }
        if (TUtile.sut.getResult() == null) {
            Variable result = new Variable(String.valueOf(TUtile.sut.getService().getName().toLowerCase()) + "_sut", TUtile.sut.getService().getReturnCostoType(), true);
            TUtile.sut.setResult(result);
        }
        this.generateTHFile(libs);
        this.generateTesterFile(libs);
        this.generateMockFiles(libs);
        this.generateVariables();
        this.copyFoldersAndFiles();
    }

    public boolean setLinks() {
        System.out.println("** Setting all links Harness **");
        TUtile.assemblies = new ArrayList<Map<String, String>>();
        ArrayList myList = new ArrayList(this.rootCUT.getLibraries());
        this.tcomponentsUsed = new ArrayList<ITComponent>();
        for (ITComponent tcomp : TUtile.tcomponents) {
            if (!tcomp.isVisible() || tcomp.getProvided().isEmpty() && tcomp.getRequired().isEmpty()) continue;
            if (!tcomp.isAssigned()) {
                JOptionPane.showMessageDialog(this, "Can not genearte test harness.\n [" + tcomp.getCompVar().getVarName() + "] assigments not correctly done.", "Mappings errors", 0);
            }
            tcomp.setConf();
            if (tcomp.getLinks() != null && !tcomp.getLinks().isEmpty()) {
                TUtile.assemblies.addAll(tcomp.getLinks());
            }
            this.tcomponentsUsed.add(tcomp);
            if (tcomp.isMock()) continue;
            myList.addAll(tcomp.getCompVar().getComponentType().getLibraries());
        }
        for (CostoLibrary lib : myList) {
            this.costoLibs.add(lib.getName());
        }
        return true;
    }

    private void generateMockFiles(String libs) {
        for (ITComponent tcomp : TUtile.tcomponents) {
            if (!tcomp.isVisible() || !tcomp.isMock()) continue;
            String path = String.valueOf(this.intentionFolder) + File.separator + tcomp.getCompVar().getTypeName() + ".kcp";
            System.out.println("path:" + path);
            File file = new File(path);
            if (file.exists()) {
                return;
            }
            SimpleHash modelRoot = new SimpleHash();
            modelRoot.put("libs_used", (Object)libs);
            modelRoot.put("mock", (Object)tcomp);
            try {
                Configuration config = new Configuration();
                config.setClassForTemplateLoading(this.getClass(), "templates");
                Template tempmodel = config.getTemplate("TMock.ftl");
                FileWriter out = new FileWriter(path);
                tempmodel.process((Object)modelRoot, (Writer)out);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void generateTesterFile(String libs) {
        String testcase = "testcase1";
        SimpleHash modelRoot = new SimpleHash();
        modelRoot.put("tester_name", (Object)this.testerFileName);
        modelRoot.put("intention", (Object)TUtile.intention);
        modelRoot.put("costoLibs", (Object)libs);
        modelRoot.put("mocks", TUtile.mocks);
        modelRoot.put("sut", (Object)TUtile.sut);
        modelRoot.put("oracleVariables", TUtile.oracleVariables);
        modelRoot.put("outputAssignments", TUtile.outputAssignments);
        modelRoot.put("testcase", (Object)testcase);
        try {
            Configuration config = new Configuration();
            config.setClassForTemplateLoading(this.getClass(), "templates");
            Template tempmodel = config.getTemplate("ComponentTester.ftl");
            String path = String.valueOf(this.intentionFolder) + File.separator + this.testerFileName + ".kcp";
            FileWriter out = new FileWriter(path);
            tempmodel.process((Object)modelRoot, (Writer)out);
            JOptionPane.showMessageDialog(this, "Generarion successfully finished.\nFile generated: " + path, "Finished", 1);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Generarion failled", "Finished", 0);
            ex.printStackTrace();
        }
    }

    private void generateTHFile(String libs) {
        SimpleHash modelRoot = new SimpleHash();
        modelRoot.put("tester_name", (Object)this.testerFileName);
        modelRoot.put("intention", (Object)TUtile.intention);
        modelRoot.put("tcomponents", this.tcomponentsUsed);
        modelRoot.put("costoLibs", (Object)libs);
        modelRoot.put("mocks", TUtile.mocks);
        modelRoot.put("cut", (Object)TUtile.cut);
        modelRoot.put("sut", (Object)TUtile.sut);
        modelRoot.put("inputVars", TUtile.intentionPanel.getInputVarsAssignment());
        modelRoot.put("outputVars", TUtile.intentionPanel.getOutputVarsAssignment());
        modelRoot.put("assemblies", TUtile.assemblies);
        try {
            Configuration config = new Configuration();
            config.setClassForTemplateLoading(this.getClass(), "templates");
            Template tempmodel = config.getTemplate("THarness.ftl");
            String path = String.valueOf(this.intentionFolder) + File.separator + this.thFileName + ".kcp";
            FileWriter out = new FileWriter(path);
            tempmodel.process((Object)modelRoot, (Writer)out);
            JOptionPane.showMessageDialog(this, "Generarion successfully finished.\nFile generated: " + path, "Finished", 1);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Generarion failled", "Finished", 0);
            ex.printStackTrace();
        }
    }

    private void generateVariables() {
        System.out.println("****** generateVariables START *********");
        ArrayList variables = new ArrayList();
        HashMap<String, String> varStr = null;
        ArrayList<String> varsUsed = new ArrayList<String>();
        for (Variable var : TUtile.intentionPanel.getInputVarsAssignment().keySet()) {
            if (varsUsed.contains(var.getName())) continue;
            varsUsed.add(var.getName());
            varStr = new HashMap<String, String>();
            varStr.put("vname", var.getName());
            varStr.put("vtype", var.getType());
            variables.add(varStr);
        }
        for (Variable var : TUtile.oracleVariables.values()) {
            if (TUtile.inOutvarsUsed.contains(var) || varsUsed.contains(var.getName())) continue;
            varsUsed.add(var.getName());
            varStr = new HashMap();
            varStr.put("vname", var.getName());
            varStr.put("vtype", var.getType());
            variables.add(varStr);
        }
        String path = String.valueOf(this.dataFolder) + File.separator + this.thFileName + ".properties";
        SimpleHash modelRoot = new SimpleHash();
        modelRoot.put("component_vars", variables);
        modelRoot.put("component_name", (Object)this.rootCUT.getName());
        try {
            Configuration config = new Configuration();
            config.setClassForTemplateLoading(this.getClass(), "templates");
            Template tempmodel = config.getTemplate("component_variables.ftl");
            FileWriter out = new FileWriter(path);
            tempmodel.process((Object)modelRoot, (Writer)out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("****** generateVariables END *********");
    }

    private void copyFoldersAndFiles() {
        for (String libName : this.costoLibs) {
            String pathLib = String.valueOf(this.rootCUT.getFactory().getAbsSpecDir()) + File.separator + libName;
            File dirLib = new File(pathLib);
            if (!dirLib.isDirectory()) continue;
            try {
                File destDir = new File(String.valueOf(this.intentionFolder) + File.separator + libName);
                if (!destDir.isDirectory()) {
                    destDir.mkdir();
                }
                TUtile.copyFolder(dirLib, destDir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (ITComponent tcomp : TUtile.tcomponents) {
            if (!tcomp.isVisible() || tcomp.isMock()) continue;
            String pathCompfile = String.valueOf(tcomp.getCompVar().getComponentType().getFactory().getAbsSpecDir()) + File.separator + tcomp.getCompVar().getComponentType().getName() + ".kcp";
            File cmpFile = new File(pathCompfile);
            File dstFile = new File(String.valueOf(this.intentionFolder) + File.separator + tcomp.getCompVar().getComponentType().getName() + ".kcp");
            if (cmpFile.isFile() && !dstFile.exists()) {
                try {
                    TUtile.copyFolder(cmpFile, dstFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println(cmpFile + " is not a file");
        }
    }

    private void select() {
        if (this.rootCUT == null) {
            this.rootCUT = this.selectCUT();
        }
        if (this.rootCUT == null) {
            return;
        }
        this.itmGenerat.setEnabled(true);
        JCompositeServSelector selector = new JCompositeServSelector(this.rootCUT);
        ArrayList<JCompositeServSelector> complist = new ArrayList<JCompositeServSelector>();
        complist.add(selector);
        JOptionPane.showMessageDialog(this, complist.toArray(), "select target service", 3);
        ArrayList<ServiceIdentifier> selectedServices = selector.getSelected();
        if (selectedServices == null || selectedServices.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Can not continue harness processing.\nPlease choose Service to Test.", "SUT error", 0);
            return;
        }
        TUtile.sut = new TService((ServiceIdentifier)selectedServices.get(0), TUtile.cut);
        this.setComponentsList(selector.getSubcomplist());
        TUtile.sut.settOwner(TUtile.cut);
        TUtile.cut.addProvided(TUtile.sut);
        this.displayCenter();
    }

    private void displayCenter() {
        TUtile.cut.setVisible(true);
        TUtile.perimeterPanel.complist.setText(String.valueOf(TUtile.sut.getSid().getCompVar().toString()) + "[" + TUtile.sut.getSid().getServiceName() + "]");
        this.pack();
    }

    private costo.graph.Component selectCUT() {
        JFileChooser fd = new JFileChooser(this.intention.getFilePath());
        int ret = fd.showOpenDialog(this);
        if (ret == 1) {
            return null;
        }
        File file = fd.getSelectedFile();
        String compname = file.getName();
        String abspath = file.getParent();
        ComponentFactory cf = null;
        try {
            cf = Activator.getDefault().getComponentFactory(abspath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        costo.graph.Component comp = cf.getComponent(compname);
        return comp;
    }

    private void setComponentsList(List<ComponentVariable> complist) {
        if (complist == null) {
            return;
        }
        for (ComponentVariable compVar : complist) {
            compVar.getComponentType();
            TComponent tcomp = new TComponent(compVar);
            if (tcomp.getCompVar().getVarName().equals(TUtile.sut.getSid().getCompVar().getVarName())) {
                tcomp.getCompVar().setVarName(String.valueOf(tcomp.getCompVar().getVarName()) + "_cut");
                TUtile.cut = tcomp;
            }
            TUtile.tcomponents.add(tcomp);
        }
    }

    public boolean checkOracleVars() {
        return false;
    }
}

