/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_kml_test.chaine;

import costo.graph.ComponentVariable;
import costo.graph.ServiceIdentifier;
import costo.graph.Variable;
import costo.graph.types.CostoType;
import costolib_plugin_kml_test.chaine.ITComponent;
import costolib_plugin_kml_test.chaine.TService;
import costolib_plugin_kml_test.chaine.TUtile;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TMock
implements ITComponent {
    private boolean isCut = false;
    private ComponentVariable compVar = null;
    private List<TService> required = new ArrayList<TService>();
    private List<TService> provided = new ArrayList<TService>();
    protected JPanel view = new JPanel();
    protected JPanel reqview = new JPanel();
    protected JPanel provview = new JPanel();
    private String conf = "";
    private CostoType type = null;
    private Map<Variable, Variable> compParams = new HashMap<Variable, Variable>();
    private boolean visible = false;

    public TMock(ComponentVariable comp, CostoType type) {
        this.compVar = comp;
        this.type = type;
        this.reqview.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "All Required Services"));
        this.reqview.setLayout(new GridLayout(0, 3, 10, 10));
        this.provview.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "All Provided Services"));
        this.provview.setLayout(new BoxLayout(this.provview, 1));
    }

    public JPanel getCompVarPanel() {
        ArrayList<Variable> compvars = new ArrayList<Variable>();
        Variable valueVar = new Variable("value", this.type);
        valueVar.setType(this.type.getName());
        compvars.add(valueVar);
        JPanel compvarspanel = new JPanel();
        if (compvars != null && !compvars.isEmpty()) {
            compvarspanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Component State"));
            compvarspanel.setLayout(new GridLayout(0, 3, 10, 10));
            final ServiceIdentifier called = null;
            for (final Variable var : compvars) {
                this.compParams.put(var, null);
                final JButton assignButton = new JButton("unassigned");
                final JButton varsetterButton = new JButton("assign Setter");
                assignButton.setName(var.getName());
                assignButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Variable absvar = TUtile.selectInputVariableToAssign(var);
                        if (absvar == null) {
                            return;
                        }
                        if (absvar.getName().startsWith("New Input Variable")) {
                            System.out.println("Must create new variable");
                            TUtile.intentionPanel.createNewInputVariable(absvar);
                        }
                        TUtile.intentionPanel.assignStateVar(absvar, var, called);
                        assignButton.setText(absvar.getName());
                        if (!absvar.getName().equals("unassigned")) {
                            TMock.this.compParams.put(var, absvar);
                            varsetterButton.setEnabled(true);
                        } else {
                            TMock.this.compParams.put(var, null);
                            varsetterButton.setEnabled(false);
                        }
                        TUtile.evaluateStateAssigments();
                    }
                });
                compvarspanel.add(assignButton);
                compvarspanel.add(new JLabel(var.toString()));
                varsetterButton.setEnabled(false);
                varsetterButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                });
                compvarspanel.add(varsetterButton);
            }
        }
        return compvarspanel;
    }

    @Override
    public void setView() {
        this.view.setLayout(new BoxLayout(this.view, 1));
        this.view.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Variable assignment for service " + this.compVar.getTypeName()));
        this.view.add(this.getCompVarPanel());
        this.view.add(this.provview);
    }

    @Override
    public void setConf() {
        this.conf = "";
        for (Variable var : this.compParams.keySet()) {
            System.out.println("Var" + var.getName());
            if (!this.conf.isEmpty()) {
                this.conf = String.valueOf(this.conf) + ", ";
            }
            String val = "";
            if (this.compParams.get(var) != null) {
                val = this.compParams.get(var).getName();
            }
            this.conf = String.valueOf(this.conf) + val;
        }
        if (!this.conf.isEmpty()) {
            this.conf = String.valueOf(this.compVar.getVarName()) + ".conf(" + this.conf + ")";
        }
    }

    @Override
    public ComponentVariable getCompVar() {
        return this.compVar;
    }

    @Override
    public boolean isAssigned() {
        System.out.println("Checking " + this.compVar.getVarName());
        System.out.println("* All parameters *");
        for (Variable var : this.compParams.keySet()) {
            if (this.compParams.get(var) != null) continue;
            return false;
        }
        System.out.println("* All provided *");
        for (TService tserv : this.provided) {
            if (tserv.isAssigned()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Map<String, String>> getLinks() {
        System.out.println("* TMOCK All required Links *");
        ArrayList<Map<String, String>> links = new ArrayList<Map<String, String>>();
        for (TService tserv : this.required) {
            links.add(tserv.getLink());
        }
        return links;
    }

    @Override
    public void setCut(boolean isCut) {
        this.isCut = false;
    }

    @Override
    public boolean isCut() {
        return this.isCut;
    }

    @Override
    public void setConf(String conf) {
    }

    @Override
    public String getConf() {
        return this.conf;
    }

    @Override
    public List<TService> getProvided() {
        return this.provided;
    }

    @Override
    public List<TService> getRequired() {
        return this.required;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            TUtile.frame.tabPanel.addTab(this.getCompVar().getVarName(), new JScrollPane(this.view));
            this.setView();
        }
        this.visible = visible;
    }

    @Override
    public void addProvided(TService tserv) {
        if (!this.provided.contains(tserv)) {
            this.provided.add(tserv);
            this.provview.add(tserv.getMockProvPanel());
            System.out.println("tmock addprovided ****");
        }
    }

    @Override
    public int getTotalToAssign() {
        return 1;
    }

    @Override
    public int getTotalAssigned() {
        int total = 0;
        for (Variable var : this.compParams.keySet()) {
            if (this.compParams.get(var) == null) continue;
            ++total;
        }
        if (this.provided != null) {
            for (TService tserv : this.provided) {
                if (tserv.getServParams() == null) continue;
                for (String key : tserv.getServParams().keySet()) {
                    if (tserv.getServParams().get(key) == null) continue;
                    ++total;
                }
            }
        }
        return total;
    }

    @Override
    public void removeProvided(TService tserv) {
        this.provided.remove(tserv);
    }

    @Override
    public boolean isMock() {
        return true;
    }

    public CostoType getType() {
        return this.type;
    }

    public void setType(CostoType type) {
        this.type = type;
    }
}

