/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_kml_test.popup.actions;

import costo.graph.Assembly;
import costo.graph.Component;
import costo.graph.ComponentInterface;
import costo.graph.ComponentVariable;
import costo.graph.Composition;
import costolib.ui.utils.PopupActionOnComponent;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class CreateTestAction
extends PopupActionOnComponent {
    public void run(IAction action) {
        Component cwt;
        Component cut = this.getSelectedComponent();
        String name = new String(cut.getName());
        String fp = new String(cut.getFilePath());
        if (cut.isAppli()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"COSTOLIB_PLUGIN_KML_TEST", (String)("Generate KML test environment for application " + this.getSelectedComponent().getName() + " is coming soon"));
            cwt = cut.shallowCopy(String.valueOf(name) + "_TestApplication");
            System.out.println("name is " + cwt.getName());
            fp = fp.replaceFirst(String.valueOf(name) + ".kcp", String.valueOf(name) + "_TestApplication.kcp");
            System.out.println("File path is " + fp);
            cwt.setFilePath(fp);
            cwt.setComment("Costo generated test environement for " + name + "\n" + cwt.getComment());
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"COSTOLIB_PLUGIN_KML_TEST", (String)("Generate KML unit test environment for component " + this.getSelectedComponent().getName() + " is coming soon"));
            cwt = new Component(String.valueOf(name) + "_UnitTestApplication");
            fp = fp.replaceFirst(".kcp", "_UnitTestApplication.kcp");
            System.out.println("File path is " + fp);
            cwt.setAppli(true);
            cwt.setComment("Costo generated test environement for " + name);
            cwt.setFilePath(fp);
            cwt.setFactory(cut.getFactory());
            cwt.setLogger(cut.getLogger());
            cwt.setInterface(new ComponentInterface());
            Composition cwtcp = new Composition();
            cwtcp.setComment("Auto generated composition to test the component " + name);
            cwtcp.setOwner(cwt);
            Assembly cwtass = new Assembly();
            cwtass.setName(null);
            cwtass.setContext(cwt.getFactory());
            cwtass.setFilePath(fp);
            ComponentVariable cv = new ComponentVariable("cut", cut.getName(), 0, 0);
            ArrayList<ComponentVariable> namedComponents = new ArrayList<ComponentVariable>();
            namedComponents.add(cv);
            cwtass.setNamedComponents(namedComponents);
            cwtass.setOwner(cwt);
            cwtcp.setAssembly(cwtass);
            cwt.setComposition(cwtcp);
        }
        try {
            this.generateTestApplicationFile(cwt);
        }
        catch (IOException e) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"COSTOLIB_PLUGIN_KML_TEST", (String)("GenerateKMLtest failed for" + this.getSelectedComponent().getName()));
            e.printStackTrace();
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)"COSTOLIB_PLUGIN_KML_TEST", (String)("GenerateKMLtest was executed for" + this.getSelectedComponent().getName()));
    }

    protected void generateTestApplicationFile(Component cwt) throws IOException {
        String filename = cwt.getFilePath();
        FileWriter file = new FileWriter(filename);
        file.write(cwt.toString());
        file.close();
    }
}

