/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_kml_test.utils;

import costo.graph.ComponentFactory;
import costo.graph.CostoLibrary;
import costo.graph.KmlContext;
import costo.graph.Link;
import costo.graph.Service;
import costo.graph.ServiceIdentifier;
import costo.graph.Variable;
import costo.graph.types.CostoType;
import costo.graph.types.CostoVoid;
import costo.graph.visitors.KmlElementVisitor;
import costo.graph.visitors.VariableUsage;
import costo.graph.visitors.VariableUsageComponentVisitor;
import costolib.ui.Activator;
import costolib_plugin_kml_test.chaine.TUtile;
import costolib_plugin_kml_test.utils.JCheckPanel;
import costolib_plugin_kml_test.utils.JCompositeServSelector;
import costolib_plugin_kml_test.utils.JRequiredAssignmentPanel;
import costolib_plugin_kml_test.utils.TestIntentionControlPanel;
import costolib_plugin_kml_test.utils.TestPerimeterPanel;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class NewTestHarnessCreatingProcessFrame
extends JFrame
implements ActionListener {
    costo.graph.Component rootCUT;
    costo.graph.Component intention;
    private List<ServiceIdentifier> selectedServices = null;
    Service selectedService = null;
    private ComponentFactory f = new ComponentFactory();
    private ArrayList<Variable> statevariabledata;
    protected Map<Variable, Object> usedVariables = new HashMap<Variable, Object>();
    protected Map<String, String> mocksVar = new HashMap<String, String>();
    protected Map<Service, Object> usedServices = new HashMap<Service, Object>();
    private JRequiredAssignmentPanel requiredAssignment;
    private Map<String, Service> callableserviceInfoMap = new HashMap<String, Service>();
    private Map<String, Service> configserviceInfoMap = new HashMap<String, Service>();
    private Map<Variable, Variable> abstrToParams = new HashMap<Variable, Variable>();
    private Map<Variable, Variable> abstrToState = new HashMap<Variable, Variable>();
    Map<Variable, JButton> abstrToJButton = new HashMap<Variable, JButton>();
    private TestPerimeterPanel perimeterPanel;
    TestIntentionControlPanel intentionPanel;
    private JMenuItem itmGenerat = null;
    ArrayList<Variable> compvars = null;

    public NewTestHarnessCreatingProcessFrame(costo.graph.Component comp) {
        if (comp == null || !comp.isIntention()) {
            JOptionPane.showMessageDialog(null, "Can not genearte test harness.\nPlease choose a test intention file.", "File type error", 0);
            return;
        }
        this.intention = comp;
        TUtile.intention = this.intention;
        this.setTitle("Test Harness Creating Process ");
        this.setLayout(new BorderLayout());
        this.createNorthInfoZone();
        this.setJMenuBar(this.createMenuBar());
        this.perimeterPanel = new TestPerimeterPanel(null);
        this.add((Component)this.perimeterPanel, "South");
        this.setDefaultCloseOperation(2);
    }

    private void createNorthInfoZone() {
        this.intentionPanel = new TestIntentionControlPanel(this.intention);
        this.add((Component)this.intentionPanel, "North");
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Harness");
        menu.setMnemonic(72);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Select Target");
        menuItem.setMnemonic(83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        menuItem.setActionCommand("select");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Check concrete Mappings");
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        menuItem.setActionCommand("checkMappings");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Generate ");
        menuItem.setMnemonic(71);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(71, 8));
        menuItem.setActionCommand("generate");
        menuItem.setEnabled(false);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.itmGenerat = menuItem;
        menuItem = new JMenuItem("quit");
        menuItem.setMnemonic(81);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        menuItem.setActionCommand("quit");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        return menuBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("select".equals(e.getActionCommand())) {
            this.select();
            return;
        }
        if ("quit".equals(e.getActionCommand())) {
            System.out.println("quit");
            this.quit();
            return;
        }
        if ("generate".equals(e.getActionCommand())) {
            this.generateTestHarness();
        }
    }

    private void select() {
        if (this.rootCUT == null) {
            this.rootCUT = this.selectCUT();
        }
        if (this.rootCUT == null) {
            return;
        }
        this.itmGenerat.setEnabled(true);
        JCompositeServSelector selector = new JCompositeServSelector(this.rootCUT);
        ArrayList<JCompositeServSelector> complist = new ArrayList<JCompositeServSelector>();
        complist.add(selector);
        JOptionPane.showMessageDialog(null, complist.toArray(), "select target service", 3);
        this.selectedServices = selector.getSelected();
        if (this.selectedServices == null || this.selectedServices.isEmpty()) {
            JOptionPane.showMessageDialog(null, "Can not continue harness processing.\nPlease choose Service to Test.", "SUT error", 0);
            return;
        }
        this.selectedService = this.selectedServices.get(0).getServ();
        this.intentionPanel.setSuts(this.selectedServices);
        this.perimeterPanel.add(this.selectedServices.get(0).getCompVar());
        this.assign();
    }

    public Variable selectVariableToAssign(ArrayList<Variable> varlist, String target) {
        if (this.intention == null) {
            return null;
        }
        Object[] tablo = new Variable[1];
        tablo = varlist.toArray(tablo);
        Variable var = (Variable)JOptionPane.showInputDialog(this, "Select the abstract variable to assign to " + target, "Assign to " + target, -1, null, tablo, tablo[0]);
        System.out.println(var);
        return var;
    }

    private void assign() {
        if (this.selectedService == null) {
            return;
        }
        JPanel assignPanel = new JPanel();
        assignPanel.setLayout(new BoxLayout(assignPanel, 1));
        assignPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Variable assignment for service " + this.getSelectedServiceId().toString()));
        this.createParamAssignPanel(assignPanel);
        this.selectedService.accept((KmlElementVisitor)new VariableUsageComponentVisitor((KmlContext)this.selectedService));
        VariableUsage varusage = (VariableUsage)this.selectedService.getProperty("variablevisit");
        this.compvars = new ArrayList();
        HashSet readVarlist = varusage.getReadVarlist();
        if (readVarlist != null) {
            for (Variable v : readVarlist) {
                if (v == null || v.getDeclarationContext() == null || !v.getDeclarationContext().equals(this.selectedService.getOwner())) continue;
                this.compvars.add(v);
            }
        }
        this.createCompVarPanel(assignPanel, this.compvars);
        JPanel extvarPanel = new JPanel();
        extvarPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "External Data"));
        extvarPanel.setLayout(new GridLayout(0, 2, 10, 10));
        ArrayList<Variable> extdata = new ArrayList<Variable>();
        ArrayList required = this.selectedService.getRequired();
        if (required != null) {
            for (Service s : required) {
                CostoType returnCType = s.getReturnCostoType();
                if (returnCType == null || returnCType == CostoVoid.instance) continue;
                extdata.add(new Variable(s.getName(), returnCType));
            }
        }
        this.requiredAssignment = new JRequiredAssignmentPanel(this.getSelectedServiceId(), this);
        assignPanel.add(this.requiredAssignment);
        JScrollPane sp = new JScrollPane(assignPanel);
        this.add((Component)sp, "Center");
        this.pack();
    }

    private void createCompVarPanel(JPanel assignPanel, ArrayList<Variable> compvars) {
        JPanel compvarspanel = new JPanel();
        if (compvars != null && !compvars.isEmpty()) {
            compvarspanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Component State"));
            compvarspanel.setLayout(new GridLayout(0, 3, 10, 10));
            final ServiceIdentifier called = this.getSelectedServiceId();
            for (final Variable var : compvars) {
                final JButton assignButton = new JButton("unassigned");
                final JButton varsetterButton = new JButton("assign Setter");
                assignButton.setName(var.getName());
                this.usedVariables.put(var, null);
                assignButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JButton existingJButton;
                        Variable absvar = TUtile.selectInputVariableToAssign(var);
                        if (absvar == null) {
                            return;
                        }
                        if (absvar.getName().startsWith("New Input Variable")) {
                            System.out.println("Must create new variable");
                            NewTestHarnessCreatingProcessFrame.this.intentionPanel.createNewInputVariable(absvar);
                        }
                        if ((existingJButton = NewTestHarnessCreatingProcessFrame.this.abstrToJButton.get(absvar)) != null) {
                            existingJButton.setText("unassigned");
                        }
                        NewTestHarnessCreatingProcessFrame.this.abstrToJButton.put(absvar, assignButton);
                        NewTestHarnessCreatingProcessFrame.this.abstrToState.put(absvar, var);
                        NewTestHarnessCreatingProcessFrame.this.intentionPanel.assignStateVar(absvar, var, called);
                        assignButton.setText(absvar.getName());
                        if (!absvar.getName().equals("unassigned")) {
                            varsetterButton.setEnabled(true);
                        } else {
                            varsetterButton.setEnabled(false);
                        }
                        String srvName = ((JButton)e.getSource()).getName();
                        for (Variable vr : NewTestHarnessCreatingProcessFrame.this.usedVariables.keySet()) {
                            if (!vr.getName().equals(srvName)) continue;
                            NewTestHarnessCreatingProcessFrame.this.usedVariables.put(vr, absvar);
                            break;
                        }
                    }
                });
                compvarspanel.add(assignButton);
                compvarspanel.add(new JLabel(var.toString()));
                varsetterButton.setEnabled(false);
                varsetterButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NewTestHarnessCreatingProcessFrame.this.assignStateVarSetter();
                    }
                });
                compvarspanel.add(varsetterButton);
            }
            assignPanel.add(compvarspanel);
        }
    }

    private void createParamAssignPanel(JPanel assignPanel) {
        ArrayList params = this.selectedService.getParameters();
        final ServiceIdentifier called = this.getSelectedServiceId();
        params.add(this.selectedService.getResultVar());
        if (params != null && !params.isEmpty()) {
            JPanel paramAssignPanel = new JPanel();
            paramAssignPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parameters"));
            paramAssignPanel.setLayout(new GridLayout(0, 3, 10, 10));
            int parampos = 0;
            for (final Variable param : this.selectedService.getParameters()) {
                final JButton assignButton = new JButton("unassigned");
                final int pos = parampos;
                assignButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Variable absvar = null;
                        if (param == NewTestHarnessCreatingProcessFrame.this.selectedService.getResultVar()) {
                            absvar = TUtile.selectOutputVariableToAssign(param);
                            if (absvar != null && absvar.getName().startsWith("New Output Variable")) {
                                System.out.println("Must create new output variable");
                                NewTestHarnessCreatingProcessFrame.this.intentionPanel.createNewOutputVariable(absvar);
                            }
                        } else {
                            absvar = TUtile.selectInputVariableToAssign(param);
                            if (absvar != null && absvar.getName().startsWith("New Input Variable")) {
                                System.out.println("Must create new input variable");
                                NewTestHarnessCreatingProcessFrame.this.intentionPanel.createNewInputVariable(absvar);
                            }
                        }
                        if (absvar == null) {
                            return;
                        }
                        JButton existingJButton = NewTestHarnessCreatingProcessFrame.this.abstrToJButton.get(absvar);
                        if (existingJButton != null) {
                            existingJButton.setText("unassigned");
                        }
                        NewTestHarnessCreatingProcessFrame.this.abstrToJButton.put(absvar, assignButton);
                        NewTestHarnessCreatingProcessFrame.this.abstrToParams.put(absvar, param);
                        if (param == NewTestHarnessCreatingProcessFrame.this.selectedService.getResultVar()) {
                            NewTestHarnessCreatingProcessFrame.this.intentionPanel.assignOutputParameter(absvar, param, called, pos);
                        } else {
                            NewTestHarnessCreatingProcessFrame.this.intentionPanel.assignInputParameter(absvar, param, called, pos);
                        }
                        assignButton.setText(absvar.getName());
                    }
                });
                paramAssignPanel.add(assignButton);
                paramAssignPanel.add(new JLabel(param.toString()));
                paramAssignPanel.add(new JLabel(""));
                this.usedVariables.put(param, null);
            }
            assignPanel.add(paramAssignPanel);
            ++parampos;
        }
    }

    private ServiceIdentifier getSelectedServiceId() {
        return this.selectedServices.get(0);
    }

    private costo.graph.Component selectCUT() {
        JFileChooser fd = new JFileChooser(this.intention.getFilePath());
        int ret = fd.showOpenDialog(this);
        if (ret == 1) {
            return null;
        }
        File file = fd.getSelectedFile();
        String compname = file.getName();
        String abspath = file.getParent();
        ComponentFactory cf = null;
        try {
            cf = Activator.getDefault().getComponentFactory(abspath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        costo.graph.Component comp = cf.getComponent(compname);
        return comp;
    }

    protected void quit() {
        System.exit(0);
    }

    private void analyzeServices() {
        this.statevariabledata = new ArrayList();
        this.statevariabledata.addAll(this.abstrToState.values());
        System.out.println("statevars: " + this.statevariabledata);
        for (Service serv : this.selectedService.getOwner().getServicesMeetingCriterion(1)) {
            VariableUsageComponentVisitor visitor = new VariableUsageComponentVisitor((KmlContext)this.selectedService);
            serv.accept((KmlElementVisitor)visitor);
            VariableUsage varusage = visitor.getVariableUsage();
            new ArrayList<Variable>(this.statevariabledata);
            HashSet writeVarlist = new HashSet(varusage.getModifiedVarlist());
            writeVarlist.retainAll(this.statevariabledata);
            if (writeVarlist.isEmpty()) continue;
            String info = serv.getSignature() + "\n modified vars: " + writeVarlist + "\n";
            info = String.valueOf(info) + "\n dependencies" + serv.getInterface().getExtrequired();
            if (serv.getPostClause() != null) {
                info = String.valueOf(info) + "\n post " + serv.getPostClause().toString();
            }
            if (serv.getOwner().getInterface().getConfig().contains(serv.getName())) {
                this.configserviceInfoMap.put(info, serv);
            }
            if (!serv.getOwner().getInterface().getProvided().contains(serv.getName())) continue;
            this.callableserviceInfoMap.put(info, serv);
        }
    }

    private void assignStateVarSetter() {
        JCheckPanel callablepanel;
        this.analyzeServices();
        if (this.statevariabledata.isEmpty()) {
            return;
        }
        ArrayList<JComponent> complist = new ArrayList<JComponent>();
        if (this.callableserviceInfoMap.isEmpty()) {
            complist.add(new JLabel("No direct modifier service found"));
        } else {
            ArrayList<String> orderedcallable = new ArrayList<String>(this.callableserviceInfoMap.keySet());
            callablepanel = new JCheckPanel(orderedcallable, true);
            complist.add(new JLabel("modifier services"));
            complist.add(callablepanel);
        }
        if (this.configserviceInfoMap.isEmpty()) {
            complist.add(new JLabel("No config service found"));
        } else {
            ArrayList<String> orderedconfig = new ArrayList<String>(this.configserviceInfoMap.keySet());
            callablepanel = new JCheckPanel(orderedconfig, true);
            complist.add(new JLabel("config services"));
            complist.add(callablepanel);
        }
        JOptionPane.showMessageDialog(null, complist.toArray(), "data binding: component state", 3);
        this.selectedService.getReturnCostoType();
    }

    public Variable selectVariableToAssign(ArrayList<Variable> varlist, Variable target, boolean withMock) {
        if (this.intention == null) {
            return null;
        }
        if (withMock) {
            varlist.add(new Variable("Use a new Mock", new CostoType(String.valueOf(target.getType()) + "Mock")));
        }
        Object[] tablo = new Variable[1];
        tablo = varlist.toArray(tablo);
        Variable var = (Variable)JOptionPane.showInputDialog(this, "Select the abstract variable to assign to " + target, "Assign to " + target, -1, null, tablo, tablo[0]);
        System.out.println(var);
        return var;
    }

    public void generateTestHarness() {
        String errorMsg = "";
        for (Service serv : this.usedServices.keySet()) {
            if (this.usedServices.get(serv) != null) continue;
            if (!errorMsg.isEmpty()) {
                errorMsg = String.valueOf(errorMsg) + "\n";
            }
            errorMsg = String.valueOf(errorMsg) + serv.getName();
        }
        if (!errorMsg.isEmpty()) {
            JOptionPane.showMessageDialog(null, "These services are unassigned :\n" + errorMsg, "Errors", 0);
        }
        errorMsg = "";
        for (Variable var : this.usedVariables.keySet()) {
            if (this.usedVariables.get(var) != null) continue;
            if (!errorMsg.isEmpty()) {
                errorMsg = String.valueOf(errorMsg) + "\n";
            }
            errorMsg = String.valueOf(errorMsg) + "\t- " + var.getName();
        }
        if (!errorMsg.isEmpty()) {
            JOptionPane.showMessageDialog(null, "These variables are unassigned :\n" + errorMsg, "Errors", 0);
        }
        ArrayList arrayLibs = this.rootCUT.getLibraries();
        ArrayList components = new ArrayList();
        ArrayList assemblies = new ArrayList();
        HashMap<String, Object> component = null;
        ArrayList variables = null;
        HashMap<String, String> variable = null;
        ServiceIdentifier defaultServId = null;
        for (ServiceIdentifier servId : this.selectedServices) {
            if (defaultServId == null) {
                defaultServId = servId;
            }
            component = new HashMap<String, Object>();
            component.put("name", servId.getCompVarName());
            component.put("type", servId.getServ().getOwner().getName());
            String conf_params = "";
            variables = new ArrayList();
            for (Variable var : this.compvars) {
                String varName = "v_" + var.getName();
                variable = new HashMap<String, String>();
                variable.put("name", varName);
                variable.put("type", var.getType());
                variable.put("vname", var.getName());
                String value = var.getName();
                for (Variable vr : this.usedVariables.keySet()) {
                    if (!vr.getName().equals(var.getName())) continue;
                }
                variable.put("value", value);
                variables.add(variable);
                if (!conf_params.isEmpty()) {
                    conf_params = String.valueOf(conf_params) + ", ";
                }
                conf_params = String.valueOf(conf_params) + varName;
            }
            component.put("variables", variables);
            component.put("conf_params", conf_params);
            components.add(component);
        }
        HashMap<String, String> tester = new HashMap<String, String>();
        tester.put("name", "tc");
        tester.put("type", String.valueOf(this.intention.getName()) + "_Tester");
        HashMap<String, String> cut = new HashMap<String, String>();
        cut.put("name", this.selectedServices.get(0).getCompVarName());
        cut.put("type", this.selectedServices.get(0).getCompVar().getTypeName());
        HashMap<String, String> assembly = new HashMap<String, String>();
        assembly.put("name", "suttes");
        assembly.put("type", "p-r");
        assembly.put("service1", String.valueOf((String)cut.get("name")) + "." + this.selectedService.getName());
        assembly.put("service2", String.valueOf((String)tester.get("name")) + "." + this.selectedService.getName());
        assemblies.add(assembly);
        ArrayList<HashMap<String, String>> init_vars = new ArrayList<HashMap<String, String>>();
        HashMap links = this.rootCUT.getComposition().getAssembly().getLinks();
        ArrayList componentsAssembly = new ArrayList();
        int counter = 1;
        for (String ky : links.keySet()) {
            Link link = (Link)links.get(ky);
            ServiceIdentifier servIdenReq = link.getRequired();
            if (servIdenReq == null || servIdenReq.getCompVar() != this.selectedServices.get(0).getCompVar() || !this.selectedService.getRequired().contains(servIdenReq.getServ())) continue;
            String name = "";
            String type = "";
            String conf_params = "";
            String retType = link.getProvided().getServ().getReturnCostoType().getName();
            if (this.usedServices.get(link.getRequired().getServ()) != null) {
                String vname = String.valueOf(link.getProvided().getCompVarName()) + link.getProvided().getServ().getName();
                name = link.getRequired().getServ().getName();
                String value = ((Variable)this.usedServices.get(link.getRequired().getServ())).getName();
                type = retType;
                variable = new HashMap();
                variable.put("cmpname", this.selectedServices.get(0).getCompVarName());
                variable.put("type", type);
                variable.put("name", name);
                variable.put("vname", vname);
                variable.put("value", value);
                init_vars.add(variable);
                continue;
            }
            String varName = name = String.valueOf(link.getProvided().getCompVarName()) + link.getProvided().getServ().getName();
            name = String.valueOf(varName) + "mock";
            type = String.valueOf(retType) + "Mock";
            conf_params = "getData(\"" + varName + "\", \"" + retType + "\")";
            this.generateMock(type, varName, retType);
            HashMap<String, String> compAssembly = new HashMap<String, String>();
            compAssembly.put("name", name);
            compAssembly.put("type", type);
            compAssembly.put("conf_params", conf_params);
            componentsAssembly.add(compAssembly);
            assembly = new HashMap();
            assembly.put("name", "new" + counter);
            assembly.put("type", "p-r");
            assembly.put("service1", compAssembly.get("name") + ".value");
            assembly.put("service2", String.valueOf((String)cut.get("name")) + "." + link.getRequired().getServ().getName());
            assemblies.add(assembly);
            ++counter;
        }
        String libs_used = "PLATOONTESTLIB";
        for (CostoLibrary lib : arrayLibs) {
            if (lib.getName().equalsIgnoreCase("DEFAULT")) continue;
            if (!libs_used.isEmpty()) {
                libs_used = String.valueOf(libs_used) + ", ";
            }
            libs_used = String.valueOf(libs_used) + lib.getName();
        }
        SimpleHash modelRoot = new SimpleHash();
        modelRoot.put("app_name", (Object)(String.valueOf(this.intention.getName()) + "_TH"));
        modelRoot.put("itf_provided", (Object)"");
        modelRoot.put("itf_required", (Object)"");
        modelRoot.put("itf_config", (Object)"");
        modelRoot.put("itf_autorun", (Object)"");
        modelRoot.put("components", components);
        modelRoot.put("components_assembly", componentsAssembly);
        modelRoot.put("assemblies", assemblies);
        modelRoot.put("libs_used", (Object)libs_used);
        modelRoot.put("tester", tester);
        modelRoot.put("cut", cut);
        modelRoot.put("init_vars", init_vars);
        try {
            Configuration config = new Configuration();
            config.setClassForTemplateLoading(this.getClass(), "templates");
            Template tempmodel = config.getTemplate("HarnessTest.ftl");
            String path = this.intention.getFilePath().replace(this.intention.getName(), String.valueOf(this.intention.getName()) + "_TH");
            FileWriter out = new FileWriter(path);
            tempmodel.process((Object)modelRoot, (Writer)out);
            this.generateTester();
            this.generateVariables(String.valueOf(this.intention.getName()) + "_TH");
            JOptionPane.showMessageDialog(null, "Generarion successfully finished.\nFile generated: " + path, "Finished", 1);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Generarion failled", "Finished", 0);
            ex.printStackTrace();
        }
    }

    public void generateTester() {
        String sutVarName = String.valueOf(this.selectedService.getName().toLowerCase()) + "result";
        String servparams = "";
        ArrayList<Object> varsSUT = new ArrayList<Object>();
        for (String key : this.selectedService.getParametersMap().keySet()) {
            if (!servparams.isEmpty()) {
                servparams = String.valueOf(servparams) + ", ";
            }
            Variable var = (Variable)this.selectedService.getParametersMap().get(key);
            servparams = String.valueOf(servparams) + var.getName() + ": " + var.getType();
            HashMap infosVar = new HashMap();
            infosVar.put("name", var.getName());
            infosVar.put("type", var.getType());
            infosVar.put("value", var.getName());
            varsSUT.add(infosVar);
        }
        String verdict = "";
        boolean isVerdictDefined = false;
        for (String oracleName : this.intentionPanel.getVarsOracle().keySet()) {
            Map<String, Object> varMap = this.intentionPanel.getVarsOracle().get(oracleName);
            if (varMap.get("service") == null || (ServiceIdentifier)varMap.get("service") != this.getSelectedServiceId()) continue;
            if (!verdict.isEmpty()) {
                verdict = String.valueOf(verdict) + " and ";
            }
            String oracleType = (String)varMap.get("type");
            verdict = String.valueOf(verdict) + sutVarName + " " + varMap.get("operator") + " getData(\"" + oracleName + "\", \"" + oracleType + "\")";
            isVerdictDefined = true;
        }
        if (!isVerdictDefined) {
            System.out.println("no verdict defined");
        }
        SimpleHash modelRoot = new SimpleHash();
        modelRoot.put("tester_name", (Object)(String.valueOf(this.intention.getName()) + "_Tester"));
        modelRoot.put("testcase_name", (Object)"testcase1");
        modelRoot.put("tested_serv", (Object)this.selectedService.getName());
        modelRoot.put("variable", (Object)sutVarName);
        modelRoot.put("verdict", (Object)verdict);
        modelRoot.put("vars_sut", varsSUT);
        modelRoot.put("type", (Object)this.selectedService.getReturnCostoType());
        modelRoot.put("params_tested_serv", (Object)servparams);
        modelRoot.put("libs_used", (Object)"PLATOONTESTLIB,PLATOONLIB,DEFAULT");
        try {
            Configuration config = new Configuration();
            config.setClassForTemplateLoading(this.getClass(), "templates");
            Template tempmodel = config.getTemplate("ComponentTester.ftl");
            String path = this.intention.getFilePath().replace(this.intention.getName(), String.valueOf(this.intention.getName()) + "_Tester");
            FileWriter out = new FileWriter(path);
            tempmodel.process((Object)modelRoot, (Writer)out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void generateMock(String mockName, String varName, String retType) {
        this.mocksVar.put(varName, retType);
        System.out.println("--- Creating new mock name:" + mockName + " type:" + retType);
        String path = String.valueOf(this.intention.getFactory().getAbsSpecDir()) + File.separator + mockName + ".kcp";
        System.out.println("path:" + path);
        File file = new File(path);
        if (file.exists()) {
            return;
        }
        System.out.println(String.valueOf(mockName) + " not presents");
        SimpleHash modelRoot = new SimpleHash();
        modelRoot.put("mock_name", (Object)mockName);
        modelRoot.put("var_name", (Object)varName);
        modelRoot.put("provided", (Object)(String.valueOf(retType.toLowerCase()) + "data"));
        modelRoot.put("libs_used", (Object)"PLATOONTESTLIB");
        modelRoot.put("return_type", (Object)retType);
        try {
            Configuration config = new Configuration();
            config.setClassForTemplateLoading(this.getClass(), "templates");
            Template tempmodel = config.getTemplate("Mock.ftl");
            FileWriter out = new FileWriter(path);
            tempmodel.process((Object)modelRoot, (Writer)out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void generateVariables(String compName) {
        ArrayList variables = new ArrayList();
        HashMap<String, String> varStr = null;
        for (Variable var : this.compvars) {
            varStr = new HashMap<String, String>();
            varStr.put("vname", var.getName());
            varStr.put("vtype", var.getType());
            variables.add(varStr);
        }
        for (Variable var : this.selectedService.getParameters()) {
            if (var == this.selectedService.getResultVar()) continue;
            varStr = new HashMap();
            varStr.put("vname", var.getName());
            varStr.put("vtype", var.getType());
            variables.add(varStr);
        }
        ArrayList required = this.selectedService.getRequired();
        for (Service serv : required) {
            varStr = new HashMap();
            varStr.put("vname", serv.getName());
            varStr.put("vtype", serv.getResultVar().getType());
            variables.add(varStr);
        }
        for (String mockName : this.mocksVar.keySet()) {
            varStr = new HashMap();
            varStr.put("vname", mockName);
            varStr.put("vtype", this.mocksVar.get(mockName));
            variables.add(varStr);
        }
        for (String oracleName : this.intentionPanel.getVarsOracle().keySet()) {
            Map<String, Object> varMap = this.intentionPanel.getVarsOracle().get(oracleName);
            if (varMap.get("service") == null || (ServiceIdentifier)varMap.get("service") != this.getSelectedServiceId()) continue;
            varStr = new HashMap();
            varStr.put("vname", oracleName);
            varStr.put("vtype", varMap.get("type").toString());
            variables.add(varStr);
        }
        String path = String.valueOf(this.intention.getFactory().getAbsSpecDir()) + File.separator + "data";
        File dir = new File(path);
        if (!dir.isDirectory() && !dir.mkdir()) {
            return;
        }
        path = String.valueOf(path) + File.separator + compName + ".properties";
        SimpleHash modelRoot = new SimpleHash();
        modelRoot.put("component_vars", variables);
        modelRoot.put("component_name", (Object)this.rootCUT.getName());
        try {
            Configuration config = new Configuration();
            config.setClassForTemplateLoading(this.getClass(), "templates");
            Template tempmodel = config.getTemplate("component_variables.ftl");
            FileWriter out = new FileWriter(path);
            tempmodel.process((Object)modelRoot, (Writer)out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        NewTestHarnessCreatingProcessFrame test = new NewTestHarnessCreatingProcessFrame(null);
        test.pack();
        test.setVisible(true);
    }
}

