/*
 * Decompiled with CFR 0.152.
 */
package costolib.ui.editorstest;

import costo.graph.Assembly;
import costo.graph.Component;
import costo.graph.ComponentVariable;
import costo.graph.CostoLibrary;
import costo.graph.KmlStructuralElement;
import costo.graph.Link;
import costo.graph.Service;
import costo.graph.Variable;
import costo.graph.expressions.KmlSignature;
import costo.graph.types.CostoType;
import costolib.ui.Activator;
import costolib.ui.editorstest.ServiceSelector;
import costolib.ui.editorstest.SimpleTemplate;
import costolib.ui.editorstest.XMLEditor;
import costolib.ui.editorstest.XMLTagScanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class CompletionProcessor
implements IContentAssistProcessor {
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private final char[] PROPOSAL_ACTIVATION_CHARS = new char[]{'s', 'f', 'p', 'n', 'm'};
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private XMLEditor editor;
    private ArrayList<SimpleTemplate> templates = new ArrayList();
    Image varImg = Activator.getDefault().getIcon("icons/variable.gif");
    Image compVarImg = Activator.getDefault().getIcon("icons/variable.gif");
    Image cstImg = Activator.getDefault().getIcon("icons/constant.gif");
    Image typImg = Activator.getDefault().getIcon("icons/type.gif");
    Image funImg = Activator.getDefault().getIcon("icons/function.gif");
    Image comImg = Activator.getDefault().getIcon("icons/communication.gif");
    Image provImg = Activator.getDefault().getIcon("icons/provided.gif");
    Image reqImg = Activator.getDefault().getIcon("icons/required.gif");

    public CompletionProcessor(XMLEditor editor) {
        this.editor = editor;
        this.templates = Activator.getDefault().getTemplates();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        int line;
        IDocument document = viewer.getDocument();
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        String prefix = this.lastWord(document, offset);
        try {
            line = document.getLineOfOffset(offset) + 1;
            int cfr_ignored_0 = offset - document.getLineOffset(line) + 1;
        }
        catch (Exception exception) {
            return null;
        }
        try {
            Component current = this.editor.getCurrentComponent();
            KmlStructuralElement currentElem = this.editor.getSelectedStructuralElement(line);
            this.addTemplatesToList(result, this.templates, prefix, offset, null, 0);
            if (current != null) {
                Assembly bly = this.getCurrentAssembly(current, line);
                int dotPosition = prefix.indexOf(46);
                if (bly != null) {
                    if (bly.getNamedComponents() != null) {
                        ComponentVariable cv;
                        this.addTemplatesToList(result, this.proposeComponentVariables(bly), prefix, offset, this.varImg, 0);
                        if (dotPosition > 0 && (cv = bly.getComponentVariable(prefix.substring(0, dotPosition))) != null) {
                            this.addTemplatesToList(result, this.proposeObservableVariables(cv), prefix, offset, this.varImg, 0);
                        }
                    }
                    if (bly.getLinks() != null) {
                        for (Link link : bly.getLinks().values()) {
                            if (link.getLine() != line || dotPosition <= 0) continue;
                            ComponentVariable cv = bly.getComponentVariable(prefix.substring(0, dotPosition));
                            Service matching = null;
                            try {
                                matching = link.getFirst().getCompVar() == cv ? link.getSecond().getServ() : link.getFirst().getServ();
                            }
                            catch (NullPointerException e) {
                                e.printStackTrace();
                            }
                            final Service other = matching;
                            this.addTemplatesToList(result, this.proposeServices(cv, new ServiceSelector(){

                                @Override
                                public boolean ifSelect(Service s) {
                                    return other == null || s.isProvided() != other.isProvided();
                                }

                                @Override
                                public String additionalInfo(Service s) {
                                    String note = "";
                                    if (other != null && s.getKmlSignature() != null && !s.getKmlSignature().equalsIgnoreName(other.getKmlSignature())) {
                                        note = " type mismatch";
                                    }
                                    return note;
                                }
                            }), prefix, offset, null, 0);
                        }
                    }
                }
                this.addTemplatesToList(result, this.getVarNames(current, line), prefix, offset, this.varImg, 1);
                this.addTemplatesToList(result, this.getConstNames(current, line), prefix, offset, this.cstImg, 1);
                this.addTemplatesToList(result, this.getFuncNames(current), prefix, offset, this.funImg, 1);
                this.addTemplatesToList(result, this.getTypeNames(current), prefix, offset, this.typImg, 1);
                this.addTemplatesToList(result, this.getServiceNames(current, line), prefix, offset, this.comImg, 1);
            }
            if (prefix.length() > 0) {
                Object keyword;
                Object object = XMLTagScanner.KEYWORDS;
                int n = XMLTagScanner.KEYWORDS.length;
                int n2 = 0;
                while (n2 < n) {
                    keyword = object[n2];
                    if (((String)keyword).startsWith(prefix)) {
                        result.add((ICompletionProposal)new CompletionProposal((String)keyword, offset - prefix.length(), prefix.length(), ((String)keyword).length(), null, String.valueOf(keyword) + " - keyword ", null, null));
                    }
                    ++n2;
                }
                object = XMLTagScanner.STRUCTURING_KEYWORDS;
                n = XMLTagScanner.STRUCTURING_KEYWORDS.length;
                n2 = 0;
                while (n2 < n) {
                    keyword = object[n2];
                    if (((String)keyword).startsWith(prefix)) {
                        result.add((ICompletionProposal)new CompletionProposal((String)keyword, offset - prefix.length(), prefix.length(), ((String)keyword).length(), null, String.valueOf(keyword) + " - keyword ", null, null));
                    }
                    ++n2;
                }
            }
            return result.toArray(new ICompletionProposal[result.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.NO_COMPLETIONS;
        }
    }

    private ArrayList<SimpleTemplate> proposeObservableVariables(ComponentVariable cv) {
        if (cv == null) {
            return null;
        }
        HashSet<SimpleTemplate> uniqueNames = new HashSet<SimpleTemplate>();
        for (Variable v : cv.getComponentType().getVariables().values()) {
            if (!v.isObservable()) continue;
            String pref = String.valueOf(cv.getVarName()) + "." + v.getName();
            uniqueNames.add(new SimpleTemplate(pref, String.valueOf(v.getName()) + " : " + v.getType(), pref, this.varImg));
        }
        return this.sortedList(uniqueNames);
    }

    private ArrayList<SimpleTemplate> proposeComponentVariables(Assembly bly) {
        if (bly == null || bly.getNamedComponents() == null) {
            return null;
        }
        HashSet<SimpleTemplate> uniqueNames = new HashSet<SimpleTemplate>();
        for (ComponentVariable cv : bly.getNamedComponents()) {
            uniqueNames.add(new SimpleTemplate(cv.getVarName(), String.valueOf(cv.getVarName()) + " : " + cv.getTypeName(), cv.getVarName(), this.compVarImg));
        }
        return this.sortedList(uniqueNames);
    }

    private ArrayList<SimpleTemplate> proposeServices(ComponentVariable cv, ServiceSelector s) {
        if (cv == null || !cv.isLoaded()) {
            return null;
        }
        HashSet<SimpleTemplate> uniqueNames = new HashSet<SimpleTemplate>();
        for (Service serv : cv.getComponentType().getServices()) {
            if (s != null && !s.ifSelect(serv)) continue;
            KmlSignature ksig = serv.getKmlSignature();
            String sig = "";
            if (ksig != null) {
                sig = ksig.toString();
            }
            uniqueNames.add(new SimpleTemplate(String.valueOf(cv.getVarName()) + "." + serv.getName(), String.valueOf(sig) + " - " + cv.getComponentType().getName() + (s == null ? "" : s.additionalInfo(serv)), String.valueOf(cv.getVarName()) + "." + serv.getName(), serv.isProvided() ? this.provImg : this.reqImg));
        }
        return this.sortedList(uniqueNames);
    }

    private Assembly getCurrentAssembly(Component current, int line) {
        if (current.isComposite() && current.getComposition().getAssembly().lineInElement(line)) {
            return current.getComposition().getAssembly();
        }
        return null;
    }

    private void addTemplatesToList(ArrayList<ICompletionProposal> globallist, ArrayList<SimpleTemplate> tlist, String prefix, int offset, Image img, int minPrefixLength) {
        if (tlist == null) {
            return;
        }
        if (prefix.length() >= minPrefixLength) {
            for (SimpleTemplate keyword : tlist) {
                if (!keyword.getTemplatePrefix().startsWith(prefix)) continue;
                Image icon = keyword.getIcon();
                if (icon == null) {
                    icon = img;
                }
                globallist.add((ICompletionProposal)new CompletionProposal(keyword.getTemplateValue(), offset - prefix.length(), prefix.length(), keyword.getTemplateValue().length(), icon, keyword.getTemplateDescription(), null, null));
            }
        }
    }

    private ArrayList<SimpleTemplate> getTypeNames(Component current) {
        HashSet<SimpleTemplate> uniqueNames = new HashSet<SimpleTemplate>();
        ArrayList<SimpleTemplate> names = new ArrayList<SimpleTemplate>();
        if (current.getTypes() != null) {
            for (CostoType ct : current.getTypes().values()) {
                uniqueNames.add(this.createTemplateFromType(ct, " comp. " + current.getName()));
            }
        }
        if (current.getLibraries() != null) {
            for (CostoLibrary clib : current.getLibraries()) {
                for (CostoType ct : clib.getTypes().values()) {
                    uniqueNames.add(this.createTemplateFromType(ct, " lib. " + clib.getName()));
                }
            }
        }
        names.addAll(uniqueNames);
        Collections.sort(names);
        return names;
    }

    private SimpleTemplate createTemplateFromVar(Variable var, String origin) {
        return new SimpleTemplate(String.valueOf(var.toString()) + " - " + origin, var.getName());
    }

    private SimpleTemplate createTemplateFromType(CostoType ct, String origin) {
        return new SimpleTemplate(String.valueOf(ct.getName()) + " - " + origin, ct.getName());
    }

    private SimpleTemplate createTemplateFromFunction(KmlSignature sig, String origin) {
        return new SimpleTemplate(String.valueOf(sig.toString()) + " - " + origin, String.valueOf(sig.getName()) + "()");
    }

    private ArrayList<SimpleTemplate> getConstNames(Component current, int line) {
        HashSet<SimpleTemplate> uniqueNames = new HashSet<SimpleTemplate>();
        Service serv = current.getServiceFromLine(line);
        if (serv != null && serv.getConstants() != null) {
            for (Variable cons : serv.getConstants().values()) {
                uniqueNames.add(this.createTemplateFromVar(cons, "service " + serv.getName()));
            }
        }
        if (current.getConstants() != null) {
            for (Variable cons : current.getConstants().values()) {
                uniqueNames.add(this.createTemplateFromVar(cons, "comp. " + current.getName()));
            }
        }
        if (current.getLibraries() != null) {
            for (CostoLibrary clib : current.getLibraries()) {
                if (clib.getConstants() == null) continue;
                for (Variable cons : clib.getConstants().values()) {
                    uniqueNames.add(this.createTemplateFromVar(cons, "lib. " + clib.getName()));
                }
            }
        }
        return this.sortedList(uniqueNames);
    }

    private ArrayList<SimpleTemplate> getFuncNames(Component current) {
        HashSet<SimpleTemplate> uniqueNames = new HashSet<SimpleTemplate>();
        if (current.getLibraries() != null) {
            for (CostoLibrary clib : current.getLibraries()) {
                if (clib.getAllFunctions() == null) continue;
                for (KmlSignature sig : clib.getAllFunctions()) {
                    uniqueNames.add(this.createTemplateFromFunction(sig, "lib. " + clib.getName()));
                }
            }
        }
        return this.sortedList(uniqueNames);
    }

    private ArrayList<SimpleTemplate> sortedList(Set<SimpleTemplate> set) {
        ArrayList<SimpleTemplate> names = new ArrayList<SimpleTemplate>();
        names.addAll(set);
        Collections.sort(names);
        return names;
    }

    private ArrayList<SimpleTemplate> getVarNames(Component current, int line) {
        HashSet<SimpleTemplate> uniqueNames = new HashSet<SimpleTemplate>();
        Service serv = current.getServiceFromLine(line);
        if (serv != null && serv.getVariables() != null) {
            for (Variable cons : serv.getVariables().values()) {
                uniqueNames.add(this.createTemplateFromVar(cons, "service " + serv.getName()));
            }
        }
        if (current.getVariables() != null) {
            for (Variable cons : current.getVariables().values()) {
                uniqueNames.add(this.createTemplateFromVar(cons, "comp. " + current.getName()));
            }
        }
        return this.sortedList(uniqueNames);
    }

    private ArrayList<SimpleTemplate> getServiceNames(Component current, int line) {
        HashSet<SimpleTemplate> uniqueNames = new HashSet<SimpleTemplate>();
        Service serv = current.getServiceFromLine(line);
        if (serv == null) {
            return new ArrayList<SimpleTemplate>();
        }
        if (serv.getInterface() != null) {
            uniqueNames.addAll(this.createTemplateFromServicenames(current, serv.getInterface().getExtrequired(), " ext required service", this.reqImg));
            uniqueNames.addAll(this.createTemplateFromServicenames(current, serv.getInterface().getCalrequired(), " cal required service", this.reqImg));
            uniqueNames.addAll(this.createTemplateFromServicenames(current, serv.getInterface().getIntrequired(), " int required service", this.reqImg));
            uniqueNames.addAll(this.createTemplateFromServicenames(current, serv.getInterface().getSubprovided(), " subprovided service", this.provImg));
            uniqueNames.add(new SimpleTemplate("CALLER channel", "__CALLER"));
            uniqueNames.add(new SimpleTemplate("SELF channel", "__SELF"));
        }
        return this.sortedList(uniqueNames);
    }

    private void detectContext(Component current, int offset) {
    }

    private ArrayList<SimpleTemplate> createTemplateFromServicenames(Component comp, ArrayList<String> allRequired, String origin, Image icon) {
        ArrayList<SimpleTemplate> list = new ArrayList<SimpleTemplate>();
        if (allRequired != null) {
            Iterator<String> iterator = allRequired.iterator();
            while (iterator.hasNext()) {
                KmlSignature ksig;
                String servName;
                String sig = servName = iterator.next();
                Service serv = comp.getService(servName);
                if (serv != null && (ksig = serv.getKmlSignature()) != null) {
                    sig = ksig.toString();
                }
                list.add(new SimpleTemplate(servName, String.valueOf(servName) + " - " + origin, servName, icon));
                list.add(new SimpleTemplate("_" + servName, String.valueOf(servName) + " - " + origin, servName, icon));
                list.add(new SimpleTemplate("!!" + servName, String.valueOf(sig) + " - " + origin, servName, icon));
                list.add(new SimpleTemplate("??" + servName, String.valueOf(sig) + " - " + origin, servName, icon));
                list.add(new SimpleTemplate("<<" + servName, String.valueOf(sig) + " - " + origin, servName, icon));
            }
        }
        return list;
    }

    private String lastWord(IDocument doc, int offset) {
        try {
            int n = offset - 1;
            while (n >= 0) {
                char c = doc.getChar(n);
                if (!Character.isJavaIdentifierPart(c) && c != '.') {
                    return doc.get(n + 1, offset - n - 1);
                }
                --n;
            }
        }
        catch (BadLocationException badLocationException) {}
        return "";
    }

    private String lastIndent(IDocument doc, int offset) {
        try {
            int start = offset - 1;
            while (start >= 0 && doc.getChar(start) != '\n') {
                --start;
            }
            int end = start;
            while (end < offset && Character.isSpaceChar(doc.getChar(end))) {
                ++end;
            }
            System.out.println(String.valueOf(start) + " - " + end);
            return doc.get(start + 1, end - start - 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        System.out.println("ComputeContextInformation");
        return this.NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        System.out.println("etCompletionProposalAutoActivationCharacters");
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

