/*
 * Decompiled with CFR 0.152.
 */
package costolib.ui.interfaces;

import costo.graph.Component;
import costo.graph.KmlElement;
import costo.graph.Service;
import costolib.ui.interfaces.IComponentActor;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public abstract class ExporterComponentActor
implements IComponentActor {
    private String exportType = "src";
    private String exportPath;
    private String projectroot;

    @Override
    public boolean isApplicableFor(KmlElement currentSelection) {
        return false;
    }

    public static Service selectServiceFrom(Collection<Service> serv, Component comp) {
        if (serv == null || serv.isEmpty()) {
            return null;
        }
        Icon icon = null;
        Object[] services = serv.toArray();
        String servname = (String)JOptionPane.showInputDialog(null, "Select the providedservice :", "Mutation of Service ", -1, icon, services, services[0]);
        if (servname == null) {
            return null;
        }
        return comp.getService(servname);
    }

    @Override
    public abstract void doSomethingWithComponent(Component var1, KmlElement var2, String var3);

    public void refreshExportFolder() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IResource wSDLFile = workspaceRoot.findMember(new Path(this.projectroot).lastSegment());
        if (wSDLFile != null) {
            try {
                wSDLFile.refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected void computeExportPath(Component comp, String relativePath, String prefix) {
        String compPath = comp.getFilePath();
        this.projectroot = compPath.substring(0, compPath.indexOf(relativePath));
        int lastdot = relativePath.lastIndexOf(".");
        String exportdirRelPath = relativePath.substring(0, lastdot);
        String cleanedRelPath = exportdirRelPath.replaceAll("/", "\u00c3\u00b9").replaceAll("[^\\p{Alnum}.\u00c3\u00b9]", "");
        this.exportPath = String.valueOf(this.projectroot) + prefix + "/" + cleanedRelPath.replaceAll("\u00c3\u00b9", "/");
    }

    public String getExportPath() {
        return this.exportPath;
    }

    public void setExportPath(String exportPath) {
        this.exportPath = exportPath;
    }

    public String getExportType() {
        return this.exportType;
    }

    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    public String getProjectroot() {
        return this.projectroot;
    }

    public void setProjectroot(String projectroot) {
        this.projectroot = projectroot;
    }
}

