/*
 * Decompiled with CFR 0.152.
 */
package mec.exports;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import mec.MecLoader;
import mec.graph.FSMState;
import mec.graph.FSMTransition;
import mec.graph.MecRes;
import mec.graph.MecResLTS;
import mec.graph.MecResSTS;
import mec.graph.MecResState;
import mec.graph.MecResTransition;

public class Mec2Dot {
    static String graphstyle = "fontsize = \"14\" \nfontname = \"Times-Roman\"\nfontcolor = \"black\"\nbb = \"0,0,648,180\"\ncolor = \"black\"\n";
    static String nodestyle = "fontsize = \"14\" \nfontname = \"Times-Roman\"\nfontcolor = \"black\"\nshape = \"ellipse\"\ncolor = \"black\"\n";
    static String nodestyleinit = "fontsize = \"14\" \nfontname = \"Arial\"\nfontcolor = \"blue\"\nshape = \"polygon\"\ncolor = \"lightblue\"\nstyle = \"filled\"\nsides = \"5\"\nperipheries = \"2\"\n";
    static String nodestylefinal = "fontsize = \"14\" \nfontname = \"Arial\"\nfontcolor = \"blue\"\nshape = \"polygon\"\ncolor = \"limegreen\"\nstyle = \"filled\"\nsides = \"4\"\ndistortion = \".7\"\n";
    static String nodestyledeadf = "fontsize = \"14\" \nfontname = \"Times-Roman\"\nfontcolor = \"red\"\nstyle = \"filled\"\nshape = \"Mdiamond\"\ncolor = \"indianred\"\n";
    static String nodestyledeadlockf = "fontsize = \"14\" \nfontname = \"Times-Roman\"\nfontcolor = \"black\"\nstyle = \"filled\"\nshape = \"ellipse\"\ncolor = \"indianred\"\n";
    static String edgestyle = "fontsize = \"14\" \nfontname = \"Times-Roman\"\nfontcolor = \"black\"\ncolor = \"black\"\n";

    public static void write(MecResSTS lts, String fileOut) throws IOException {
        System.out.println(">>> Mec2Dot start generation");
        FileWriter fw = new FileWriter(fileOut);
        fw.write(Mec2Dot.MecDotstring(lts));
        fw.close();
    }

    private static String MecDotstring(MecResSTS sts) {
        String header = "digraph \"" + sts.getName() + "\" {\n";
        header = String.valueOf(header) + " graph [\n" + graphstyle + "]\n";
        header = String.valueOf(header) + " node [\n" + nodestyle + "]\n";
        header = String.valueOf(header) + " edge [\n" + edgestyle + "]\n";
        String nodeslist = "";
        MecResLTS lts = sts.getLts();
        for (FSMState st : lts.getFSMStatesMap().values()) {
            nodeslist = String.valueOf(nodeslist) + Mec2Dot.NodeDotString((MecResState)st);
        }
        String translist = "";
        for (FSMTransition tr : lts.getFSMFSMTransition()) {
            nodeslist = String.valueOf(nodeslist) + Mec2Dot.TransitionDotString((MecResTransition)tr);
        }
        return String.valueOf(header) + nodeslist + translist + "}\n";
    }

    public static String formatLabel(MecResTransition t) {
        String s = "(";
        int size = t.getCompoundLabel().size();
        for (String sn : t.getCompoundLabel()) {
            String[] ea = sn.split("___");
            s = String.valueOf(s) + ea[0];
            int x = 1;
            while (x < ea.length) {
                s = String.valueOf(s) + "___\\n " + ea[x];
                ++x;
            }
            if (--size <= 0) continue;
            s = String.valueOf(s) + ".\\n";
        }
        s = String.valueOf(s) + ")";
        return s;
    }

    private static String TransitionDotString(MecResTransition t) {
        return " \"" + ((MecResState)t.getSource()).getName() + "\" -> \"" + ((MecResState)t.getTarget()).getName() + "\" [\n" + edgestyle + "label = \"" + Mec2Dot.formatLabel(t) + "\"\n" + "]\n";
    }

    private static String NodeDotString(MecResState s) {
        String style = nodestyle;
        if (s.isInit().booleanValue()) {
            style = nodestyleinit;
        } else if (s.isFinal().booleanValue()) {
            style = nodestylefinal;
        } else if (s.isDeadf().booleanValue()) {
            style = nodestyledeadf;
        } else if (s.isDeadlockf().booleanValue()) {
            style = nodestyledeadlockf;
        }
        return "\"" + s.getName() + "\" [\n" + style + "label = \"" + s.toString() + "\"\n" + "]\n";
    }

    public static void main(String[] args) throws RecognitionException, TokenStreamException, FileNotFoundException, IOException {
        MecRes test = MecLoader.loadMecRes(args);
        Mec2Dot.write(test.getSts(), String.valueOf(test.getFileName()) + ".dot");
    }
}

