/*
 * Decompiled with CFR 0.152.
 */
package mec.exports;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import mec.MecLoader;
import mec.graph.FSMState;
import mec.graph.FSMTransition;
import mec.graph.MecRes;
import mec.graph.MecResLTS;
import mec.graph.MecResSTS;
import mec.graph.MecResState;
import mec.graph.MecResTransition;

public class MectoDot {
    static String graphstyle = "fontsize = \"14\" \nfontname = \"Times-Roman\"\nfontcolor = \"black\"\nbb = \"0,0,648,180\"\ncolor = \"black\"\n";
    static String nodestyle = "fontsize = \"14\" \nfontname = \"Times-Roman\"\nfontcolor = \"black\"\nshape = \"ellipse\"\ncolor = \"black\"\n";
    static String edgestyle = "fontsize = \"14\" \nfontname = \"Times-Roman\"\nfontcolor = \"black\"\ncolor = \"black\"\n";

    public static void write(MecResSTS lts, String fileOut) throws IOException {
        FileWriter fw = new FileWriter(fileOut);
        fw.write(MectoDot.MecDotstring(lts));
        fw.close();
    }

    private static String MecDotstring(MecResSTS sts) {
        String header = "digraph \"" + sts.getName() + "\" {\n";
        header = String.valueOf(header) + " graph [\n" + graphstyle + "]\n";
        header = String.valueOf(header) + " node [\n" + nodestyle + "]\n";
        header = String.valueOf(header) + " edge [\n" + edgestyle + "]\n";
        String nodeslist = "";
        MecResLTS lts = sts.getLts();
        Iterator<FSMState> iter = lts.iteratorOnFSMStates();
        while (iter.hasNext()) {
            nodeslist = String.valueOf(nodeslist) + MectoDot.NodeDotString((MecResState)iter.next());
        }
        String translist = "";
        Iterator<FSMTransition> iter2 = lts.iteratorOnFSMFSMTransition();
        while (iter2.hasNext()) {
            translist = String.valueOf(translist) + MectoDot.TransitionDotString((MecResTransition)iter2.next());
        }
        return String.valueOf(header) + nodeslist + translist + "}\n";
    }

    private static String TransitionDotString(MecResTransition t) {
        return " \"" + ((MecResState)t.getSource()).getName() + "\" -> \"" + ((MecResState)t.getTarget()).getName() + "\" [\n" + edgestyle + "label = \"" + t.getLabel() + "\"\n" + "]\n";
    }

    private static String NodeDotString(MecResState s) {
        return "\"" + s.getName() + "\" [\n" + nodestyle + "label = \"" + s.toString() + "\"\n" + "]\n";
    }

    public static void main(String[] args) throws RecognitionException, TokenStreamException, FileNotFoundException, IOException {
        MecRes test = MecLoader.loadMecRes(args);
        MectoDot.write(test.getSts(), String.valueOf(test.getSts().getName()) + ".dot");
    }
}

