/*
 * Decompiled with CFR 0.152.
 */
package mec.graph;

import java.util.HashMap;
import java.util.HashSet;
import mec.graph.FSMState;
import mec.graph.MecResHeader;
import mec.graph.MecResSTS;
import mec.graph.MecResState;

public class MecRes {
    protected String fileName;
    protected HashMap<String, Integer> states_prop;
    protected HashMap<String, Integer> transitions_prop;
    protected MecResSTS sts;
    protected MecResHeader header;
    protected HashMap<String, HashSet<MecResState>> states_set;

    public MecRes(MecResHeader header, HashMap<String, Integer> states_prop, HashMap<String, Integer> transitions_prop, MecResSTS sts, HashMap<String, HashSet<MecResState>> states_prop_set) {
        this.header = header;
        this.states_prop = states_prop;
        this.transitions_prop = transitions_prop;
        this.sts = sts;
        HashMap<String, FSMState> baseStates = this.sts.getLts().getFSMStatesMap();
        this.states_set = new HashMap();
        for (String sn : states_prop_set.keySet()) {
            HashSet<MecResState> propStates = new HashSet<MecResState>();
            for (MecResState st : states_prop_set.get(sn)) {
                propStates.add((MecResState)baseStates.get(st.getId()));
            }
            this.states_set.put(sn, propStates);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public MecResSTS getSts() {
        return this.sts;
    }

    public void computeMarkup() {
        for (MecResState st : this.states_set.get("initial")) {
            st.setIsInit(true);
        }
        for (MecResState st : this.states_set.get("finalStates")) {
            st.setIsFinal(true);
        }
        for (MecResState st : this.states_set.get("deadlockf")) {
            st.setIsDeadlockf(true);
        }
        for (MecResState st : this.states_set.get("deadf")) {
            st.setIsDeadf(true);
        }
    }

    public String toString() {
        String s = this.header.toString();
        s = String.valueOf(s) + "\n//--- States : \n";
        for (String prop : this.states_prop.keySet()) {
            s = String.valueOf(s) + "//" + prop + " : ";
            s = String.valueOf(s) + this.states_prop.get(prop).toString() + "\n";
        }
        s = String.valueOf(s) + "//--- Transitions : \n";
        for (String prop : this.transitions_prop.keySet()) {
            s = String.valueOf(s) + "//" + prop + " : ";
            s = String.valueOf(s) + this.transitions_prop.get(prop).toString() + "\n";
        }
        s = String.valueOf(s) + this.sts.toString();
        s = String.valueOf(s) + "//< \n";
        int size = this.states_set.keySet().size();
        for (String prop : this.states_set.keySet()) {
            s = String.valueOf(s) + "//" + prop + " : { ";
            int size1 = this.states_set.get(prop).size();
            for (MecResState st : this.states_set.get(prop)) {
                s = String.valueOf(s) + st.toString();
                if (--size1 <= 0) continue;
                s = String.valueOf(s) + ", ";
            }
            s = String.valueOf(s) + " }";
            if (--size > 0) {
                s = String.valueOf(s) + ",";
            }
            s = String.valueOf(s) + "\n";
        }
        s = String.valueOf(s) + "//>.\n";
        s = String.valueOf(s) + "//stoplog();\n//\n";
        return s;
    }
}

