/*
 * Decompiled with CFR 0.152.
 */
package mec.graph;

import java.util.ArrayList;
import mec.graph.FSMLabel;
import mec.graph.FSMState;
import mec.graph.FSMTransition;

public class MecResTransition
extends FSMTransition {
    ArrayList<String> compoundLabel;
    ArrayList<String> prop;

    public MecResTransition(FSMState source, FSMState target, ArrayList<String> label, ArrayList<String> prop) {
        super(source, target);
        FSMLabel lab = new FSMLabel();
        lab.libelle = "compound";
        this.setFSMLabel(lab);
        this.compoundLabel = label;
        this.prop = prop;
    }

    public ArrayList<String> getCompoundLabel() {
        return this.compoundLabel;
    }

    public String getLabel() {
        String s = "(";
        int size = this.compoundLabel.size();
        for (String sn : this.compoundLabel) {
            s = String.valueOf(s) + sn;
            if (--size <= 0) continue;
            s = String.valueOf(s) + ".";
        }
        s = String.valueOf(s) + ")";
        return s;
    }

    public String getProp() {
        String s = "(";
        int size = this.prop.size();
        for (String sn : this.prop) {
            s = String.valueOf(s) + sn;
            if (--size <= 0) continue;
            s = String.valueOf(s) + ".";
        }
        s = String.valueOf(s) + ")";
        return s;
    }

    @Override
    public String toString() {
        String s = String.valueOf(this.getSource().toString()) + "|- \n//   (";
        int size = this.compoundLabel.size();
        for (String sn : this.compoundLabel) {
            s = String.valueOf(s) + sn;
            if (--size <= 0) continue;
            s = String.valueOf(s) + ".";
        }
        s = String.valueOf(s) + ")  -> " + this.getTarget().toString();
        return s;
    }
}

