/*
 * Decompiled with CFR 0.152.
 */
package kml2mec;

import costo.graph.Service;
import costo.graph.Transition;
import costo.graph.expressions.KmlCommunication;
import costolib_plugin_kml2mec.ComponentKml2MecActor;
import java.util.ArrayList;
import java.util.HashMap;
import kml2mec.Kml2mecUtils;
import kml2mec.KmlMecLink;
import kml2mec.MecExpression;
import kml2mec.MecFunction;
import kml2mec.MecHeader;
import kml2mec.MecLTS;
import kml2mec.MecSync;

public class MecSTS {
    protected MecHeader header;
    protected ArrayList<MecLTS> lts;
    protected MecSync synchro;
    protected HashMap<String, MecFunction> functions;
    protected ArrayList<MecExpression> expressions;

    public MecSTS() {
        this.header = new MecHeader();
        this.lts = new ArrayList();
        this.synchro = new MecSync();
        this.functions = new HashMap();
        this.expressions = new ArrayList();
    }

    public MecSTS(ArrayList<MecExpression> expressions, HashMap<String, MecFunction> functions, MecHeader header, ArrayList<MecLTS> lts, MecSync synchro) {
        this.expressions = expressions;
        this.functions = functions;
        this.header = header;
        this.lts = lts;
        this.synchro = synchro;
    }

    public MecHeader getHeader() {
        return this.header;
    }

    public void setHeader(MecHeader header) {
        this.header = header;
    }

    public String getName() {
        return this.getHeader().getFileName();
    }

    public int getWidth() {
        return this.getSynchro().getWidth();
    }

    public ArrayList<MecExpression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(ArrayList<MecExpression> expressions) {
        this.expressions = expressions;
    }

    public HashMap<String, MecFunction> getFunctions() {
        return this.functions;
    }

    public void setFunctions(HashMap<String, MecFunction> functions) {
        this.functions = functions;
    }

    public ArrayList<MecLTS> getLts() {
        return this.lts;
    }

    public void setLts(ArrayList<MecLTS> lts) {
        this.lts = lts;
        int i = 2;
        while (i < lts.size()) {
            MecLTS secLTS = lts.get(i);
            secLTS.setReInitialisable();
            ++i;
        }
    }

    public MecSync getSynchro() {
        return this.synchro;
    }

    public void setSynchro(MecSync synchro) {
        this.synchro = synchro;
    }

    public void addFunction(MecFunction function) {
        this.functions.put(function.getName(), function);
    }

    public void addExpression(MecExpression expr) {
        this.expressions.add(expr);
    }

    public void defaultSession() {
        String syncSyst = this.getSynchro().getName();
        ArrayList<MecExpression> expr_list = new ArrayList<MecExpression>();
        expr_list.add(new MecExpression("sync(" + syncSyst + ", " + syncSyst + ")"));
        expr_list.add(new MecExpression("dts(" + syncSyst + ")"));
        expr_list.add(new MecExpression("finalStates := final[1] /\\ final[2]"));
        expr_list.add(MecExpression.deadf());
        expr_list.add(MecExpression.deadlockf());
        expr_list.add(MecExpression.loops());
        expr_list.add(new MecExpression("log(" + syncSyst + "Log)"));
        expr_list.add(MecExpression.version());
        expr_list.add(new MecExpression("dts(" + syncSyst + ")"));
        expr_list.add(MecExpression.wts());
        expr_list.add(MecExpression.stopLog());
        this.setExpressions(expr_list);
    }

    public void computeSyncFromServices(ArrayList<Service> runServ, ArrayList<KmlMecLink> runLinks, String chan) {
        ArrayList<MecLTS> runLTS = this.getLts();
        int width = runServ.size();
        if (ComponentKml2MecActor.verbose) {
            System.out.println("runServ size " + width + " runLTS size " + runLTS.size());
        }
        MecSync sync = this.getSynchro();
        sync.setName(this.getName());
        sync.setServices(runServ);
        int pos = 0;
        if (ComponentKml2MecActor.verbose) {
            System.out.println("\n -- Synchros --- \n ");
        }
        for (Service se : runServ) {
            ArrayList req = se.getDeepInterface().getExtrequired();
            req.remove(chan);
            req.add("_SELF");
            MecLTS lts = runLTS.get(pos);
            if (ComponentKml2MecActor.verbose) {
                System.out.println("add internals for " + se.getName() + " at " + pos);
            }
            if (ComponentKml2MecActor.verbose) {
                System.out.println("and externals on " + req);
            }
            for (Transition t : lts.getTransitions()) {
                if (t.getLabel().getExpression().isCommunication() && !req.contains(t.getLabel().getChannel().substring(1))) continue;
                sync.addLineOneCell(MecLTS.convertToMec(t.getLabel()), pos);
            }
            ++pos;
        }
        pos = 1;
        MecLTS lts = runLTS.get(pos);
        Service callserv = runServ.get(pos);
        if (ComponentKml2MecActor.verbose) {
            System.out.println("add outside communications for " + runServ.get(1).getName());
        }
        sync.addLineOneCell("start__CALLER_" + callserv.getName(), 1);
        for (Transition t : lts.getTransitions()) {
            if (ComponentKml2MecActor.verbose) {
                System.out.println("transition " + t.getLabel());
            }
            if (!t.getLabel().getExpression().isCommunication() || !t.getLabel().getChannel().equals("__CALLER")) continue;
            sync.addLineOneCell(MecLTS.convertToMec(t.getLabel()), 1);
        }
        for (KmlMecLink l : runLinks) {
            if (ComponentKml2MecActor.errverbose) {
                System.out.println("study: " + l.toString());
            }
            if (l.getLinktype() == 3 && l.getLinktype() == 4) {
                if (!ComponentKml2MecActor.errverbose) continue;
                System.err.println("WARNING: the type of link " + l.toString() + " is not correct.");
                continue;
            }
            String callchan = l.getCallChannel();
            String provchan = l.getProvChannel();
            int callpos = runServ.indexOf(l.getCallServ());
            int provpos = runServ.indexOf(l.getProvServ());
            if (l.getLinktype() == 2 || l.getLinktype() == 5 || l.getLinktype() == 6) {
                sync.addLineTwoCell("call" + callchan + "_" + l.getServname1(), callpos, "start" + provchan + "_" + l.getServname2(), provpos);
                sync.addLineTwoCell("rcv_result" + callchan + "_" + l.getServname1(), callpos, "emit_result" + provchan + "_" + l.getServname2(), provpos);
            } else {
                sync.addLineTwoCell("call" + callchan + "_" + l.getServname2(), callpos, "start" + provchan + "_" + l.getServname1(), provpos);
                sync.addLineTwoCell("rcv_result" + callchan + "_" + l.getServname2(), callpos, "emit_result" + provchan + "_" + l.getServname1(), provpos);
            }
            System.out.println(sync.toString());
            if (ComponentKml2MecActor.errverbose) {
                System.out.println("looking for " + callchan + " in " + runLTS.get(callpos).getServiceName());
            }
            ArrayList rcvCall = runLTS.get(callpos).getFilteredActions(callchan, 8);
            ArrayList emitCall = runLTS.get(callpos).getFilteredActions(callchan, 16);
            ArrayList rcvProv = runLTS.get(provpos).getFilteredActions(provchan, 8);
            ArrayList emitProv = runLTS.get(provpos).getFilteredActions(provchan, 16);
            if (ComponentKml2MecActor.errverbose) {
                System.out.println("Com   rcvCall " + rcvCall + " emitCall " + emitCall + " rcvProv " + rcvProv + " emitProv " + emitProv);
            }
            for (KmlCommunication msgc : rcvCall) {
                for (KmlCommunication msgp : emitProv) {
                    if (!msgc.getCommunicationName().equals(msgp.getCommunicationName())) continue;
                    sync.addLineTwoCell("rcv" + Kml2mecUtils.toMecString(msgc.getRawValue()), callpos, "emit" + Kml2mecUtils.toMecString(msgp.getRawValue()), provpos);
                }
            }
            for (KmlCommunication msgc : emitCall) {
                for (KmlCommunication msgp : rcvProv) {
                    if (!msgc.getCommunicationName().equals(msgp.getCommunicationName())) continue;
                    sync.addLineTwoCell("emit" + Kml2mecUtils.toMecString(msgc.getRawValue()), callpos, "rcv" + Kml2mecUtils.toMecString(msgp.getRawValue()), provpos);
                }
            }
        }
    }

    public String toString() {
        String s = this.getHeader().toString();
        s = String.valueOf(s) + "\n \\* ------- service LTS ------- *\\ \n";
        for (MecLTS lts : this.getLts()) {
            s = String.valueOf(s) + lts.toString();
            s = String.valueOf(s) + "\n";
        }
        s = String.valueOf(s) + "\\* ------- Synchronization constraint ------- *\\ \n";
        s = String.valueOf(s) + this.synchro.toString();
        s = String.valueOf(s) + "\n \\* ------- User defined functions ------- *\\ \n";
        for (MecFunction f : this.getFunctions().values()) {
            s = String.valueOf(s) + f.toString();
            s = String.valueOf(s) + "\n";
        }
        s = String.valueOf(s) + "\\* ------- Mec expressions ------- *\\ \n";
        for (MecExpression e : this.getExpressions()) {
            s = String.valueOf(s) + e.toString();
            s = String.valueOf(s) + ";\n";
        }
        return s;
    }
}

