/*
 * Decompiled with CFR 0.152.
 */
package kml2mec;

import costo.graph.Service;
import costolib_plugin_kml2mec.ComponentKml2MecActor;
import java.util.ArrayList;
import java.util.Iterator;
import kml2mec.Kml2mecUtils;

public class MecSync {
    protected String name;
    protected ArrayList<Service> services;
    protected ArrayList<ArrayList<String>> synclist;

    public MecSync() {
        this.name = "noname";
        this.services = new ArrayList();
        this.synclist = new ArrayList();
    }

    public MecSync(String name, ArrayList<Service> services) {
        this.name = name;
        this.services = services;
        this.synclist = new ArrayList();
    }

    public ArrayList<Service> getServices() {
        return this.services;
    }

    public void setServices(ArrayList<Service> services) {
        this.services = services;
    }

    public ArrayList<ArrayList<String>> getSynclist() {
        return this.synclist;
    }

    private static boolean isEqualTo(ArrayList<String> aLine, ArrayList<String> aLine1) {
        boolean exists;
        boolean bl = exists = aLine.size() == aLine1.size();
        if (exists) {
            for (String l : aLine) {
                for (String l1 : aLine1) {
                    if (l.equals(l1)) continue;
                    return false;
                }
            }
        }
        return exists;
    }

    private boolean existsLine(ArrayList<String> aLine) {
        boolean exists = false;
        for (ArrayList<String> line : this.getSynclist()) {
            if (!MecSync.isEqualTo(line, aLine)) continue;
            return true;
        }
        return exists;
    }

    private void addLine(ArrayList<String> aLine) {
        if (!this.existsLine(aLine)) {
            this.synclist.add(aLine);
            if (ComponentKml2MecActor.errverbose) {
                System.out.println("line added " + aLine);
            }
        }
    }

    public void addLineOneCell(String aCell, int position) {
        ArrayList<String> line = this.defaultLine();
        line.set(position, aCell);
        this.addLine(line);
    }

    public void addLineTwoCell(String aCell, int position, String aCell1, int position1) {
        if (position != position1) {
            ArrayList<String> line = this.defaultLine();
            line.set(position, aCell);
            line.set(position1, aCell1);
            this.addLine(line);
        } else {
            System.err.println("Warning: use addLineOneCell for " + aCell + "/" + aCell1 + " at " + position + "/" + position1);
        }
    }

    private ArrayList<String> defaultLine() {
        ArrayList<String> dfl = new ArrayList<String>();
        int i = 1;
        while (i <= this.getWidth()) {
            dfl.add("e");
            ++i;
        }
        return dfl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getWidth() {
        return this.getServices().size();
    }

    public String toString() {
        String s = "synchronization_system " + this.getName();
        s = String.valueOf(s) + " <width = " + this.getServices().size() + " ;\n";
        s = String.valueOf(s) + "   list = ( ";
        int leng = this.getServices().size();
        Iterator<Object> iterator = this.getServices().iterator();
        while (iterator.hasNext()) {
            Service service;
            Service orig = service = iterator.next();
            while (orig.isPromoted()) {
                orig = orig.getOriginalservice();
            }
            s = String.valueOf(s) + Kml2mecUtils.toMecString(orig.getFullName());
            if (--leng <= 0) continue;
            s = String.valueOf(s) + ", ";
        }
        s = String.valueOf(s) + " )>; \n";
        leng = this.getSynclist().size();
        for (ArrayList arrayList : this.getSynclist()) {
            s = String.valueOf(s) + "( ";
            int leng2 = arrayList.size();
            for (String cell : arrayList) {
                s = String.valueOf(s) + cell;
                if (--leng2 <= 0) continue;
                s = String.valueOf(s) + " .";
            }
            s = --leng > 0 ? String.valueOf(s) + " );\n" : String.valueOf(s) + " ).\n";
        }
        return s;
    }
}

