/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_tdata.mut;

import costo.graph.Component;
import costo.graph.ComponentVariable;
import costo.graph.Label;
import costo.graph.Service;
import costo.graph.Transition;
import costo.graph.expressions.KmlBinOP;
import costo.graph.expressions.KmlCondition;
import costo.kml2java.export.JavaExpressionEvaluatorVisitor;
import costolib_plugin_tdata.mut.Utile;
import costolib_plugin_tdata.utils.ClasspathHacker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JOptionPane;

public class MutantCreator {
    private int mutantId = 0;
    private String path = "";
    private String mutantRootDir = "";
    private List<String> compareOperators = new ArrayList<String>();
    private List<String> arithmOperators = new ArrayList<String>();
    private Component cut = null;
    private String sutName = "";
    private boolean isOk = false;
    private String mutantDir = "";
    private Component componentTH = null;

    public MutantCreator(Component compTh) {
        this.componentTH = compTh;
        this.path = compTh.getFactory().getAbsSpecDir();
        this.initialise(compTh);
    }

    private void initialise(Component compTh) {
        ArrayList subcomplist = compTh.getComposition().getAssembly().getNamedComponentsWithoutSelf();
        for (ComponentVariable compVar : subcomplist) {
            if (!compVar.getVarName().endsWith("_cut")) continue;
            this.cut = compVar.getComponentType();
            break;
        }
        if (this.cut == null) {
            JOptionPane.showMessageDialog(null, "Can't set CUT Component!\nExecution stopped.", "Errors", 0);
            return;
        }
        this.isOk = true;
        this.sutName = "computeSpeed";
        this.mutantRootDir = String.valueOf(this.path) + File.separator + "mutants";
        File dir = new File(this.mutantRootDir);
        if (!dir.isDirectory() && !dir.mkdir()) {
            JOptionPane.showMessageDialog(null, "Can't mutant root directory!\nHarness construction stopped.", "Errors", 0);
            this.isOk = false;
            return;
        }
        this.compareOperators.add("=");
        this.compareOperators.add("<>");
        this.compareOperators.add(">");
        this.compareOperators.add(">=");
        this.compareOperators.add("<");
        this.compareOperators.add("<=");
        this.arithmOperators.add("+");
        this.arithmOperators.add("-");
        this.arithmOperators.add("*");
        this.arithmOperators.add("/");
    }

    private void initMutant() {
        ++this.mutantId;
        this.mutantDir = String.valueOf(this.mutantRootDir) + File.separator + "Mutant" + this.mutantId;
        File dir = new File(this.mutantDir);
        if (!dir.isDirectory() && !dir.mkdir()) {
            JOptionPane.showMessageDialog(null, "Can't create mutant directory!\nHarness construction stopped.", "Errors", 0);
            this.isOk = false;
            return;
        }
        String originalDir = String.valueOf(this.path) + File.separator + "original";
        File orgDir = new File(originalDir);
        if (orgDir.isDirectory()) {
            try {
                File mutanFolder = new File(this.mutantDir);
                Utile.copyFolder(orgDir, mutanFolder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(null, "Can't copy data into mutant directory!\nHarness construction stopped.", "Errors", 0);
            this.isOk = false;
            return;
        }
    }

    public boolean generateNewMutant() {
        Service sut;
        Service sutSaved = sut = this.cut.getService(this.sutName);
        JavaExpressionEvaluatorVisitor visitor = new JavaExpressionEvaluatorVisitor(this.cut, sut, null, null);
        int counter = 0;
        for (Transition t : sut.getBehavior().getTransitions()) {
            int numLine = -1;
            String txtLine = "";
            boolean found = false;
            Label label = t.getLabel();
            KmlCondition guard = label.getGuard();
            if (guard != null) {
                String oldRwavalu;
                visitor.visit(guard);
                List conditions = visitor.getConditions();
                String rawValue = oldRwavalu = guard.getRawValue();
                for (KmlBinOP condition : conditions) {
                    if (!rawValue.contains(condition.getRawValue()) || ++counter <= this.mutantId) continue;
                    this.initMutant();
                    String oldChar = condition.getRawValue();
                    condition.setOperator(MutantCreator.getRandomCompOp(this.compareOperators, condition.getOperator()));
                    String newChar = condition.getRawValue();
                    rawValue = rawValue.replace(oldChar, newChar);
                    found = true;
                    break;
                }
                if (found) {
                    String coma = "";
                    if (!t.getTarget().getName().equals("f")) {
                        coma = ",";
                    }
                    txtLine = "//////////// MUTANT #" + this.mutantId + "# //////////\n" + t.toString() + coma + "   //Old: " + oldRwavalu + "\n//////////// MUTANT #" + this.mutantId + "# //////////";
                    numLine = t.getLabel().getGuard().getLine();
                }
            }
            if (!found) continue;
            this.createComponentFile(numLine, txtLine);
            sut = sutSaved;
            return true;
        }
        return false;
    }

    private static String getRandomCompOp(List<String> operators, String oldOp) {
        int idxOld;
        int idxNew = idxOld = operators.indexOf(oldOp);
        Random rn = new Random();
        while (idxNew == idxOld) {
            idxNew = Math.abs(rn.nextInt(operators.size()));
        }
        return operators.get(idxNew);
    }

    private boolean createComponentFile(int numLine, String txtLine) {
        if (numLine < 0 || txtLine.isEmpty()) {
            return false;
        }
        try {
            String line;
            BufferedReader file = new BufferedReader(new FileReader(String.valueOf(this.path) + File.separator + this.cut.getName() + ".kcp"));
            String input = "";
            int counter = 0;
            while ((line = file.readLine()) != null) {
                input = ++counter == numLine ? String.valueOf(input) + txtLine + '\n' : String.valueOf(input) + line + '\n';
            }
            FileOutputStream outFile = new FileOutputStream(String.valueOf(this.mutantDir) + File.separator + this.cut.getName() + ".kcp");
            outFile.write(input.getBytes());
            outFile.close();
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getMutantDir() {
        return this.mutantDir;
    }

    public void cleanMutant(String projectDir) {
        System.out.println("************ cleanMutant " + this.mutantId + " ***********");
        String srcDir = String.valueOf(projectDir) + File.separator + "bin";
        File srcFolder = new File(srcDir);
        MutantCreator.deleteFolder(srcFolder);
        String binDir = String.valueOf(projectDir) + File.separator + "bin";
        File binFolder = new File(binDir);
        MutantCreator.deleteFolder(binFolder);
        System.out.println("************ cleanMutant " + this.mutantId + "***********");
    }

    public int getMutantId() {
        return this.mutantId;
    }

    public void launchMutant(String dir, String packageName) {
        try {
            File file = new File(String.valueOf(dir) + "bin");
            URL url = file.toURI().toURL();
            URL[] urls = new URL[]{url};
            URLClassLoader cLoader = new URLClassLoader(urls);
            String className = String.valueOf(packageName) + ".Mutation" + this.componentTH.getName();
            Class<?> cls = cLoader.loadClass(className);
            Method method = cls.getMethod("main", String[].class);
            String[] params = new String[]{"" + this.mutantId, this.mutantDir};
            method.invoke(null, new Object[]{params});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadSpecificsJars(String projetcDir) {
        String dirJars = String.valueOf(projetcDir) + File.separator + "lib" + File.separator;
        try {
            ClasspathHacker.addFile(String.valueOf(dirJars) + "costo.kml2java.jar");
            ClasspathHacker.addFile(String.valueOf(dirJars) + "jdom-2.0.5.jar");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Can't find Jars in [" + dirJars + "] !\nHarness construction stopped.", "Errors", 0);
            this.isOk = false;
            e.printStackTrace();
        }
    }

    public static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    MutantCreator.deleteFolder(f);
                    f.delete();
                } else {
                    f.delete();
                }
                ++n2;
            }
        }
    }

    public boolean isOk() {
        return this.isOk;
    }
}

